/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.maven.deployer.monolithic;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.cocoon.maven.deployer.monolithic.DeploymentException;
import org.apache.cocoon.maven.deployer.monolithic.RuleBasedZipExtractor;
import org.apache.cocoon.maven.deployer.monolithic.SingleFileDeployer;
import org.apache.cocoon.maven.deployer.monolithic.XPatchDeployer;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;

public class MonolithicCocoonDeployer {
    private Log logger;

    public MonolithicCocoonDeployer(Log logger) {
        this.logger = logger;
    }

    public void deploy(Map libraries, File basedir) throws DeploymentException {
        XPatchDeployer xwebPatcher = new XPatchDeployer("WEB-INF");
        xwebPatcher.setLogger(this.logger);
        Iterator it = libraries.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object id = entry.getKey();
            File lib = (File)entry.getValue();
            try {
                this.logger.info((CharSequence)("Deploying " + id));
                RuleBasedZipExtractor zipExtractor = new RuleBasedZipExtractor(basedir, this.logger);
                zipExtractor.addRule("WEB-INF/db/**", new SingleFileDeployer("WEB-INF/db"));
                zipExtractor.addRule("META-INF/xpatch/*.xweb", xwebPatcher);
                zipExtractor.extract(lib);
            }
            catch (IOException e) {
                throw new DeploymentException("Can't deploy '" + lib.getAbsolutePath() + "'.", e);
            }
        }
        FileInputStream sourceWebXmlFile = null;
        File webXml = new File(basedir, "WEB-INF/web.xml");
        try {
            sourceWebXmlFile = new FileInputStream(webXml);
            xwebPatcher.applyPatches(sourceWebXmlFile, "WEB-INF/web.xml");
        }
        catch (FileNotFoundException e) {
            try {
                throw new DeploymentException("Can't apply patches on " + webXml + ".", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(sourceWebXmlFile);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)sourceWebXmlFile);
    }
}

