/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.source.impl.TraversableContextSource;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.commons.lang.BooleanUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.TraversableSource;
import org.apache.excalibur.source.URIAbsolutizer;

public class ContextSourceFactory
extends AbstractLogEnabled
implements SourceFactory,
Serviceable,
Contextualizable,
ThreadSafe,
URIAbsolutizer {
    protected ServiceManager manager;
    protected ServletContext servletContext;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this.servletContext = (Context)context.get((Object)"environment-context");
    }

    public Source getSource(String location, Map parameters) throws IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Creating source object for " + location));
        }
        SourceResolver resolver = null;
        try {
            resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
            int pos = location.indexOf(":/");
            String scheme = location.substring(0, pos);
            String path = location.substring(pos + 2);
            if (path.indexOf("../") != -1) {
                throw new MalformedURLException("Invalid path ('../' is not allowed) : " + path);
            }
            String actualPath = this.servletContext.getRealPath(path);
            URL u = actualPath != null ? new File(actualPath).toURL() : this.servletContext.getResource(path);
            if (u != null) {
                Set children;
                Source source = resolver.resolveURI(u.toExternalForm());
                if (parameters != null && BooleanUtils.toBoolean((String)"force-traversable") && this.servletContext != null && !(source instanceof TraversableSource) && (children = this.servletContext.getResourcePaths(path + '/')) != null) {
                    source = new TraversableContextSource(source, children, this, path, scheme);
                }
                Source source2 = source;
                return source2;
            }
            try {
                String message = location + " could not be found. (possible context problem)";
                this.getLogger().info((Object)message);
                throw new MalformedURLException(message);
            }
            catch (ServiceException se) {
                throw new SourceException("Unable to lookup source resolver.", (Throwable)se);
            }
        }
        finally {
            this.manager.release((Object)resolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Source source) {
        if (source != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Releasing source " + source.getURI()));
            }
            SourceResolver resolver = null;
            try {
                resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                if (source instanceof TraversableContextSource) {
                    resolver.release(((TraversableContextSource)source).wrappedSource);
                } else {
                    resolver.release(source);
                }
            }
            catch (ServiceException serviceException) {
            }
            finally {
                this.manager.release((Object)resolver);
            }
        }
    }

    public String absolutize(String baseURI, String location) {
        return SourceUtil.absolutize((String)baseURI, (String)location, (boolean)true);
    }
}

