/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.xslt;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.util.location.LocationUtils;
import org.apache.commons.logging.Log;

public class XSLTProcessorErrorListener
implements ErrorListener {
    private final Log logger;
    private final String uri;
    private TransformerException warningEx;
    private TransformerException exception;

    public XSLTProcessorErrorListener(Log logger, String uri) {
        this.logger = logger;
        this.uri = uri;
    }

    public Throwable getThrowable() {
        if (this.exception == null) {
            return null;
        }
        Location loc = LocationUtils.getLocation((Object)this.exception);
        if (LocationUtils.isKnown((Location)loc)) {
            return this.exception;
        }
        if (this.exception.getCause() != null) {
            return this.exception.getCause();
        }
        return this.exception;
    }

    public void warning(TransformerException ex) throws TransformerException {
        if (this.logger.isWarnEnabled()) {
            Location loc = LocationUtils.getLocation((Object)ex);
            this.logger.warn((Object)(ex.getMessage() + " at " + loc == null ? this.uri : loc.toString()));
        }
        this.warningEx = ex;
    }

    public void error(TransformerException ex) throws TransformerException {
        if (this.warningEx != null && ex.getCause() == null) {
            ex = this.warningEx;
        }
        this.warningEx = null;
        this.exception = ex;
        throw ex;
    }

    public void fatalError(TransformerException ex) throws TransformerException {
        if (this.warningEx != null && ex.getCause() == null) {
            ex = this.warningEx;
        }
        this.warningEx = null;
        this.exception = ex;
        throw ex;
    }
}

