/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.reading;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RescaleOp;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import javax.swing.ImageIcon;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.ResourceReader;
import org.apache.commons.lang.SystemUtils;
import org.xml.sax.SAXException;

public final class ImageReader
extends ResourceReader {
    private static final boolean GRAYSCALE_DEFAULT = false;
    private static final boolean ENLARGE_DEFAULT = true;
    private static final boolean FIT_DEFAULT = false;
    private static final boolean JVMBugFixed = SystemUtils.isJavaVersionAtLeast((float)1.4f);
    private int width;
    private int height;
    private float[] scaleColor = new float[3];
    private float[] offsetColor = new float[3];
    private float[] quality = new float[1];
    private boolean enlarge;
    private boolean fitUniform;
    private boolean usePercent;
    private RescaleOp colorFilter;
    private ColorConvertOp grayscaleFilter;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        String tmpWidth = par.getParameter("width", "0");
        String tmpHeight = par.getParameter("height", "0");
        this.scaleColor[0] = par.getParameterAsFloat("scaleRed", -1.0f);
        this.scaleColor[1] = par.getParameterAsFloat("scaleGreen", -1.0f);
        this.scaleColor[2] = par.getParameterAsFloat("scaleBlue", -1.0f);
        this.offsetColor[0] = par.getParameterAsFloat("offsetRed", 0.0f);
        this.offsetColor[1] = par.getParameterAsFloat("offsetGreen", 0.0f);
        this.offsetColor[2] = par.getParameterAsFloat("offsetBlue", 0.0f);
        this.quality[0] = par.getParameterAsFloat("quality", 0.9f);
        boolean filterColor = false;
        for (int i = 0; i < 3; ++i) {
            if (this.scaleColor[i] != -1.0f) {
                filterColor = true;
            } else {
                this.scaleColor[i] = 1.0f;
            }
            if (this.offsetColor[i] == 0.0f) continue;
            filterColor = true;
        }
        if (filterColor) {
            this.colorFilter = new RescaleOp(this.scaleColor, this.offsetColor, null);
        }
        this.usePercent = false;
        char lastChar = tmpWidth.charAt(tmpWidth.length() - 1);
        if (lastChar == '%') {
            this.usePercent = true;
            this.width = Integer.parseInt(tmpWidth.substring(0, tmpWidth.length() - 1));
        } else {
            this.width = Integer.parseInt(tmpWidth);
        }
        lastChar = tmpHeight.charAt(tmpHeight.length() - 1);
        if (lastChar == '%') {
            this.usePercent = true;
            this.height = Integer.parseInt(tmpHeight.substring(0, tmpHeight.length() - 1));
        } else {
            this.height = Integer.parseInt(tmpHeight);
        }
        if (par.getParameterAsBoolean("grayscale", false)) {
            this.grayscaleFilter = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        }
        this.enlarge = par.getParameterAsBoolean("allow-enlarging", true);
        this.fitUniform = par.getParameterAsBoolean("fit-uniform", false);
        super.setup(resolver, objectModel, src, par);
    }

    protected void setupHeaders() {
        if (this.byteRanges && this.hasTransform()) {
            this.byteRanges = false;
        }
        super.setupHeaders();
    }

    private boolean hasTransform() {
        return this.width > 0 || this.height > 0 || null != this.colorFilter || null != this.grayscaleFilter || this.quality[0] != 0.9f;
    }

    private AffineTransform getTransform(double ow, double oh, double nw, double nh) {
        double wm = 1.0;
        double hm = 1.0;
        if (this.fitUniform) {
            if (ow / oh > nw / nh) {
                nh = 0.0;
            } else {
                nw = 0.0;
            }
        }
        if (nw > 0.0) {
            wm = nw / ow;
            hm = nh > 0.0 ? nh / oh : wm;
        } else if (nh > 0.0) {
            wm = hm = nh / oh;
        }
        if (!this.enlarge) {
            if (nw > ow && nh <= 0.0 || nh > oh && nw <= 0.0) {
                wm = 1.0;
                hm = 1.0;
            } else if (nw > ow) {
                wm = 1.0;
            } else if (nh > oh) {
                hm = 1.0;
            }
        }
        return new AffineTransform(wm, 0.0, 0.0, hm, 0.0, 0.0);
    }

    protected byte[] readFully(InputStream in) throws IOException {
        int i;
        byte[] tmpbuffer = new byte[4096];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (-1 != (i = in.read(tmpbuffer))) {
            baos.write(tmpbuffer, 0, i);
        }
        baos.flush();
        return baos.toByteArray();
    }

    protected void processStream(InputStream inputStream) throws IOException, ProcessingException {
        if (this.hasTransform()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("image " + (this.width == 0 ? "?" : Integer.toString(this.width)) + "x" + (this.height == 0 ? "?" : Integer.toString(this.height)) + " expires: " + this.expires));
            }
            try {
                BufferedImage original;
                byte[] content = this.readFully(inputStream);
                ImageIcon icon = new ImageIcon(content);
                BufferedImage currentImage = original = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 1);
                currentImage.getGraphics().drawImage(icon.getImage(), 0, 0, null);
                if (this.width > 0 || this.height > 0) {
                    double ow = icon.getImage().getWidth(null);
                    double oh = icon.getImage().getHeight(null);
                    if (this.usePercent) {
                        if (this.width > 0) {
                            this.width = Math.round((int)(ow * (double)this.width) / 100);
                        }
                        if (this.height > 0) {
                            this.height = Math.round((int)(oh * (double)this.height) / 100);
                        }
                    }
                    AffineTransformOp filter = new AffineTransformOp(this.getTransform(ow, oh, this.width, this.height), 2);
                    WritableRaster scaledRaster = filter.createCompatibleDestRaster(currentImage.getRaster());
                    filter.filter(currentImage.getRaster(), scaledRaster);
                    currentImage = new BufferedImage(original.getColorModel(), scaledRaster, true, null);
                }
                if (null != this.grayscaleFilter) {
                    this.grayscaleFilter.filter(currentImage, currentImage);
                }
                if (null != this.colorFilter) {
                    this.colorFilter.filter(currentImage, currentImage);
                }
                if (JVMBugFixed) {
                    JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)this.out);
                    JPEGEncodeParam p = encoder.getDefaultJPEGEncodeParam(currentImage);
                    p.setQuality(this.quality[0], true);
                    encoder.setJPEGEncodeParam(p);
                    encoder.encode(currentImage);
                } else {
                    ByteArrayOutputStream bstream = new ByteArrayOutputStream();
                    JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)bstream);
                    JPEGEncodeParam p = encoder.getDefaultJPEGEncodeParam(currentImage);
                    p.setQuality(this.quality[0], true);
                    encoder.setJPEGEncodeParam(p);
                    encoder.encode(currentImage);
                    this.out.write(bstream.toByteArray());
                }
                this.out.flush();
            }
            catch (ImageFormatException e) {
                throw new ProcessingException("Error reading the image. Note that only JPEG images are currently supported.");
            }
            finally {
                inputStream.close();
            }
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"passing original resource");
            }
            super.processStream(inputStream);
        }
    }

    public Serializable getKey() {
        return super.getKey().toString() + ':' + this.fitUniform + ':' + this.enlarge + ':' + this.width + ':' + this.height + ":" + this.scaleColor[0] + ":" + this.scaleColor[1] + ":" + this.scaleColor[2] + ":" + this.offsetColor[0] + ":" + this.offsetColor[1] + ":" + this.offsetColor[2] + ":" + this.quality[0] + ":" + (this.grayscaleFilter == null ? "color" : "bw");
    }

    public void recycle() {
        super.recycle();
        this.colorFilter = null;
        this.grayscaleFilter = null;
    }
}

