/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpSession;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class EncodeURLTransformer
extends AbstractTransformer
implements Configurable,
CacheableProcessingComponent {
    public static final String EXCLUDE_NAME = "exclude-name";
    public static final String INCLUDE_NAME = "include-name";
    public static final String EXCLUDE_NAME_DEFAULT = "img/@src=";
    public static final String INCLUDE_NAME_DEFAULT = ".*/@href=|.*/@action=|frame/@src=";
    private String includeNameConfigure = ".*/@href=|.*/@action=|frame/@src=";
    private String excludeNameConfigure = "img/@src=";
    private ElementAttributeMatching elementAttributeMatching;
    private Response response;
    private boolean isEncodeURLNeeded;
    private HttpSession session;

    protected void checkForEncoding(Request request) {
        this.session = request.getSession(false);
        this.isEncodeURLNeeded = false;
        if (null != this.session && (request.isRequestedSessionIdFromURL() || this.session.isNew())) {
            this.isEncodeURLNeeded = true;
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.checkForEncoding(ObjectModelHelper.getRequest((Map)objectModel));
        if (this.isEncodeURLNeeded) {
            this.response = ObjectModelHelper.getResponse((Map)objectModel);
            String includeName = parameters.getParameter(INCLUDE_NAME, this.includeNameConfigure);
            String excludeName = parameters.getParameter(EXCLUDE_NAME, this.excludeNameConfigure);
            try {
                this.elementAttributeMatching = new ElementAttributeMatching(includeName, excludeName);
            }
            catch (PatternSyntaxException reex) {
                String message = "Cannot parse include-name: " + includeName + " " + "or exclude-name: " + excludeName + "!";
                throw new ProcessingException(message, (Throwable)reex);
            }
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration child = configuration.getChild(INCLUDE_NAME);
        this.includeNameConfigure = child.getValue(INCLUDE_NAME_DEFAULT);
        child = configuration.getChild(EXCLUDE_NAME);
        this.excludeNameConfigure = child.getValue(EXCLUDE_NAME_DEFAULT);
        if (this.includeNameConfigure == null) {
            String message = "Configure include-name!";
            throw new ConfigurationException(message);
        }
        if (this.excludeNameConfigure == null) {
            String message = "Configure exclude-name!";
            throw new ConfigurationException(message);
        }
    }

    public void recycle() {
        super.recycle();
        this.response = null;
        this.session = null;
        this.elementAttributeMatching = null;
    }

    public Serializable getKey() {
        if (this.isEncodeURLNeeded) {
            return null;
        }
        return "1";
    }

    public SourceValidity getValidity() {
        if (this.isEncodeURLNeeded) {
            return null;
        }
        return NOPValidity.SHARED_INSTANCE;
    }

    public void startElement(String uri, String name, String raw, Attributes attributes) throws SAXException {
        if (this.isEncodeURLNeeded && this.elementAttributeMatching != null && attributes != null && attributes.getLength() > 0) {
            AttributesImpl new_attributes = new AttributesImpl(attributes);
            for (int i = 0; i < new_attributes.getLength(); ++i) {
                String value;
                String attr_lname = new_attributes.getLocalName(i);
                if (!this.elementAttributeMatching.matchesElementAttribute(name, attr_lname, value = new_attributes.getValue(i))) continue;
                String new_value = this.encodeURL(value);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("element/@attribute matches: " + name + "/@" + attr_lname));
                    this.getLogger().debug((Object)("encodeURL: " + value + " -> " + new_value));
                }
                new_attributes.setValue(i, new_value);
            }
            this.contentHandler.startElement(uri, name, raw, new_attributes);
            return;
        }
        this.contentHandler.startElement(uri, name, raw, attributes);
    }

    protected String encodeURL(String url) {
        String encoded_url = this.response != null ? (this.session != null && url.indexOf(this.session.getId()) > -1 ? url : this.response.encodeURL(url)) : url;
        return encoded_url;
    }

    public static class ElementAttributeMatching {
        protected Pattern includeNameRE;
        protected Pattern excludeNameRE;

        public ElementAttributeMatching(String includeName, String excludeName) throws PatternSyntaxException {
            this.includeNameRE = Pattern.compile(includeName, 2);
            this.excludeNameRE = Pattern.compile(excludeName, 2);
        }

        public boolean matchesElementAttribute(String element_name, String attr_name, String value) {
            String element_attr_name = this.canonicalizeElementAttribute(element_name, attr_name, value);
            if (this.excludeNameRE != null && this.includeNameRE != null) {
                return !this.matchesExcludesElementAttribute(element_attr_name) && this.matchesIncludesElementAttribute(element_attr_name);
            }
            return false;
        }

        private String canonicalizeElementAttribute(String element_name, String attr_name, String value) {
            return element_name + "/@" + attr_name + "=" + value;
        }

        private boolean matchesExcludesElementAttribute(String element_attr_name) {
            boolean match = this.excludeNameRE.matcher(element_attr_name).lookingAt();
            return match;
        }

        private boolean matchesIncludesElementAttribute(String element_attr_name) {
            boolean match = this.includeNameRE.matcher(element_attr_name).lookingAt();
            return match;
        }
    }
}

