/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.pipeline.impl;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.caching.Cache;
import org.apache.cocoon.components.pipeline.AbstractProcessingPipeline;
import org.apache.cocoon.components.sax.XMLByteStreamCompiler;
import org.apache.cocoon.components.sax.XMLByteStreamInterpreter;

public abstract class BaseCachingProcessingPipeline
extends AbstractProcessingPipeline
implements Disposable {
    protected Cache cache;
    protected XMLByteStreamInterpreter xmlDeserializer;
    protected XMLByteStreamCompiler xmlSerializer;

    @Override
    public void parameterize(Parameters params) throws ParameterException {
        super.parameterize(params);
        String cacheRole = params.getParameter("cache-role", Cache.ROLE);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Using cache " + cacheRole));
        }
        try {
            this.cache = (Cache)this.manager.lookup(cacheRole);
        }
        catch (ServiceException ce) {
            throw new ParameterException("Unable to lookup cache: " + cacheRole, (Throwable)ce);
        }
    }

    @Override
    public void recycle() {
        this.xmlDeserializer = null;
        this.xmlSerializer = null;
        super.recycle();
    }

    public void dispose() {
        if (null != this.manager) {
            this.manager.release((Object)this.cache);
        }
        this.cache = null;
        this.manager = null;
    }
}

