/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.pipeline.impl;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CachedResponse;
import org.apache.cocoon.caching.CachingOutputStream;
import org.apache.cocoon.caching.ComponentCacheKey;
import org.apache.cocoon.components.pipeline.impl.AbstractCachingProcessingPipeline;
import org.apache.cocoon.components.sax.XMLByteStreamCompiler;
import org.apache.cocoon.components.sax.XMLByteStreamInterpreter;
import org.apache.cocoon.components.sax.XMLTeePipe;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLProducer;
import org.apache.excalibur.source.SourceValidity;

public class CachingPointProcessingPipeline
extends AbstractCachingProcessingPipeline {
    protected ArrayList isCachePoint = new ArrayList();
    protected ArrayList xmlSerializerArray = new ArrayList();
    protected boolean nextIsCachePoint = false;
    protected String autoCachingPointSwitch;
    protected boolean autoCachingPoint = true;

    @Override
    public void parameterize(Parameters config) throws ParameterException {
        super.parameterize(config);
        this.autoCachingPointSwitch = config.getParameter("autoCachingPoint", null);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Auto caching-point is set to = '" + this.autoCachingPointSwitch + "'"));
        }
        if (this.autoCachingPointSwitch == null) {
            this.autoCachingPoint = true;
            return;
        }
        this.autoCachingPoint = this.autoCachingPointSwitch.toLowerCase().equals("on");
    }

    @Override
    public void setGenerator(String role, String source, Parameters param, Parameters hintParam) throws ProcessingException {
        String pipelinehint;
        block4: {
            super.setGenerator(role, source, param, hintParam);
            pipelinehint = null;
            try {
                pipelinehint = hintParam.getParameter("caching-point", null);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("generator caching-point pipeline-hint is set to: " + pipelinehint));
                }
            }
            catch (Exception ex) {
                if (!this.getLogger().isWarnEnabled()) break block4;
                this.getLogger().warn((Object)("caching-point hint Exception, pipeline-hint ignored: " + ex));
            }
        }
        if ("true".equals(pipelinehint)) {
            this.nextIsCachePoint = true;
        }
    }

    @Override
    public void addTransformer(String role, String source, Parameters param, Parameters hintParam) throws ProcessingException {
        String pipelinehint;
        block4: {
            super.addTransformer(role, source, param, hintParam);
            pipelinehint = null;
            try {
                pipelinehint = hintParam.getParameter("caching-point", null);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("transformer caching-point pipeline-hint is set to: " + pipelinehint));
                }
            }
            catch (Exception ex) {
                if (!this.getLogger().isWarnEnabled()) break block4;
                this.getLogger().warn((Object)("caching-point hint Exception, pipeline-hint ignored: " + ex));
            }
        }
        this.isCachePoint.add(this.nextIsCachePoint);
        this.nextIsCachePoint = false;
        if ("true".equals(pipelinehint)) {
            this.nextIsCachePoint = true;
        }
    }

    @Override
    public void informBranchPoint() {
        if (this.generator == null) {
            return;
        }
        if (!this.autoCachingPoint) {
            return;
        }
        this.nextIsCachePoint = true;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Informed Pipeline of branch point");
        }
    }

    @Override
    protected CachedResponse cacheResults(Environment environment, OutputStream os) throws Exception {
        CachedResponse completeCachedResponse = null;
        if (this.toCacheKey != null) {
            if (this.cacheCompleteResponse) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Cached: caching complete response; pSisze" + this.toCacheKey.size() + " Key " + this.toCacheKey));
                }
                CachedResponse response = new CachedResponse(this.toCacheSourceValidities, ((CachingOutputStream)os).getContent());
                response.setContentType(environment.getContentType());
                this.cache.store((Serializable)this.toCacheKey.copy(), response);
                completeCachedResponse = response;
                this.toCacheKey.removeUntilCachePoint();
                if (this.toCacheKey.size() > 0) {
                    SourceValidity[] copy = new SourceValidity[this.toCacheKey.size()];
                    System.arraycopy(this.toCacheSourceValidities, 0, copy, 0, copy.length);
                    this.toCacheSourceValidities = copy;
                }
            }
            if (this.toCacheKey.size() > 0) {
                ListIterator itt = this.xmlSerializerArray.listIterator(this.xmlSerializerArray.size());
                while (itt.hasPrevious()) {
                    XMLByteStreamCompiler serializer = (XMLByteStreamCompiler)itt.previous();
                    CachedResponse response = new CachedResponse(this.toCacheSourceValidities, (byte[])serializer.getSAXFragment());
                    this.cache.store((Serializable)this.toCacheKey.copy(), response);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("Caching results for the following key: " + this.toCacheKey));
                    }
                    this.toCacheKey.removeUntilCachePoint();
                    if (this.toCacheKey.size() == 0) break;
                    SourceValidity[] copy = new SourceValidity[this.toCacheKey.size()];
                    System.arraycopy(this.toCacheSourceValidities, 0, copy, 0, copy.length);
                    this.toCacheSourceValidities = copy;
                }
            }
        }
        return completeCachedResponse;
    }

    @Override
    protected ComponentCacheKey newComponentCacheKey(int type, String role, Serializable key) {
        boolean cachePoint = false;
        if (type == 3) {
            cachePoint = (Boolean)this.isCachePoint.get(this.firstNotCacheableTransformerIndex);
        } else if (type == 5) {
            cachePoint = this.nextIsCachePoint;
        }
        return new ComponentCacheKey(type, role, key, cachePoint);
    }

    @Override
    protected void connectCachingPipeline(Environment environment) throws ProcessingException {
        XMLByteStreamCompiler localXMLSerializer = null;
        XMLByteStreamCompiler cachePointXMLSerializer = null;
        if (!this.cacheCompleteResponse) {
            localXMLSerializer = this.xmlSerializer = new XMLByteStreamCompiler();
        }
        if (this.cachedResponse == null) {
            Object next2;
            Generator prev = this.generator;
            int cacheableTransformerCount = this.firstNotCacheableTransformerIndex;
            int currentTransformerIndex = 0;
            for (Object next2 : this.transformers) {
                if (cacheableTransformerCount > 0 && this.isCachePoint.get(currentTransformerIndex) != null && ((Boolean)this.isCachePoint.get(currentTransformerIndex)).booleanValue()) {
                    cachePointXMLSerializer = new XMLByteStreamCompiler();
                    next2 = new XMLTeePipe((XMLConsumer)next2, cachePointXMLSerializer);
                    this.xmlSerializerArray.add(cachePointXMLSerializer);
                }
                if (localXMLSerializer != null) {
                    if (cacheableTransformerCount == 0) {
                        next2 = new XMLTeePipe((XMLConsumer)next2, localXMLSerializer);
                        this.xmlSerializerArray.add(localXMLSerializer);
                        localXMLSerializer = null;
                    } else {
                        --cacheableTransformerCount;
                    }
                }
                this.connect(environment, (XMLProducer)prev, (XMLConsumer)next2);
                prev = (XMLProducer)next2;
                ++currentTransformerIndex;
            }
            next2 = this.lastConsumer;
            if (localXMLSerializer != null) {
                next2 = new XMLTeePipe((XMLConsumer)next2, localXMLSerializer);
                this.xmlSerializerArray.add(localXMLSerializer);
                localXMLSerializer = null;
            } else if (currentTransformerIndex == this.firstNotCacheableTransformerIndex && this.nextIsCachePoint) {
                cachePointXMLSerializer = new XMLByteStreamCompiler();
                next2 = new XMLTeePipe((XMLConsumer)next2, cachePointXMLSerializer);
                this.xmlSerializerArray.add(cachePointXMLSerializer);
            }
            this.connect(environment, (XMLProducer)prev, (XMLConsumer)next2);
        } else {
            Object next3;
            XMLByteStreamInterpreter prev = this.xmlDeserializer = new XMLByteStreamInterpreter();
            int cacheableTransformerCount = 0;
            for (Object next3 : this.transformers) {
                if (cacheableTransformerCount >= this.firstProcessedTransformerIndex) {
                    if (cacheableTransformerCount < this.firstNotCacheableTransformerIndex && !(prev instanceof XMLByteStreamInterpreter) && this.isCachePoint.get(cacheableTransformerCount) != null && ((Boolean)this.isCachePoint.get(cacheableTransformerCount)).booleanValue()) {
                        cachePointXMLSerializer = new XMLByteStreamCompiler();
                        next3 = new XMLTeePipe((XMLConsumer)next3, cachePointXMLSerializer);
                        this.xmlSerializerArray.add(cachePointXMLSerializer);
                    }
                    if (localXMLSerializer != null && !(prev instanceof XMLByteStreamInterpreter) && cacheableTransformerCount == this.firstNotCacheableTransformerIndex) {
                        next3 = new XMLTeePipe((XMLConsumer)next3, localXMLSerializer);
                        this.xmlSerializerArray.add(localXMLSerializer);
                        localXMLSerializer = null;
                    }
                    this.connect(environment, prev, (XMLConsumer)next3);
                    prev = (XMLProducer)next3;
                }
                ++cacheableTransformerCount;
            }
            next3 = this.lastConsumer;
            if (localXMLSerializer != null && !(prev instanceof XMLByteStreamInterpreter)) {
                next3 = new XMLTeePipe((XMLConsumer)next3, localXMLSerializer);
                this.xmlSerializerArray.add(localXMLSerializer);
                localXMLSerializer = null;
            } else if (this.nextIsCachePoint && !(prev instanceof XMLByteStreamInterpreter) && cacheableTransformerCount == this.firstNotCacheableTransformerIndex) {
                cachePointXMLSerializer = new XMLByteStreamCompiler();
                next3 = new XMLTeePipe((XMLConsumer)next3, cachePointXMLSerializer);
                this.xmlSerializerArray.add(cachePointXMLSerializer);
            }
            this.connect(environment, prev, (XMLConsumer)next3);
        }
    }

    @Override
    public void recycle() {
        super.recycle();
        Iterator itt = this.xmlSerializerArray.iterator();
        while (itt.hasNext()) {
            this.manager.release(itt.next());
        }
        this.isCachePoint.clear();
        this.xmlSerializerArray.clear();
        this.nextIsCachePoint = false;
        this.autoCachingPointSwitch = null;
    }
}

