/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.pipeline.impl;

import java.io.OutputStream;
import java.io.Serializable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CachedResponse;
import org.apache.cocoon.caching.CachingOutputStream;
import org.apache.cocoon.caching.ComponentCacheKey;
import org.apache.cocoon.components.pipeline.impl.AbstractCachingProcessingPipeline;
import org.apache.cocoon.components.sax.XMLByteStreamCompiler;
import org.apache.cocoon.components.sax.XMLByteStreamInterpreter;
import org.apache.cocoon.components.sax.XMLTeePipe;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLProducer;

public class CachingProcessingPipeline
extends AbstractCachingProcessingPipeline {
    @Override
    protected CachedResponse cacheResults(Environment environment, OutputStream os) throws Exception {
        if (this.toCacheKey != null) {
            CachedResponse response;
            Long expiresObj = (Long)environment.getObjectModel().get("expires");
            if (this.cacheCompleteResponse) {
                response = new CachedResponse(this.toCacheSourceValidities, ((CachingOutputStream)os).getContent(), expiresObj);
                response.setContentType(environment.getContentType());
            } else {
                response = new CachedResponse(this.toCacheSourceValidities, (byte[])this.xmlSerializer.getSAXFragment(), expiresObj);
            }
            this.cache.store((Serializable)this.toCacheKey, response);
            return response;
        }
        return null;
    }

    @Override
    protected ComponentCacheKey newComponentCacheKey(int type, String role, Serializable key) {
        return new ComponentCacheKey(type, role, key);
    }

    @Override
    protected void connectCachingPipeline(Environment environment) throws ProcessingException {
        XMLByteStreamCompiler localXMLSerializer = null;
        if (!this.cacheCompleteResponse) {
            localXMLSerializer = this.xmlSerializer = new XMLByteStreamCompiler();
        }
        if (this.cachedResponse == null) {
            Object next2;
            Generator prev = this.generator;
            int cacheableTransformerCount = this.firstNotCacheableTransformerIndex;
            for (Object next2 : this.transformers) {
                if (localXMLSerializer != null) {
                    if (cacheableTransformerCount == 0) {
                        next2 = new XMLTeePipe((XMLConsumer)next2, localXMLSerializer);
                        localXMLSerializer = null;
                    } else {
                        --cacheableTransformerCount;
                    }
                }
                this.connect(environment, (XMLProducer)prev, (XMLConsumer)next2);
                prev = (XMLProducer)next2;
            }
            next2 = this.lastConsumer;
            if (localXMLSerializer != null) {
                next2 = new XMLTeePipe((XMLConsumer)next2, localXMLSerializer);
                localXMLSerializer = null;
            }
            this.connect(environment, (XMLProducer)prev, (XMLConsumer)next2);
        } else {
            Object next3;
            XMLByteStreamInterpreter prev = this.xmlDeserializer = new XMLByteStreamInterpreter();
            int cacheableTransformerCount = 0;
            for (Object next3 : this.transformers) {
                if (cacheableTransformerCount >= this.firstProcessedTransformerIndex) {
                    if (localXMLSerializer != null && cacheableTransformerCount == this.firstNotCacheableTransformerIndex) {
                        next3 = new XMLTeePipe((XMLConsumer)next3, localXMLSerializer);
                        localXMLSerializer = null;
                    }
                    this.connect(environment, prev, (XMLConsumer)next3);
                    prev = (XMLProducer)next3;
                }
                ++cacheableTransformerCount;
            }
            next3 = this.lastConsumer;
            if (localXMLSerializer != null) {
                next3 = new XMLTeePipe((XMLConsumer)next3, localXMLSerializer);
                localXMLSerializer = null;
            }
            this.connect(environment, prev, (XMLConsumer)next3);
        }
    }
}

