/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.sax;

import org.apache.cocoon.components.sax.AbstractXMLByteStreamInterpreter;
import org.xml.sax.SAXException;

public final class XMLByteStreamInterpreter
extends AbstractXMLByteStreamInterpreter {
    private byte[] input;
    private int currentPos;

    @Override
    public void recycle() {
        this.input = null;
        super.recycle();
    }

    public void deserialize(Object saxFragment) throws SAXException {
        if (!(saxFragment instanceof byte[])) {
            throw new SAXException("XMLDeserializer needs byte array for deserialization.");
        }
        this.input = (byte[])saxFragment;
        this.currentPos = 0;
        super.parse();
    }

    @Override
    protected int read() throws SAXException {
        if (this.currentPos >= this.input.length) {
            return -1;
        }
        return this.input[this.currentPos++] & 0xFF;
    }

    @Override
    protected int read(byte[] b) throws SAXException {
        int bytesRead = this.currentPos + b.length > this.input.length ? this.input.length - this.currentPos : b.length;
        System.arraycopy(this.input, this.currentPos, b, 0, bytesRead);
        this.currentPos += bytesRead;
        return bytesRead;
    }
}

