/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.source.URLRewriter;
import org.apache.cocoon.util.NetUtils;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.sax.SAXParser;
import org.apache.excalibur.xml.sax.XMLizable;
import org.apache.excalibur.xmlizer.XMLizer;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class SourceUtil {
    protected static REProgram uripattern;

    public static void toSAX(ServiceManager manager, Source source, ContentHandler handler, Parameters typeParameters, boolean filterDocumentEvent) throws SAXException, IOException, ProcessingException {
        if (typeParameters != null && typeParameters.getParameter("rewriteURLMode", null) != null) {
            handler = new URLRewriter(typeParameters, (ContentHandler)handler);
        }
        String mimeTypeHint = null;
        if (typeParameters != null) {
            mimeTypeHint = typeParameters.getParameter("mime-type", mimeTypeHint);
        }
        if (filterDocumentEvent) {
            IncludeXMLConsumer filter = new IncludeXMLConsumer((ContentHandler)handler);
            SourceUtil.toSAX(manager, source, mimeTypeHint, (ContentHandler)((Object)filter));
        } else {
            SourceUtil.toSAX(manager, source, mimeTypeHint, (ContentHandler)handler);
        }
    }

    public static void toSAX(XMLizable source, ContentHandler handler) throws SAXException, IOException, ProcessingException {
        try {
            source.toSAX(handler);
        }
        catch (SAXException e) {
            Exception cause = e.getException();
            if (cause != null) {
                if (cause instanceof SourceException) {
                    throw SourceUtil.handle((SourceException)((Object)cause));
                }
                if (cause instanceof ProcessingException) {
                    throw (ProcessingException)((Object)cause);
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof SAXException) {
                    throw (SAXException)cause;
                }
            }
            throw e;
        }
    }

    public static void toSAX(ServiceManager manager, Source source, ContentHandler handler) throws SAXException, IOException, ProcessingException {
        SourceUtil.toSAX(manager, source, null, handler);
    }

    public static void toSAX(ServiceManager manager, Source source, String mimeTypeHint, ContentHandler handler) throws SAXException, IOException, ProcessingException {
        if (source instanceof XMLizable) {
            SourceUtil.toSAX((XMLizable)source, handler);
        } else {
            String mimeType = source.getMimeType();
            if (null == mimeType) {
                mimeType = mimeTypeHint;
            }
            XMLizer xmlizer = null;
            try {
                xmlizer = (XMLizer)manager.lookup(XMLizer.ROLE);
                xmlizer.toSAX(source.getInputStream(), mimeType, source.getURI(), handler);
            }
            catch (SourceException e) {
                throw SourceUtil.handle(e);
            }
            catch (ServiceException e) {
                throw new ProcessingException("Exception during streaming source.", (Throwable)e);
            }
            finally {
                manager.release((Object)xmlizer);
            }
        }
    }

    public static void toSAX(XMLizer xmlizer, Source source, String mimeTypeHint, ContentHandler handler) throws SAXException, IOException, ProcessingException {
        if (source instanceof XMLizable) {
            SourceUtil.toSAX((XMLizable)source, handler);
        } else {
            String mimeType = source.getMimeType();
            if (null == mimeType) {
                mimeType = mimeTypeHint;
            }
            try {
                xmlizer.toSAX(source.getInputStream(), mimeType, source.getURI(), handler);
            }
            catch (SourceException e) {
                throw SourceUtil.handle(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toCharacters(Source source, String encoding, ContentHandler handler) throws SAXException, IOException, ProcessingException {
        try {
            char[] chr = new char[4096];
            try (InputStreamReader r = encoding == null ? new InputStreamReader(source.getInputStream()) : new InputStreamReader(source.getInputStream(), encoding);){
                int len;
                while ((len = r.read(chr)) > 0) {
                    handler.characters(chr, 0, len);
                }
            }
        }
        catch (SAXException e) {
            SourceUtil.handleSAXException(source.getURI(), e);
        }
    }

    public static void parse(ServiceManager manager, Source source, ContentHandler handler) throws SAXException, IOException, ProcessingException {
        if (source instanceof XMLizable) {
            SourceUtil.toSAX((XMLizable)source, handler);
        } else {
            SAXParser parser = null;
            try {
                parser = (SAXParser)manager.lookup(SAXParser.ROLE);
                parser.parse(SourceUtil.getInputSource(source), handler);
            }
            catch (SourceException e) {
                throw SourceUtil.handle(e);
            }
            catch (ServiceException e) {
                throw new ProcessingException("Exception during parsing source.", (Throwable)e);
            }
            finally {
                manager.release((Object)parser);
            }
        }
    }

    public static void parse(org.apache.cocoon.core.xml.SAXParser parser, Source source, ContentHandler handler) throws SAXException, IOException, ProcessingException {
        if (source instanceof XMLizable) {
            SourceUtil.toSAX((XMLizable)source, handler);
        } else {
            try {
                parser.parse(SourceUtil.getInputSource(source), handler);
            }
            catch (SourceException e) {
                throw SourceUtil.handle(e);
            }
        }
    }

    public static Document toDOM(ServiceManager manager, Source source) throws SAXException, IOException, ProcessingException {
        DOMBuilder builder = new DOMBuilder();
        SourceUtil.toSAX(manager, source, null, (ContentHandler)((Object)builder));
        Document document = builder.getDocument();
        if (document == null) {
            throw new ProcessingException("Could not build DOM for '" + source.getURI() + "'");
        }
        return document;
    }

    public static Document toDOM(ServiceManager manager, String mimeTypeHint, Source source) throws SAXException, IOException, ProcessingException {
        DOMBuilder builder = new DOMBuilder();
        SourceUtil.toSAX(manager, source, mimeTypeHint, (ContentHandler)((Object)builder));
        Document document = builder.getDocument();
        if (document == null) {
            throw new ProcessingException("Could not build DOM for '" + source.getURI() + "'");
        }
        return document;
    }

    public static ProcessingException handle(SourceException se) {
        if (se instanceof SourceNotFoundException) {
            return new ResourceNotFoundException("Resource not found.", (Throwable)se);
        }
        return new ProcessingException("Exception during source resolving.", (Throwable)se);
    }

    public static ProcessingException handle(String message, SourceException se) {
        if (se instanceof SourceNotFoundException) {
            return new ResourceNotFoundException(message, (Throwable)se);
        }
        return new ProcessingException(message, (Throwable)se);
    }

    public static void handleSAXException(String source, SAXException e) throws ProcessingException, IOException, SAXException {
        Exception cause = e.getException();
        if (cause != null) {
            if (cause instanceof SourceException) {
                throw SourceUtil.handle((SourceException)((Object)cause));
            }
            if (cause instanceof ProcessingException) {
                throw (ProcessingException)((Object)cause);
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof SAXException) {
                throw (SAXException)cause;
            }
            throw new ProcessingException("Could not read resource " + source, (Throwable)cause);
        }
        throw e;
    }

    public static InputSource getInputSource(Source source) throws IOException, ProcessingException {
        try {
            InputSource newObject = new InputSource(source.getInputStream());
            newObject.setSystemId(source.getURI());
            return newObject;
        }
        catch (SourceException se) {
            throw SourceUtil.handle(se);
        }
    }

    public static Source getSource(String uri, Parameters typeParameters, SourceParameters resourceParameters, SourceResolver resolver) throws IOException, SAXException, SourceException {
        String encoding;
        String method;
        String queryString;
        SourceParameters queries;
        int queryPos = uri.indexOf(63);
        if (queryPos != -1 && (queries = new SourceParameters(queryString = uri.substring(queryPos + 1))).hasParameters()) {
            StringBuffer buffer = new StringBuffer(uri.substring(0, queryPos));
            int separator = 63;
            Iterator i = queries.getParameterNames();
            while (i.hasNext()) {
                String current = (String)i.next();
                Iterator values = queries.getParameterValues(current);
                while (values.hasNext()) {
                    buffer.append((char)separator).append(current).append('=').append(NetUtils.encode((String)((String)values.next()), (String)"utf-8"));
                    separator = 38;
                }
            }
            uri = buffer.toString();
        }
        String string = method = typeParameters != null ? typeParameters.getParameter("method", "GET") : "GET";
        if (method.equalsIgnoreCase("POST") && (resourceParameters == null || !resourceParameters.hasParameters())) {
            method = "GET";
        }
        if (uri.startsWith("cocoon:") && resourceParameters != null && resourceParameters.hasParameters()) {
            int pos = uri.indexOf(";jsessionid=");
            StringBuffer buf = pos == -1 ? new StringBuffer(uri) : new StringBuffer(uri.substring(0, pos));
            buf.append(uri.indexOf(63) == -1 ? (char)'?' : '&');
            buf.append(resourceParameters.getEncodedQueryString());
            uri = buf.toString();
        }
        HashMap<String, String> resolverParameters = new HashMap<String, String>();
        resolverParameters.put(SourceResolver.METHOD, method);
        if (typeParameters != null && (encoding = typeParameters.getParameter("encoding", System.getProperty("file.encoding", "ISO-8859-1"))) != null && !"".equals(encoding)) {
            resolverParameters.put(SourceResolver.URI_ENCODING, encoding);
        }
        resolverParameters.put(SourceResolver.URI_PARAMETERS, (String)resourceParameters);
        return resolver.resolveURI(uri, null, resolverParameters);
    }

    public static String getScheme(String uri) {
        RE re = new RE(uripattern);
        if (re.match(uri)) {
            return re.getParen(2);
        }
        throw new IllegalArgumentException("'" + uri + "' is not a correct URI");
    }

    public static String getAuthority(String uri) {
        RE re = new RE(uripattern);
        if (re.match(uri)) {
            return re.getParen(4);
        }
        throw new IllegalArgumentException("'" + uri + "' is not a correct URI");
    }

    public static String getPath(String uri) {
        RE re = new RE(uripattern);
        if (re.match(uri)) {
            return re.getParen(5);
        }
        throw new IllegalArgumentException("'" + uri + "' is not a correct URI");
    }

    public static String getPathWithoutAuthority(String uri) {
        RE re = new RE(uripattern);
        if (re.match(uri)) {
            return re.getParen(4) + re.getParen(5);
        }
        throw new IllegalArgumentException("'" + uri + "' is not a correct URI");
    }

    public static String getQuery(String uri) {
        RE re = new RE(uripattern);
        if (re.match(uri)) {
            return re.getParen(7);
        }
        throw new IllegalArgumentException("'" + uri + "' is not a correct URI");
    }

    public static String getFragment(String uri) {
        RE re = new RE(uripattern);
        if (re.match(uri)) {
            return re.getParen(9);
        }
        throw new IllegalArgumentException("'" + uri + "' is not a correct URI");
    }

    static {
        try {
            uripattern = new RECompiler().compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$");
        }
        catch (RESyntaxException e) {
            throw new RuntimeException("Error parsing regular expression.", e);
        }
    }
}

