/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.cocoon.util.BufferedOutputStream;
import org.apache.commons.collections.iterators.IteratorEnumeration;

public abstract class AbstractEnvironment
extends AbstractLogEnabled
implements Environment {
    protected String uri;
    protected String prefix = "";
    protected String view;
    protected String action;
    protected Map objectModel = new HashMap();
    private Map attributes = new HashMap();
    protected BufferedOutputStream secureOutputStream;
    protected OutputStream outputStream;

    public AbstractEnvironment(String uri, String view) {
        this(uri, view, null);
    }

    public AbstractEnvironment(String uri, String view, String action) {
        this.uri = uri;
        this.view = view;
        this.action = action;
    }

    protected void setView(String view) {
        if (this.view != null) {
            throw new IllegalStateException("View was already set on this environment");
        }
        this.view = view;
    }

    protected void setAction(String action) {
        if (this.action != null) {
            throw new IllegalStateException("Action was already set on this environment");
        }
        this.action = action;
    }

    protected static String extractView(Request request) {
        return request.getParameter("cocoon-view");
    }

    protected static String extractAction(Request req) {
        String action = req.getParameter("cocoon-action");
        if (action != null) {
            return action;
        }
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith("cocoon-action-")) continue;
            if (name.endsWith(".x") || name.endsWith(".y")) {
                return name.substring("cocoon-action-".length(), name.length() - 2);
            }
            return name.substring("cocoon-action-".length());
        }
        return null;
    }

    public String getURI() {
        return this.uri;
    }

    public String getURIPrefix() {
        return this.prefix;
    }

    public void setURI(String prefix, String value) {
        this.prefix = prefix;
        this.uri = value;
    }

    public String getView() {
        return this.view;
    }

    public String getAction() {
        return this.action;
    }

    public void setStatus(int statusCode) {
    }

    public Map getObjectModel() {
        return this.objectModel;
    }

    public boolean isResponseModified(long lastModified) {
        return true;
    }

    public void setResponseIsNotModified() {
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Enumeration getAttributeNames() {
        return new IteratorEnumeration(this.attributes.keySet().iterator());
    }

    public OutputStream getOutputStream(int bufferSize) throws IOException {
        if (bufferSize == 0) {
            if (this.secureOutputStream != null) {
                this.secureOutputStream = null;
            }
            return this.outputStream;
        }
        if (this.secureOutputStream == null) {
            this.secureOutputStream = new BufferedOutputStream(this.outputStream, bufferSize);
        }
        return this.secureOutputStream;
    }

    public boolean tryResetResponse() throws IOException {
        if (this.secureOutputStream != null && this.secureOutputStream.isResettable()) {
            this.secureOutputStream.reset();
            return true;
        }
        return false;
    }

    public void commitResponse() throws IOException {
        if (this.secureOutputStream != null) {
            if (this.secureOutputStream.isResettable()) {
                this.setContentLength(this.secureOutputStream.getCount());
            }
            this.secureOutputStream.flush();
        } else if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    public void startingProcessing() {
    }

    public void finishingProcessing() {
    }

    public boolean isInternalRedirect() {
        return false;
    }
}

