/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.http.HttpCookie;
import org.apache.cocoon.environment.impl.AbstractResponse;

public final class HttpResponse
extends AbstractResponse
implements Response {
    private final HttpServletResponse res;

    protected HttpResponse(HttpServletResponse res) {
        this.res = res;
    }

    public javax.servlet.http.Cookie createCookie(String name, String value) {
        return new javax.servlet.http.Cookie(name, value);
    }

    public void addCookie(javax.servlet.http.Cookie cookie) {
        this.res.addCookie(cookie);
    }

    public Cookie createCocoonCookie(String name, String value) {
        return new HttpCookie(name, value);
    }

    public void addCookie(Cookie cookie) {
        if (cookie instanceof HttpCookie) {
            this.res.addCookie(((HttpCookie)cookie).getServletCookie());
        } else {
            javax.servlet.http.Cookie newCookie = new javax.servlet.http.Cookie(cookie.getName(), cookie.getValue());
            newCookie.setComment(cookie.getComment());
            newCookie.setDomain(cookie.getDomain());
            newCookie.setMaxAge(cookie.getMaxAge());
            newCookie.setPath(cookie.getPath());
            newCookie.setSecure(cookie.getSecure());
            newCookie.setVersion(cookie.getVersion());
            this.res.addCookie(newCookie);
        }
    }

    public boolean containsHeader(String name) {
        return this.res.containsHeader(name);
    }

    public String encodeURL(String url) {
        if (url != null && url.indexOf(";jsessionid=") != -1) {
            return url;
        }
        return this.res.encodeURL(url);
    }

    @Override
    public String encodeRedirectURL(String url) {
        if (url != null && url.indexOf(";jsessionid=") != -1) {
            return url;
        }
        return this.res.encodeRedirectURL(url);
    }

    @Override
    public void sendError(int sc, String msg) throws IOException {
        this.res.sendError(sc, msg);
    }

    @Override
    public void sendError(int sc) throws IOException {
        this.res.sendError(sc);
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        this.res.sendRedirect(location);
    }

    public void sendPermanentRedirect(String location) throws IOException {
        this.res.setHeader("location", location);
        this.res.setStatus(301);
    }

    public void setDateHeader(String name, long date) {
        this.res.setDateHeader(name, date);
    }

    public void addDateHeader(String name, long date) {
        this.res.addDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        this.res.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.res.addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.res.setIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.res.addIntHeader(name, value);
    }

    @Override
    public void setStatus(int sc) {
        this.res.setStatus(sc);
    }

    @Override
    public String encodeUrl(String url) {
        return this.res.encodeUrl(url);
    }

    @Override
    public String encodeRedirectUrl(String url) {
        return this.res.encodeRedirectUrl(url);
    }

    @Override
    public void setStatus(int sc, String sm) {
        this.res.setStatus(sc, sm);
    }

    public String getCharacterEncoding() {
        return this.res.getCharacterEncoding();
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        return this.res.getOutputStream();
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        return this.res.getWriter();
    }

    @Override
    public void setContentLength(int len) {
        this.res.setContentLength(len);
    }

    @Override
    public void setContentType(String type) {
        this.res.setContentType(type);
    }

    @Override
    public void setBufferSize(int size) {
        this.res.setBufferSize(size);
    }

    @Override
    public int getBufferSize() {
        return this.res.getBufferSize();
    }

    @Override
    public void flushBuffer() throws IOException {
        this.res.flushBuffer();
    }

    @Override
    public boolean isCommitted() {
        return this.res.isCommitted();
    }

    @Override
    public void reset() {
        this.res.reset();
    }

    public void setLocale(Locale loc) {
        this.res.setLocale(loc);
    }

    public Locale getLocale() {
        return this.res.getLocale();
    }
}

