/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class AbstractDOMTransformer
extends AbstractTransformer
implements DOMBuilder.Listener,
Serviceable,
Disposable {
    protected SourceResolver resolver;
    protected Map objectModel;
    protected String source;
    protected Parameters parameters;
    protected ServiceManager manager;
    protected DOMBuilder builder = new DOMBuilder(this);

    public void service(ServiceManager aManager) throws ServiceException {
        this.manager = aManager;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        this.resolver = resolver;
        this.objectModel = objectModel;
        this.source = src;
        this.parameters = par;
    }

    @Override
    public void recycle() {
        this.resolver = null;
        this.source = null;
        this.objectModel = null;
        this.parameters = null;
        this.builder.recycle();
        super.recycle();
    }

    public void dispose() {
        this.builder = null;
        this.manager = null;
    }

    @Override
    public void notify(Document doc) throws SAXException {
        Document newdoc = this.transform(doc);
        DOMStreamer s = new DOMStreamer(this.contentHandler, this.lexicalHandler);
        s.stream(newdoc);
    }

    protected abstract Document transform(Document var1);

    @Override
    public void setDocumentLocator(Locator locator) {
        this.builder.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        this.builder.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.builder.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.builder.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.builder.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        this.builder.startElement(uri, loc, raw, a);
    }

    @Override
    public void endElement(String uri, String loc, String raw) throws SAXException {
        this.builder.endElement(uri, loc, raw);
    }

    @Override
    public void characters(char[] c, int start, int len) throws SAXException {
        this.builder.characters(c, start, len);
    }

    @Override
    public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
        this.builder.ignorableWhitespace(c, start, len);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.builder.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.builder.skippedEntity(name);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.builder.startDTD(name, publicId, systemId);
    }

    @Override
    public void endDTD() throws SAXException {
        this.builder.endDTD();
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.builder.startEntity(name);
    }

    @Override
    public void endEntity(String name) throws SAXException {
        this.builder.endEntity(name);
    }

    @Override
    public void startCDATA() throws SAXException {
        this.builder.startCDATA();
    }

    @Override
    public void endCDATA() throws SAXException {
        this.builder.endCDATA();
    }

    @Override
    public void comment(char[] ch, int start, int len) throws SAXException {
        this.builder.comment(ch, start, len);
    }
}

