/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation.helpers;

import java.util.Iterator;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.transformation.helpers.NOPRecorder;
import org.apache.excalibur.source.SourceParameters;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class ParametersRecorder
extends NOPRecorder {
    private SourceParameters parameters = new SourceParameters();
    private String key;
    private StringBuffer buffer;

    public SourceParameters getParameters(Parameters source) {
        if (source != null) {
            String[] names = source.getNames();
            for (int i = 0; i < names.length; ++i) {
                String currentParameterName = names[i];
                this.parameters.setParameter(currentParameterName, source.getParameter(currentParameterName, ""));
            }
        }
        return this.parameters;
    }

    public SourceParameters getParameters(SourceParameters source) {
        if (source != null) {
            Iterator iter = source.getParameterNames();
            while (iter.hasNext()) {
                String parName = (String)iter.next();
                Iterator valuesIter = source.getParameterValues(parName);
                while (valuesIter.hasNext()) {
                    String value = (String)valuesIter.next();
                    this.parameters.setParameter(parName, value);
                }
            }
        }
        return this.parameters;
    }

    @Override
    public void startElement(String namespace, String name, String raw, Attributes attr) throws SAXException {
        if (this.key == null) {
            this.key = name;
            this.buffer = new StringBuffer();
        }
    }

    @Override
    public void endElement(String namespace, String name, String raw) throws SAXException {
        if (this.key != null && this.key.equals(name)) {
            String value = this.buffer.toString().trim();
            if (value.length() > 0) {
                this.parameters.setParameter(this.key, value);
            }
            this.buffer = null;
            this.key = null;
        }
    }

    @Override
    public void characters(char[] ary, int start, int length) throws SAXException {
        if (this.key != null && this.buffer != null) {
            String value = new String(ary, start, length).trim();
            if (value.length() > 0) {
                this.buffer.append(value);
            } else {
                this.buffer.append(' ');
            }
        }
    }
}

