/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.om;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.portal.om.CopletDefinition;
import org.apache.cocoon.portal.util.PortalUtils;

public final class CopletInstance {
    public static final int SIZE_MINIMIZED = 0;
    public static final int SIZE_NORMAL = 1;
    public static final int SIZE_MAXIMIZED = 2;
    public static final int SIZE_FULLSCREEN = 3;
    protected CopletDefinition copletDefinition;
    protected String title;
    protected int size = 1;
    protected final String id;
    protected Map attributes = Collections.EMPTY_MAP;
    protected transient Map temporaryAttributes = Collections.EMPTY_MAP;

    public CopletInstance(String id, CopletDefinition def) {
        String idErrorMsg = PortalUtils.testId(id);
        if (idErrorMsg != null) {
            throw new IllegalArgumentException(idErrorMsg);
        }
        this.copletDefinition = def;
        this.id = id;
    }

    public CopletInstance(String id) {
        this(id, null);
    }

    public CopletDefinition getCopletDefinition() {
        return this.copletDefinition;
    }

    public void setCopletDefinition(CopletDefinition cd) {
        this.copletDefinition = cd;
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        return this.getCopletDefinition().getTitle();
    }

    public String getInstanceTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (size < 0 || size > 3) {
            throw new IllegalArgumentException("Unknown size for coplet: " + size);
        }
        this.size = size;
    }

    public String toString() {
        return "CopletInstance (" + this.hashCode() + "), id=" + this.getId() + ", coplet-definition=" + (this.getCopletDefinition() == null ? "null" : this.getCopletDefinition().getId());
    }

    public String getId() {
        return this.id;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        if (this.attributes.size() == 0) {
            this.attributes = new HashMap();
        }
        this.attributes.put(key, value);
    }

    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Object getTemporaryAttribute(String key) {
        return this.temporaryAttributes.get(key);
    }

    public void setTemporaryAttribute(String key, Object value) {
        if (this.temporaryAttributes.size() == 0) {
            this.temporaryAttributes = new HashMap();
        }
        this.temporaryAttributes.put(key, value);
    }

    public Object removeTemporaryAttribute(String key) {
        return this.temporaryAttributes.remove(key);
    }

    public Map getTemporaryAttributes() {
        return this.temporaryAttributes;
    }
}

