/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.om;

import org.apache.cocoon.portal.om.AbstractParameters;
import org.apache.cocoon.portal.om.Item;
import org.apache.cocoon.portal.om.LayoutType;
import org.apache.cocoon.portal.om.Renderer;
import org.apache.cocoon.portal.util.PortalUtils;

public abstract class Layout
extends AbstractParameters {
    protected Item parent;
    protected final String id;
    protected boolean isStatic;
    protected LayoutType layoutType;
    protected Renderer customRenderer;

    public Layout(String id) {
        String idErrorMsg;
        if (id != null && (idErrorMsg = PortalUtils.testId(id)) != null) {
            throw new IllegalArgumentException(idErrorMsg);
        }
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Renderer getCustomRenderer() {
        return this.customRenderer;
    }

    public Item getParent() {
        return this.parent;
    }

    public void setParent(Item item) {
        this.parent = item;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setCustomRenderer(Renderer value) {
        this.customRenderer = value;
    }

    public void setIsStatic(boolean value) {
        this.isStatic = value;
    }

    public String toString() {
        return "Layout (" + this.getClass() + '.' + this.hashCode() + "), type=" + this.layoutType + ", id=" + (this.getId() == null ? "" : this.getId());
    }

    public LayoutType getLayoutType() {
        return this.layoutType;
    }

    public void setLayoutType(LayoutType t) {
        this.layoutType = t;
    }

    public Renderer getRenderer() {
        if (this.customRenderer != null) {
            return this.customRenderer;
        }
        return this.layoutType.getDefaultRenderer();
    }
}

