/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.om;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.portal.om.Layout;

public class LayoutInstance
implements Serializable,
Cloneable {
    protected final transient Layout layout;
    protected Map attributes = Collections.EMPTY_MAP;
    protected transient Map temporaryAttributes = Collections.EMPTY_MAP;

    public LayoutInstance(Layout layout) {
        this.layout = layout;
    }

    public LayoutInstance copy() {
        try {
            return (LayoutInstance)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        LayoutInstance clone = new LayoutInstance(this.layout);
        if (this.attributes.size() > 0) {
            clone.attributes = new HashMap(this.attributes);
        }
        if (this.temporaryAttributes.size() > 0) {
            clone.temporaryAttributes = new HashMap(this.temporaryAttributes);
        }
        return clone;
    }

    public String toString() {
        return "LayoutInstance (" + this.hashCode() + "), id=" + this.layout.getId();
    }

    public String getId() {
        return this.layout.getId();
    }

    public Layout getLayout() {
        return this.layout;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        if (this.attributes.size() == 0) {
            this.attributes = new HashMap();
        }
        this.attributes.put(key, value);
    }

    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Object getTemporaryAttribute(String key) {
        return this.temporaryAttributes.get(key);
    }

    public void setTemporaryAttribute(String key, Object value) {
        if (this.temporaryAttributes.size() == 0) {
            this.temporaryAttributes = new HashMap();
        }
        this.temporaryAttributes.put(key, value);
    }

    public Object removeTemporaryAttribute(String key) {
        return this.temporaryAttributes.remove(key);
    }

    public Map getTemporaryAttributes() {
        return this.temporaryAttributes;
    }
}

