/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.util;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class AbstractContentHandler
implements ContentHandler,
LexicalHandler {
    protected final ContentHandler contentHandler;
    protected final LexicalHandler lexicalHandler;
    protected String namespaceUri;
    private final List namespaces = new ArrayList(5);
    private String ourPrefix;
    protected boolean removeOurNamespacePrefixes = false;

    public AbstractContentHandler(ContentHandler contentHandler) {
        this(contentHandler, contentHandler instanceof LexicalHandler ? (LexicalHandler)((Object)contentHandler) : null);
    }

    public AbstractContentHandler(ContentHandler contentHandler, LexicalHandler lexicalHandler) {
        if (contentHandler == null) {
            throw new NullPointerException("ContentHandler must not be null.");
        }
        this.contentHandler = contentHandler;
        this.lexicalHandler = lexicalHandler;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.contentHandler.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        boolean isOurPrefix = false;
        if (prefix != null) {
            this.namespaces.add(new String[]{prefix, uri});
        }
        if (uri.equals(this.namespaceUri)) {
            this.ourPrefix = prefix;
            isOurPrefix = true;
        }
        if (!this.removeOurNamespacePrefixes || !isOurPrefix) {
            this.contentHandler.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        boolean isOurPrefix = false;
        if (prefix != null) {
            String[] prefixAndUri;
            int i;
            boolean found = false;
            for (i = this.namespaces.size() - 1; i >= 0; --i) {
                prefixAndUri = (String[])this.namespaces.get(i);
                if (!prefixAndUri[0].equals(prefix)) continue;
                this.namespaces.remove(i);
                found = true;
                break;
            }
            if (!found) {
                throw new SAXException("Namespace for prefix '" + prefix + "' not found.");
            }
            if (prefix.equals(this.ourPrefix)) {
                isOurPrefix = true;
                this.ourPrefix = null;
                for (i = this.namespaces.size() - 1; i >= 0; --i) {
                    prefixAndUri = (String[])this.namespaces.get(i);
                    if (!this.namespaceUri.equals(prefixAndUri[1])) continue;
                    this.ourPrefix = prefixAndUri[0];
                    break;
                }
            }
        }
        if (!this.removeOurNamespacePrefixes || !isOurPrefix) {
            this.contentHandler.endPrefixMapping(prefix);
        }
    }

    @Override
    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        this.contentHandler.startElement(uri, loc, raw, a);
    }

    @Override
    public void endElement(String uri, String loc, String raw) throws SAXException {
        this.contentHandler.endElement(uri, loc, raw);
    }

    @Override
    public void characters(char[] ch, int start, int len) throws SAXException {
        this.contentHandler.characters(ch, start, len);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int len) throws SAXException {
        this.contentHandler.ignorableWhitespace(ch, start, len);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.contentHandler.skippedEntity(name);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(name);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    @Override
    public void comment(char[] ch, int start, int len) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(ch, start, len);
        }
    }
}

