/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.util;

import java.util.Properties;

public class PropertyHelper {
    public static String replace(String value, Properties properties) {
        int pos;
        if (value == null || value.indexOf("{") == -1) {
            return value;
        }
        StringBuffer buffer = new StringBuffer();
        int prev = 0;
        while ((pos = value.indexOf("{", prev)) >= 0) {
            if (pos > prev) {
                buffer.append(value.substring(prev, pos));
            }
            if (pos == value.length() - 1) {
                buffer.append("{");
                prev = pos + 1;
                continue;
            }
            int endName = value.indexOf(125, pos);
            if (endName == -1) {
                buffer.append(value.substring(pos));
                prev = value.length();
                continue;
            }
            String propertyName = value.substring(pos + 1, endName);
            String propertyValue = PropertyHelper.getProperty(propertyName, properties);
            if (propertyValue == null) {
                buffer.append("{");
                buffer.append(propertyName);
                buffer.append('}');
            } else {
                buffer.append(propertyValue);
            }
            prev = endName + 1;
        }
        if (prev < value.length()) {
            buffer.append(value.substring(prev));
        }
        return buffer.toString();
    }

    public static String getProperty(String key, Properties properties) {
        String defaultValue;
        String name;
        int pos = key.indexOf(58);
        if (pos != -1) {
            name = key.substring(0, pos);
            defaultValue = key.substring(pos + 1);
        } else {
            name = key;
            defaultValue = null;
        }
        String value = null;
        if (properties != null) {
            value = properties.getProperty(name);
        }
        if (value == null) {
            try {
                value = System.getProperty(name);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }
}

