/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SaxBuffer
implements ContentHandler,
LexicalHandler {
    protected List saxbits = new ArrayList();

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.saxbits.add(new SkippedEntity(name));
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.saxbits.add(new IgnorableWhitespace(ch, start, length));
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.saxbits.add(new PI(target, data));
    }

    @Override
    public void startDocument() throws SAXException {
        this.saxbits.add(StartDocument.SINGLETON);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.saxbits.add(new StartElement(namespaceURI, localName, qName, atts));
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.saxbits.add(new EndPrefixMapping(prefix));
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.saxbits.add(new Characters(ch, start, length));
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.saxbits.add(new EndElement(namespaceURI, localName, qName));
    }

    @Override
    public void endDocument() throws SAXException {
        this.saxbits.add(EndDocument.SINGLETON);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.saxbits.add(new StartPrefixMapping(prefix, uri));
    }

    @Override
    public void endCDATA() throws SAXException {
        this.saxbits.add(EndCDATA.SINGLETON);
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.saxbits.add(new Comment(ch, start, length));
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.saxbits.add(new StartEntity(name));
    }

    @Override
    public void endDTD() throws SAXException {
        this.saxbits.add(EndDTD.SINGLETON);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.saxbits.add(new StartDTD(name, publicId, systemId));
    }

    @Override
    public void startCDATA() throws SAXException {
        this.saxbits.add(StartCDATA.SINGLETON);
    }

    @Override
    public void endEntity(String name) throws SAXException {
        this.saxbits.add(new EndEntity(name));
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        for (SaxBit saxbit : this.saxbits) {
            saxbit.send(contentHandler);
        }
    }

    protected final void addBit(SaxBit bit) {
        this.saxbits.add(bit);
    }

    protected final Iterator bits() {
        return this.saxbits.iterator();
    }

    public static final class SkippedEntity
    implements SaxBit {
        public final String name;

        public SkippedEntity(String name) {
            this.name = name;
        }

        @Override
        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.skippedEntity(this.name);
        }
    }

    public static final class IgnorableWhitespace
    implements SaxBit {
        public final char[] ch;

        public IgnorableWhitespace(char[] ch, int start, int length) {
            this.ch = new char[length];
            System.arraycopy(ch, start, this.ch, 0, length);
        }

        @Override
        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.ignorableWhitespace(this.ch, 0, this.ch.length);
        }
    }

    public static final class PI
    implements SaxBit {
        public final String target;
        public final String data;

        public PI(String target, String data) {
            this.target = target;
            this.data = data;
        }

        @Override
        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.processingInstruction(this.target, this.data);
        }
    }

    public static final class StartDocument
    implements SaxBit {
        public static final StartDocument SINGLETON = new StartDocument();

        @Override
        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.startDocument();
        }
    }

    public static final class StartElement
    implements SaxBit {
        public final String namespaceURI;
        public final String localName;
        public final String qName;
        public final Attributes attrs;

        public StartElement(String namespaceURI, String localName, String qName, Attributes attrs) {
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            this.qName = qName;
            this.attrs = new AttributesImpl(attrs);
        }

        @Override
        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.startElement(this.namespaceURI, this.localName, this.qName, this.attrs);
        }
    }

    public static final class EndPrefixMapping
    implements SaxBit {
        public final String prefix;

        public EndPrefixMapping(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.endPrefixMapping(this.prefix);
        }
    }

    public static final class Characters
    implements SaxBit {
        public final char[] ch;

        public Characters(char[] ch, int start, int length) {
            this.ch = new char[length];
            System.arraycopy(ch, start, this.ch, 0, length);
        }

        @Override
        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.characters(this.ch, 0, this.ch.length);
        }
    }

    public static final class EndElement
    implements SaxBit {
        public final String namespaceURI;
        public final String localName;
        public final String qName;

        public EndElement(String namespaceURI, String localName, String qName) {
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            this.qName = qName;
        }

        @Override
        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.endElement(this.namespaceURI, this.localName, this.qName);
        }
    }

    public static final class EndDocument
    implements SaxBit {
        public static final EndDocument SINGLETON = new EndDocument();

        @Override
        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.endDocument();
        }
    }

    public static final class StartPrefixMapping
    implements SaxBit {
        public final String prefix;
        public final String uri;

        public StartPrefixMapping(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }

        @Override
        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.startPrefixMapping(this.prefix, this.uri);
        }
    }

    public static final class EndCDATA
    implements SaxBit {
        public static final EndCDATA SINGLETON = new EndCDATA();

        @Override
        public void send(ContentHandler contentHandler) throws SAXException {
            if (contentHandler instanceof LexicalHandler) {
                ((LexicalHandler)((Object)contentHandler)).endCDATA();
            }
        }
    }

    public static final class Comment
    implements SaxBit {
        public final char[] ch;

        public Comment(char[] ch, int start, int length) {
            this.ch = new char[length];
            System.arraycopy(ch, start, this.ch, 0, length);
        }

        @Override
        public void send(ContentHandler contentHandler) throws SAXException {
            if (contentHandler instanceof LexicalHandler) {
                ((LexicalHandler)((Object)contentHandler)).comment(this.ch, 0, this.ch.length);
            }
        }
    }

    public static final class StartEntity
    implements SaxBit {
        public final String name;

        public StartEntity(String name) {
            this.name = name;
        }

        @Override
        public void send(ContentHandler contentHandler) throws SAXException {
            if (contentHandler instanceof LexicalHandler) {
                ((LexicalHandler)((Object)contentHandler)).startEntity(this.name);
            }
        }
    }

    public static final class EndDTD
    implements SaxBit {
        public static final EndDTD SINGLETON = new EndDTD();

        @Override
        public void send(ContentHandler contentHandler) throws SAXException {
            if (contentHandler instanceof LexicalHandler) {
                ((LexicalHandler)((Object)contentHandler)).endDTD();
            }
        }
    }

    public static final class StartDTD
    implements SaxBit {
        public final String name;
        public final String publicId;
        public final String systemId;

        public StartDTD(String name, String publicId, String systemId) {
            this.name = name;
            this.publicId = publicId;
            this.systemId = systemId;
        }

        @Override
        public void send(ContentHandler contentHandler) throws SAXException {
            if (contentHandler instanceof LexicalHandler) {
                ((LexicalHandler)((Object)contentHandler)).startDTD(this.name, this.publicId, this.systemId);
            }
        }
    }

    public static final class StartCDATA
    implements SaxBit {
        public static final StartCDATA SINGLETON = new StartCDATA();

        @Override
        public void send(ContentHandler contentHandler) throws SAXException {
            if (contentHandler instanceof LexicalHandler) {
                ((LexicalHandler)((Object)contentHandler)).startCDATA();
            }
        }
    }

    public static final class EndEntity
    implements SaxBit {
        public final String name;

        public EndEntity(String name) {
            this.name = name;
        }

        @Override
        public void send(ContentHandler contentHandler) throws SAXException {
            if (contentHandler instanceof LexicalHandler) {
                ((LexicalHandler)((Object)contentHandler)).endEntity(this.name);
            }
        }
    }

    static interface SaxBit
    extends Serializable {
        public void send(ContentHandler var1) throws SAXException;
    }
}

