/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.cocoon.portal.spi.RequestContextProvider;

public class SessionMapWrapper
implements Map {
    protected final String attrName;
    protected final RequestContextProvider requestContextProvider;

    public SessionMapWrapper(RequestContextProvider provider, String attrName) {
        this.requestContextProvider = provider;
        this.attrName = attrName;
    }

    protected Map getRealMap(boolean create) {
        HttpServletRequest req = this.requestContextProvider.getCurrentRequestContext().getRequest();
        HttpSession session = req.getSession(create);
        if (session != null) {
            HashMap map = (HashMap)session.getAttribute(this.attrName);
            if (map != null) {
                return map;
            }
            if (create) {
                map = new HashMap();
                session.setAttribute(this.attrName, map);
            }
        }
        return Collections.EMPTY_MAP;
    }

    @Override
    public void clear() {
        this.getRealMap(false).clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getRealMap(false).containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getRealMap(false).containsValue(value);
    }

    public Set entrySet() {
        return this.getRealMap(false).entrySet();
    }

    public Object get(Object key) {
        return this.getRealMap(false).get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.getRealMap(false).isEmpty();
    }

    public Set keySet() {
        return this.getRealMap(false).keySet();
    }

    public Object put(Object key, Object value) {
        return this.getRealMap(true).put(key, value);
    }

    public void putAll(Map t) {
        this.getRealMap(true).putAll(t);
    }

    public Object remove(Object key) {
        return this.getRealMap(false).remove(key);
    }

    @Override
    public int size() {
        return this.getRealMap(false).size();
    }

    public Collection values() {
        return this.getRealMap(false).values();
    }
}

