/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.tools.rcl.wrapper.servlet;

import java.io.File;
import org.apache.commons.jci.listeners.ReloadingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CocoonReloadingListener
extends ReloadingListener {
    private final Log log = LogFactory.getLog((Class)CocoonReloadingListener.class);
    private static boolean reload = false;
    private static boolean consoleOutput = false;

    public void onFileChange(File file) {
        super.onFileChange(file);
        this.changeDetected(file, "update");
    }

    public void onFileDelete(File file) {
        super.onFileDelete(file);
        this.changeDetected(file, "delete");
    }

    public void onFileCreate(File file) {
        super.onFileCreate(file);
        this.changeDetected(file, "create");
    }

    protected void changeDetected(File changedFile, String operation) {
        String changedFileParentPath = changedFile.getParent().replace('\\', '/');
        String changedFilePath = changedFile.getAbsolutePath().replace('\\', '/');
        if (changedFileParentPath.endsWith("META-INF/cocoon/spring") || changedFileParentPath.endsWith("config/avalon") || changedFilePath.endsWith(".xmap") || changedFilePath.endsWith(".xmap.xml") || changedFilePath.endsWith(".class") || changedFileParentPath.endsWith("config/spring")) {
            this.log.debug((Object)("Configuration or .class file change detected [" + operation + "]: " + changedFile));
            if (consoleOutput) {
                System.out.println("RCL [" + operation + "]: " + changedFile);
            }
            reload = true;
        } else {
            this.log.debug((Object)("Other file change detected, no reload [" + operation + "]: " + changedFile));
        }
    }

    public static void enableConsoleOutput() {
        consoleOutput = true;
    }

    public static synchronized boolean isReload() {
        if (reload) {
            reload = false;
            return true;
        }
        return reload;
    }
}

