/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.tools.rcl.wrapper.servlet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.cocoon.tools.rcl.wrapper.servlet.ReloadingClassloaderManager;

public class ReloadingListener
implements HttpSessionListener,
ServletContextListener,
HttpSessionActivationListener,
HttpSessionAttributeListener,
HttpSessionBindingListener,
ServletContextAttributeListener,
ServletRequestListener {
    private static final String SERVLET_CONTEXT_CREATED = "CLC";
    private static final String SERVLET_CONTEXT_DESTROYED = "CLD";
    private static final String SESSION_CREATED = "SEC";
    private static final String SESSION_DESTROYED = "SED";
    private static final String SESSION_ACTIVATED = "SEAC";
    private static final String SESSION_PASSIVATE = "SEDE";
    private static final String VALUE_BOUND = "VB";
    private static final String VALUE_UNBOUND = "VUB";
    private static final String ATTR_REPLACED = "ARE";
    private static final String ATTR_REMOVED = "ADE";
    private static final String ATTR_ADDED = "AAD";
    private static final String CONTEXT_ATTR_REPLACED = "CARE";
    private static final String CONTEXT_ATTR_REMOVED = "CADE";
    private static final String CONTEXT_ATTR_ADDED = "CAAD";
    private static final String REQUEST_DESTROYED = "RD";
    private static final String REQUEST_INITIALIZED = "RI";
    protected List httpSessionListeners = new ArrayList();
    protected List servletContextListeners = new ArrayList();
    protected List httpSessionActivationListeners = new ArrayList();
    protected List httpSessionBindingListeners = new ArrayList();
    protected List servletContextAttributeListeners = new ArrayList();
    protected List httpSessionAttributeListeners = new ArrayList();
    protected List servletRequestListeners = new ArrayList();
    protected ServletContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void init(ServletContext context) {
        this.context = context;
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ReloadingClassloaderManager.getClassLoader(this.context));
            String listenersConfig = context.getInitParameter(ReloadingListener.class.getName());
            if (listenersConfig == null) return;
            StringTokenizer st = new StringTokenizer(listenersConfig, " \t\r\n\f;,", false);
            while (st.hasMoreTokens()) {
                String className = st.nextToken();
                try {
                    ClassLoader cl = ReloadingClassloaderManager.getClassLoader(this.context);
                    Class<?> listenerClass = cl.loadClass(className);
                    Object listener = listenerClass.newInstance();
                    if (listener instanceof HttpSessionListener) {
                        this.httpSessionListeners.add(listener);
                    }
                    if (listener instanceof ServletContextListener) {
                        this.servletContextListeners.add(listener);
                    }
                    if (listener instanceof HttpSessionActivationListener) {
                        this.httpSessionActivationListeners.add(listener);
                    }
                    if (listener instanceof HttpSessionAttributeListener) {
                        this.httpSessionAttributeListeners.add(listener);
                    }
                    if (listener instanceof HttpSessionBindingListener) {
                        this.httpSessionBindingListeners.add(listener);
                    }
                    if (listener instanceof ServletContextAttributeListener) {
                        this.servletContextAttributeListeners.add(listener);
                    }
                    if (!(listener instanceof ServletRequestListener)) continue;
                    this.servletRequestListeners.add(listener);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot load listener " + className, e);
                    return;
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void invoke(List listeners, String identifier, Object event) {
        if (ReloadingClassloaderManager.getClassLoader(this.context) == null) return;
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ReloadingClassloaderManager.getClassLoader(this.context));
            Iterator i = listeners.iterator();
            while (i.hasNext()) {
                Object listener = i.next();
                try {
                    if (SERVLET_CONTEXT_CREATED.equals(identifier)) {
                        ((ServletContextListener)listener).contextInitialized((ServletContextEvent)event);
                        continue;
                    }
                    if (SERVLET_CONTEXT_DESTROYED.equals(identifier)) {
                        ((ServletContextListener)listener).contextDestroyed((ServletContextEvent)event);
                        continue;
                    }
                    if (SESSION_CREATED.equals(identifier)) {
                        ((HttpSessionListener)listener).sessionCreated((HttpSessionEvent)event);
                        continue;
                    }
                    if (SESSION_DESTROYED.equals(identifier)) {
                        ((HttpSessionListener)listener).sessionDestroyed((HttpSessionEvent)event);
                        continue;
                    }
                    if (VALUE_BOUND.equals(identifier)) {
                        ((HttpSessionBindingListener)listener).valueBound((HttpSessionBindingEvent)event);
                        continue;
                    }
                    if (VALUE_UNBOUND.equals(identifier)) {
                        ((HttpSessionBindingListener)listener).valueUnbound((HttpSessionBindingEvent)event);
                        continue;
                    }
                    if (ATTR_ADDED.equals(identifier)) {
                        ((HttpSessionAttributeListener)listener).attributeAdded((HttpSessionBindingEvent)event);
                        continue;
                    }
                    if (ATTR_REMOVED.equals(identifier)) {
                        ((HttpSessionAttributeListener)listener).attributeRemoved((HttpSessionBindingEvent)event);
                        continue;
                    }
                    if (ATTR_REPLACED.equals(identifier)) {
                        ((HttpSessionAttributeListener)listener).attributeReplaced((HttpSessionBindingEvent)event);
                        continue;
                    }
                    if (CONTEXT_ATTR_ADDED.equals(identifier)) {
                        ((ServletContextAttributeListener)listener).attributeAdded((ServletContextAttributeEvent)event);
                        continue;
                    }
                    if (CONTEXT_ATTR_REMOVED.equals(identifier)) {
                        ((ServletContextAttributeListener)listener).attributeRemoved((ServletContextAttributeEvent)event);
                        continue;
                    }
                    if (CONTEXT_ATTR_REPLACED.equals(identifier)) {
                        ((ServletContextAttributeListener)listener).attributeReplaced((ServletContextAttributeEvent)event);
                        continue;
                    }
                    if (SESSION_ACTIVATED.equals(identifier)) {
                        ((HttpSessionActivationListener)listener).sessionDidActivate((HttpSessionEvent)event);
                        continue;
                    }
                    if (SESSION_PASSIVATE.equals(identifier)) {
                        ((HttpSessionActivationListener)listener).sessionWillPassivate((HttpSessionEvent)event);
                        continue;
                    }
                    if (REQUEST_DESTROYED.equals(identifier)) {
                        ((ServletRequestListener)listener).requestDestroyed((ServletRequestEvent)event);
                        continue;
                    }
                    if (!REQUEST_INITIALIZED.equals(identifier)) continue;
                    ((ServletRequestListener)listener).requestInitialized((ServletRequestEvent)event);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot invoke listener " + listener, e);
                    return;
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void contextDestroyed(ServletContextEvent contextEvent) {
        this.invoke(this.servletContextListeners, SERVLET_CONTEXT_DESTROYED, contextEvent);
    }

    public void contextInitialized(ServletContextEvent contextEvent) {
        ServletContext context = contextEvent.getServletContext();
        this.init(context);
        this.invoke(this.servletContextListeners, SERVLET_CONTEXT_CREATED, contextEvent);
    }

    public void sessionCreated(HttpSessionEvent event) {
        this.invoke(this.httpSessionListeners, SESSION_CREATED, event);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        this.invoke(this.httpSessionListeners, SESSION_DESTROYED, event);
    }

    public void valueBound(HttpSessionBindingEvent event) {
        this.invoke(this.httpSessionBindingListeners, VALUE_BOUND, event);
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        this.invoke(this.httpSessionBindingListeners, VALUE_UNBOUND, event);
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
        this.invoke(this.httpSessionAttributeListeners, ATTR_ADDED, event);
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        this.invoke(this.httpSessionAttributeListeners, ATTR_REMOVED, event);
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        this.invoke(this.httpSessionAttributeListeners, ATTR_REPLACED, event);
    }

    public void sessionDidActivate(HttpSessionEvent event) {
        this.invoke(this.httpSessionActivationListeners, SESSION_ACTIVATED, event);
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        this.invoke(this.httpSessionActivationListeners, SESSION_PASSIVATE, event);
    }

    public void attributeAdded(ServletContextAttributeEvent event) {
        this.invoke(this.servletContextAttributeListeners, CONTEXT_ATTR_ADDED, event);
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
        this.invoke(this.servletContextAttributeListeners, CONTEXT_ATTR_REMOVED, event);
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
        this.invoke(this.servletContextAttributeListeners, CONTEXT_ATTR_REPLACED, event);
    }

    public void requestDestroyed(ServletRequestEvent event) {
        this.invoke(this.servletRequestListeners, REQUEST_DESTROYED, event);
    }

    public void requestInitialized(ServletRequestEvent event) {
        this.invoke(this.servletRequestListeners, REQUEST_INITIALIZED, event);
    }
}

