/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.tools.rcl.wrapper.servlet;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.cocoon.tools.rcl.wrapper.servlet.CocoonReloadingListener;
import org.apache.cocoon.tools.rcl.wrapper.servlet.ReloadingClassloaderManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReloadingSpringFilter
implements Filter {
    private final Log log = LogFactory.getLog((Class)ReloadingSpringFilter.class);
    private FilterConfig config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain filterChain) throws IOException, ServletException {
        if (this.isReloadingEnabled() && CocoonReloadingListener.isReload()) {
            ReloadingSpringFilter reloadingSpringFilter = this;
            synchronized (reloadingSpringFilter) {
                this.log.info((Object)"Performing a reload of the Spring application context.");
                ClassLoader cl = ReloadingClassloaderManager.getClassLoader(this.config.getServletContext());
                Object reloader = null;
                try {
                    reloader = cl.loadClass("org.apache.cocoon.tools.rcl.springreloader.SpringReloader").newInstance();
                    Method reloadMethod = reloader.getClass().getMethod("reload", ServletContext.class);
                    reloadMethod.invoke(reloader, this.config.getServletContext());
                }
                catch (Exception e) {
                    throw new ServletException("Can't use SpringReloader.", (Throwable)e);
                }
            }
        }
        filterChain.doFilter(req, res);
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
    }

    private boolean isReloadingEnabled() throws IOException {
        Properties rclProps = new Properties();
        rclProps.load(this.config.getServletContext().getResourceAsStream("/WEB-INF/cocoon/rclwrapper.properties"));
        String reloadingEnabled = rclProps.getProperty("reloading.spring.enabled", "true");
        return reloadingEnabled.trim().toLowerCase().equals("true");
    }
}

