/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice.components;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import org.apache.cocoon.CascadingIOException;
import org.apache.cocoon.servletservice.AbsoluteServletConnection;
import org.apache.cocoon.servletservice.Absolutizable;
import org.apache.cocoon.servletservice.CallStackHelper;
import org.apache.cocoon.servletservice.ServletConnection;
import org.apache.cocoon.servletservice.postable.PostableSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.AbstractSource;
import org.apache.excalibur.store.Store;

public class ServletSource
extends AbstractSource
implements PostableSource {
    private transient Log logger = LogFactory.getLog(this.getClass());
    private Store store;
    private String location;
    private ServletConnection servletConnection;
    private boolean connected;

    public ServletSource(String location, Store store) throws IOException {
        this.store = store;
        this.location = location;
        this.servletConnection = this.createServletConnection(location);
        this.setSystemId(this.servletConnection.getURI().toASCIIString());
    }

    public InputStream getInputStream() throws IOException, SourceException {
        try {
            this.connect();
            if (this.servletConnection.getResponseCode() != 200) {
                this.servletConnection = this.createServletConnection(this.location);
                this.servletConnection.connect();
            }
            return this.servletConnection.getInputStream();
        }
        catch (ServletException e) {
            throw new CascadingIOException(e.getMessage(), (Throwable)e);
        }
    }

    private ServletConnection createServletConnection(String location) throws MalformedURLException {
        URI locationUri = null;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Trying to create a servlet connection for location " + location));
            }
            if (!(locationUri = new URI(location)).isAbsolute()) {
                throw new MalformedURLException("Only absolute URIs are allowed for the block protocol. " + locationUri.toString());
            }
            locationUri = new URI(locationUri.getRawSchemeSpecificPart());
            String servletReference = locationUri.getScheme();
            Absolutizable absolutizable = (Absolutizable)CallStackHelper.getCurrentServletContext();
            String servletName = servletReference == null ? absolutizable.getServiceName() : (servletReference.endsWith(AbsoluteServletConnection.ABSOLUTE_SERVLET_SOURCE_POSTFIX) ? servletReference.substring(0, servletReference.length() - 1) : absolutizable.getServiceName(servletReference));
            return new AbsoluteServletConnection(servletName, locationUri.getRawPath(), locationUri.getRawQuery());
        }
        catch (URISyntaxException e) {
            MalformedURLException malformedURLException = new MalformedURLException("Invalid URI syntax. " + e.getMessage());
            malformedURLException.initCause(e);
            throw malformedURLException;
        }
    }

    public SourceValidity getValidity() {
        try {
            this.connect();
            return this.servletConnection.getLastModified() > 0L ? new ServletValidity(this.servletConnection.getResponseCode()) : null;
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Exception occured while making servlet request", (Throwable)e);
            }
            return null;
        }
    }

    public long getLastModified() {
        try {
            this.connect();
            return this.servletConnection.getLastModified() > 0L ? this.servletConnection.getLastModified() : 0L;
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Exception occured while making servlet request", (Throwable)e);
            }
            return 0L;
        }
    }

    public String getMimeType() {
        try {
            this.connect();
            return this.servletConnection.getContentType();
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Exception occured while making servlet request", (Throwable)e);
            }
            return null;
        }
    }

    public boolean exists() {
        return true;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.servletConnection.getOutputStream();
    }

    private void connect() throws IOException, ServletException {
        if (this.connected) {
            return;
        }
        long lastModified = this.getStoredLastModified();
        if (lastModified > 0L) {
            this.servletConnection.setIfModifiedSince(lastModified);
        }
        this.servletConnection.connect();
        this.connected = true;
        this.setStoredLastModified(this.servletConnection.getLastModified());
    }

    private long getStoredLastModified() {
        Long lastModified = (Long)this.store.get((Object)this.calculateInternalKey());
        return lastModified != null ? lastModified : 0L;
    }

    private void setStoredLastModified(long lastModified) throws IOException {
        String key = this.calculateInternalKey();
        if (lastModified > 0L) {
            this.store.store((Object)key, (Object)new Long(lastModified));
        } else {
            this.store.remove((Object)key);
        }
    }

    private String calculateInternalKey() {
        return ServletSource.class.getName() + "$" + this.getURI();
    }

    private static final class ServletValidity
    implements SourceValidity {
        private int responseCode;

        public ServletValidity(int responseCode) {
            this.setResponseCode(responseCode);
        }

        public int isValid() {
            return 0;
        }

        public int isValid(SourceValidity newValidity) {
            if (newValidity instanceof ServletValidity) {
                ServletValidity newServletValidity = (ServletValidity)newValidity;
                switch (newServletValidity.getResponseCode()) {
                    case 304: {
                        return 1;
                    }
                    case 200: {
                        return -1;
                    }
                }
                return 0;
            }
            return 0;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public void setResponseCode(int responseCode) {
            this.responseCode = responseCode;
        }
    }
}

