/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice.postable.components;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.util.SourceUtil;
import org.apache.cocoon.core.xml.SAXParser;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.servletservice.postable.PostableSource;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ServletServiceGenerator
extends AbstractGenerator {
    private SAXParser saxParser;
    private PostableSource servletSource;

    public SAXParser getSaxParser() {
        return this.saxParser;
    }

    public void setSaxParser(SAXParser saxParser) {
        this.saxParser = saxParser;
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            SourceUtil.parse((SAXParser)this.saxParser, (Source)this.servletSource, (ContentHandler)this.xmlConsumer);
        }
        catch (SAXException e) {
            SourceUtil.handleSAXException((String)this.servletSource.getURI(), (SAXException)e);
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        Source inputSource;
        String service;
        super.setup(resolver, objectModel, src, par);
        try {
            service = this.parameters.getParameter("service");
        }
        catch (ParameterException e) {
            throw new ProcessingException((Exception)((Object)e));
        }
        try {
            try {
                this.servletSource = (PostableSource)resolver.resolveURI(service);
            }
            catch (ClassCastException e) {
                throw new ProcessingException("Resolved '" + service + "' to source that is not postable. Use servlet: protocol for service calls.");
            }
            inputSource = this.resolver.resolveURI(src);
        }
        catch (SourceException se) {
            throw SourceUtil.handle((String)("Error during resolving of '" + src + "'."), (SourceException)se);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Source " + service + " resolved to " + this.servletSource.getURI()));
            this.getLogger().debug((Object)("Source " + this.source + " resolved to " + inputSource.getURI()));
        }
        IOUtils.copy((InputStream)inputSource.getInputStream(), (OutputStream)this.servletSource.getOutputStream());
    }
}

