/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice.shielding;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ShieldingClassLoaderInterceptor
implements MethodInterceptor {
    private final ClassLoader classLoader;

    public ShieldingClassLoaderInterceptor(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Object object = invocation.proceed();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

