/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice.shielding;

import java.util.HashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.aopalliance.aop.Advice;
import org.apache.cocoon.servletservice.shielding.ServletService;
import org.apache.cocoon.servletservice.shielding.ShieldedGroupClassLoaderManager;
import org.apache.cocoon.servletservice.shielding.ShieldingClassLoaderInterceptor;
import org.springframework.aop.framework.ProxyFactory;

public class ShieldingServletService
extends ServletService {
    protected String shieldedGroup;
    protected String shieldedLib;
    protected String shieldedClasses;
    protected String classLoaderFactory;
    protected ClassLoader classLoader;

    public void setShieldedGroup(String shieldedGroup) {
        this.shieldedGroup = shieldedGroup;
    }

    public void setShieldedLib(String shieldedLib) {
        this.shieldedLib = !shieldedLib.startsWith("/") ? "/" + shieldedLib : shieldedLib;
    }

    public void setShieldedClasses(String shieldedClasses) {
        this.shieldedClasses = !shieldedClasses.startsWith("/") ? "/" + shieldedClasses : shieldedClasses;
    }

    public void setClassLoaderFactory(String classLoaderFactory) {
        this.classLoaderFactory = classLoaderFactory;
    }

    protected Servlet createEmbeddedServlet(String embeddedServletClassName, ServletConfig servletConfig) throws ServletException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("shielded-group", this.shieldedGroup);
        parameters.put("shielded-lib", this.shieldedLib);
        parameters.put("shielded-classes", this.shieldedClasses);
        parameters.put("classloader-factory", this.classLoaderFactory);
        this.classLoader = ShieldedGroupClassLoaderManager.getClassLoader(this.getServletContext(), parameters);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Class<?> servletClass = this.classLoader.loadClass(embeddedServletClassName);
            Servlet embeddedServlet = (Servlet)servletClass.newInstance();
            ProxyFactory proxyFactory = new ProxyFactory((Object)embeddedServlet);
            proxyFactory.addAdvice((Advice)new ShieldingClassLoaderInterceptor(this.classLoader));
            Servlet servlet = (Servlet)proxyFactory.getProxy();
            return servlet;
        }
        catch (Exception e) {
            throw new ServletException("Loading class for embedded servlet failed " + embeddedServletClassName, (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

