/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractInputModule;
import org.apache.cocoon.environment.ObjectModelHelper;

public class ProjectPathModule
extends AbstractInputModule
implements ThreadSafe {
    protected static final String PROJECT_PARAM_NAME = "uri-prefix";
    protected static final String PROJECT_PARAM_DEFAULT = "/";
    protected String projectBase;
    static final Vector returnNames;

    public void configure(Configuration conf) throws ConfigurationException {
        this.projectBase = conf.getChild(PROJECT_PARAM_NAME).getValue();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Configuration supplied: " + this.projectBase));
        }
        if (this.projectBase == null) {
            this.projectBase = PROJECT_PARAM_DEFAULT;
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn((Object)"No configuration supplied, using default: /");
            }
        }
        if (this.projectBase.equals("")) {
            this.projectBase = PROJECT_PARAM_DEFAULT;
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn((Object)"Empty configuration supplied, using default: /");
            }
        }
    }

    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        String uri = ObjectModelHelper.getRequest((Map)objectModel).getServletPath();
        StringBuffer result = new StringBuffer(uri.length());
        int baseIndex = uri.indexOf(this.projectBase);
        if (baseIndex == -1) {
            throw new ConfigurationException("No project-base path found in URI");
        }
        uri = uri.substring(baseIndex + this.projectBase.length());
        try {
            if (name.startsWith("relative")) {
                int nextIndex = 0;
                while ((nextIndex = uri.indexOf(47, nextIndex) + 1) > 0) {
                    result.append("../");
                }
            } else if (name.startsWith("path")) {
                result.append(PROJECT_PARAM_DEFAULT);
                result.append(uri);
            } else if (name.startsWith("folder")) {
                result.append(PROJECT_PARAM_DEFAULT);
                result.append(uri.substring(0, uri.lastIndexOf(PROJECT_PARAM_DEFAULT) + 1));
            } else if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn((Object)("Invalid verb: " + name));
            }
            return result;
        }
        catch (Exception mue) {
            throw new ConfigurationException("Problems resolving project path.", (Throwable)mue);
        }
    }

    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        return returnNames.iterator();
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        LinkedList<Object> values = new LinkedList<Object>();
        values.add(this.getAttribute(name, modeConf, objectModel));
        return values.toArray();
    }

    static {
        Vector<String> tmp = new Vector<String>();
        tmp.add("relative");
        tmp.add("path");
        tmp.add("folder");
        returnNames = tmp;
    }
}

