/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.impl.AbstractSource;

public class ModuleSource
extends AbstractSource {
    private static final String SCHEME = "module";
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String attributeType;
    private String attributeName;
    private String xPath;
    private ServiceManager manager;
    private Map objectModel;

    public ModuleSource(Map objectModel, String uri, ServiceManager manager) throws MalformedURLException {
        this.objectModel = objectModel;
        this.manager = manager;
        this.setSystemId(uri);
        int start = 0;
        int end = uri.indexOf(58);
        if (end == -1) {
            throw new MalformedURLException("Malformed uri for module source (cannot find scheme) : " + uri);
        }
        String scheme = uri.substring(start, end);
        if (!SCHEME.equals(scheme)) {
            throw new MalformedURLException("Malformed uri for a module source : " + uri);
        }
        this.setScheme(scheme);
        start = end + 1;
        end = uri.indexOf(58, start);
        if (end == -1) {
            throw new MalformedURLException("Malformed uri for module source (cannot find attribute type) : " + uri);
        }
        this.attributeType = uri.substring(start, end);
        start = end + 1;
        if ((end = uri.indexOf(35, start)) == -1) {
            end = uri.length();
        }
        if (end == start) {
            throw new MalformedURLException("Malformed uri for module source (cannot find attribute name) : " + uri);
        }
        this.attributeName = uri.substring(start, end);
        start = end + 1;
        this.xPath = start < uri.length() ? uri.substring(start) : "";
    }

    public InputStream getInputStream() throws IOException {
        JXPathContext context;
        Object obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Getting InputStream for " + this.getURI()));
        }
        if ((obj = this.getInputAttribute(this.attributeType, this.attributeName)) == null) {
            throw new SourceException(" The attribute: " + this.attributeName + " is empty");
        }
        if (this.xPath.length() != 0 && !this.xPath.equals("/") && (obj = (context = JXPathContext.newContext((Object)obj)).getValue(this.xPath)) == null) {
            throw new SourceException("the xpath: " + this.xPath + " applied on the attribute: " + this.attributeName + " returns null");
        }
        if (obj instanceof InputStream) {
            return (InputStream)obj;
        }
        if (obj instanceof Source) {
            return ((Source)obj).getInputStream();
        }
        if (obj instanceof String) {
            return new ByteArrayInputStream(((String)obj).getBytes());
        }
        if (obj instanceof byte[]) {
            return new ByteArrayInputStream((byte[])obj);
        }
        throw new SourceException("The object type: " + obj.getClass() + " could not be serialized as a InputStream " + obj);
    }

    public boolean exists() {
        boolean exists;
        try {
            exists = this.getInputAttribute(this.attributeType, this.attributeName) != null;
        }
        catch (SourceException e) {
            exists = false;
        }
        return exists;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getInputAttribute(String inputModuleName, String attributeName) throws SourceException {
        Object obj;
        ServiceSelector selector;
        block7: {
            selector = null;
            InputModule inputModule = null;
            try {
                try {
                    selector = (ServiceSelector)this.manager.lookup(InputModule.ROLE + "Selector");
                    inputModule = (InputModule)selector.select((Object)inputModuleName);
                    obj = inputModule.getAttribute(attributeName, null, this.objectModel);
                }
                catch (ServiceException e) {
                    throw new SourceException("Could not find an InputModule of the type " + inputModuleName, (Throwable)e);
                }
                catch (ConfigurationException e) {
                    throw new SourceException("Could not find an attribute: " + attributeName + " from the InputModule " + inputModuleName, (Throwable)e);
                }
                Object var8_6 = null;
                if (inputModule == null) break block7;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (inputModule != null) {
                    selector.release(inputModule);
                }
                this.manager.release(selector);
                throw throwable;
            }
            selector.release((Object)inputModule);
        }
        this.manager.release((Object)selector);
        return obj;
    }
}

