/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.NamedProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.util.location.Location;

public class ActionSetNode
extends AbstractProcessingNode
implements NamedProcessingNode {
    public static final String CALLER_PARAMETERS = ActionSetNode.class.getName() + "/CallerParameters";
    public static final String ACTION_RESULTS = ActionSetNode.class.getName() + "/ActionResults";
    private ProcessingNode[] nodes;
    private String[] actionNames;

    public ActionSetNode(String name, ProcessingNode[] nodes, String[] actionNames) {
        super(name);
        this.nodes = nodes;
        this.actionNames = actionNames;
    }

    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        throw new ProcessingException("An action-set cannot be invoked", this.getLocation());
    }

    public final Map call(Environment env, InvokeContext context, Parameters params) throws Exception {
        String cocoonAction = env.getAction();
        env.setAttribute(CALLER_PARAMETERS, (Object)params);
        HashMap result = null;
        try {
            for (int i = 0; i < this.nodes.length; ++i) {
                String actionName = this.actionNames[i];
                if (actionName != null && !actionName.equals(cocoonAction)) continue;
                this.nodes[i].invoke(env, context);
                Map actionResult = (Map)env.getAttribute(ACTION_RESULTS);
                env.removeAttribute(ACTION_RESULTS);
                if (actionResult == null) continue;
                if (result == null) {
                    result = new HashMap(actionResult);
                    continue;
                }
                result.putAll(actionResult);
            }
        }
        catch (Exception e) {
            throw ProcessingException.throwLocated((String)"Sitemap: error invoking action set", (Throwable)e, (Location)this.getLocation());
        }
        return result;
    }

    public String getName() {
        return this.componentName;
    }
}

