/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.flow.Interpreter;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ParameterizableProcessingNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.util.location.Location;

public class CallFunctionNode
extends AbstractProcessingNode
implements ParameterizableProcessingNode {
    protected Map parameters;
    protected VariableResolver functionName;
    protected VariableResolver continuationId;
    protected String[] argumentNames;
    protected Interpreter interpreter;

    public CallFunctionNode(VariableResolver functionName, VariableResolver continuationId, String[] argumentNames) {
        super(null);
        this.functionName = functionName;
        this.continuationId = continuationId;
        this.argumentNames = argumentNames;
    }

    public void setParameters(Map parameterMap) {
        this.parameters = parameterMap;
    }

    public void setInterpreter(Interpreter interp) throws Exception {
        this.interpreter = interp;
    }

    public boolean invoke(Environment env, InvokeContext context) throws Exception {
        String name;
        ArrayList<Interpreter.Argument> args;
        Map objectModel = env.getObjectModel();
        if (this.argumentNames.length != 0) {
            Parameters params = VariableResolver.buildParameters(this.parameters, context, objectModel);
            args = new ArrayList<Interpreter.Argument>(this.argumentNames.length);
            for (int i = 0; i < this.argumentNames.length; ++i) {
                name = this.argumentNames[i];
                args.add(new Interpreter.Argument(name, params.getParameter(name)));
            }
        } else {
            args = Collections.EMPTY_LIST;
        }
        Redirector redirector = context.getRedirector();
        String continuation = this.continuationId.resolve(context, env.getObjectModel());
        if (continuation != null && continuation.length() > 0) {
            try {
                this.interpreter.handleContinuation(continuation, args, redirector);
            }
            catch (Exception e) {
                throw ProcessingException.throwLocated((String)"Sitemap: error calling continuation", (Throwable)e, (Location)this.getLocation());
            }
            if (!redirector.hasRedirected()) {
                throw new ProcessingException("Sitemap: continuation did not send a response", this.getLocation());
            }
            return true;
        }
        name = this.functionName.resolve(context, objectModel);
        if (name != null && name.length() > 0) {
            try {
                this.interpreter.callFunction(name, args, redirector);
            }
            catch (Exception e) {
                throw ProcessingException.throwLocated((String)("Sitemap: error calling function '" + name + "'"), (Throwable)e, (Location)this.getLocation());
            }
            if (!redirector.hasRedirected()) {
                throw new ProcessingException("Sitemap: function '" + name + "' did not send a response", this.getLocation());
            }
            return true;
        }
        throw new ProcessingException("Sitemap: no function nor continuation given in <map:call function>", this.getLocation());
    }
}

