/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container.spring.avalon;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.configuration.MutableSettings;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.core.container.spring.avalon.AvalonUtils;
import org.apache.cocoon.core.container.spring.avalon.ComponentInfo;
import org.apache.cocoon.core.container.spring.avalon.ConfigurationInfo;
import org.apache.cocoon.core.container.spring.logger.LoggerUtils;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.cocoon.util.avalon.CLLoggerWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class AvalonBeanPostProcessor
extends AbstractLogEnabled
implements DestructionAwareBeanPostProcessor,
BeanFactoryAware {
    protected static final Configuration EMPTY_CONFIG;
    protected Context context;
    protected BeanFactory beanFactory;
    protected ConfigurationInfo configurationInfo;
    protected Settings settings = new MutableSettings("test");
    protected ResourceLoader resourceLoader = new DefaultResourceLoader();
    protected String location = "classpath*:META-INF/cocoon/avalon";

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void setResourceLoader(ResourceLoader loader) {
        this.resourceLoader = loader;
    }

    public void setLocation(String value) {
        this.location = value;
    }

    public void setBeanFactory(BeanFactory factory) throws BeansException {
        this.beanFactory = factory;
    }

    public void setConfigurationInfo(ConfigurationInfo configurationInfo) {
        this.configurationInfo = configurationInfo;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void init() {
    }

    protected List getKeys(Properties mergedProps, String role) {
        String prefix = role + '/';
        ArrayList<String> l = new ArrayList<String>();
        Iterator<Object> i = mergedProps.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.startsWith(prefix)) continue;
            l.add(key);
        }
        return l;
    }

    protected Configuration getAndCreateConfiguration(Configuration config, String name) {
        if (config.getChild(name, false) == null) {
            DefaultConfiguration newConfig = new DefaultConfiguration(name, config.getLocation());
            ((DefaultConfiguration)config).addChild((Configuration)newConfig);
        }
        return config.getChild(name, false);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        try {
            ContainerUtil.start((Object)bean);
        }
        catch (Exception e) {
            throw new BeanInitializationException("Unable to start bean " + beanName, (Throwable)e);
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        ComponentInfo info = (ComponentInfo)this.configurationInfo.getComponents().get(beanName);
        try {
            if (info == null) {
                return bean;
            }
            if (bean instanceof LogEnabled) {
                ContainerUtil.enableLogging((Object)bean, (Logger)new CLLoggerWrapper(LoggerUtils.getChildLogger(this.beanFactory, info.getLoggerCategory())));
            } else if (bean instanceof AbstractLogEnabled && info.getLoggerCategory() != null) {
                ((AbstractLogEnabled)bean).setLogger(LoggerUtils.getChildLogger(this.beanFactory, info.getLoggerCategory()));
            }
            ContainerUtil.contextualize((Object)bean, (Context)this.context);
            ContainerUtil.service((Object)bean, (ServiceManager)((ServiceManager)this.beanFactory.getBean(ServiceManager.class.getName())));
            Configuration config = info.getProcessedConfiguration();
            if (config == null) {
                config = info.getConfiguration();
                config = config == null ? EMPTY_CONFIG : AvalonUtils.replaceProperties(config, this.settings);
                info.setProcessedConfiguration(config);
            }
            if (bean instanceof Configurable) {
                ContainerUtil.configure((Object)bean, (Configuration)config);
            } else if (bean instanceof Parameterizable) {
                Parameters p = info.getParameters();
                if (p == null) {
                    p = Parameters.fromConfiguration((Configuration)config);
                    info.setParameters(p);
                }
                ContainerUtil.parameterize((Object)bean, (Parameters)p);
            }
            ContainerUtil.initialize((Object)bean);
        }
        catch (Exception e) {
            throw new BeanCreationException("Unable to initialize Avalon component with role " + beanName, (Throwable)e);
        }
        return bean;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        try {
            ContainerUtil.stop((Object)bean);
        }
        catch (Exception e) {
            throw new BeanInitializationException("Unable to stop bean " + beanName, (Throwable)e);
        }
        ContainerUtil.dispose((Object)bean);
    }

    static {
        DefaultConfiguration config = new DefaultConfiguration("empty");
        config.makeReadOnly();
        EMPTY_CONFIG = config;
    }
}

