/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.spring.configurator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.cocoon.spring.configurator.ResourceFilter;
import org.apache.commons.logging.Log;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public abstract class ResourceUtils {
    public static String getUri(Resource resource) throws IOException {
        if (resource == null) {
            return null;
        }
        return ResourceUtils.correctUri(resource.getURL().toExternalForm());
    }

    protected static String correctUri(String uri) {
        if (uri.startsWith("file:")) {
            File f = new File(uri.substring(5));
            return "file://" + f.getAbsolutePath();
        }
        return uri;
    }

    public static boolean isClasspathUri(String uri) {
        return uri.startsWith("classpath*:") || uri.startsWith("classpath:");
    }

    public static void readProperties(String propertiesPath, Properties properties, ResourceLoader resourceLoader, ResourceFilter resourceFilter, Log logger) {
        Resource[] resources;
        block13: {
            Resource resource;
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug((Object)("Reading properties from directory: " + propertiesPath));
            }
            Object resolver = resourceLoader instanceof ResourcePatternResolver ? (ResourcePatternResolver)resourceLoader : new PathMatchingResourcePatternResolver(resourceLoader);
            resources = null;
            boolean load = true;
            if (!ResourceUtils.isClasspathUri(propertiesPath) && !(resource = resolver.getResource(propertiesPath)).exists()) {
                load = false;
            }
            if (load) {
                try {
                    resources = resolver.getResources(propertiesPath + "/*.properties");
                    resources = ResourceUtils.filterResources(resources, resourceFilter);
                    if (logger != null && logger.isDebugEnabled()) {
                        logger.debug((Object)("Found " + resources.length + " matching resources in " + propertiesPath + "/*.properties"));
                    }
                }
                catch (IOException ignore) {
                    if (logger == null || !logger.isDebugEnabled()) break block13;
                    logger.debug((Object)("Unable to read properties from directory '" + propertiesPath + "' - Continuing initialization."), (Throwable)ignore);
                }
            }
        }
        if (resources != null) {
            Arrays.sort(resources, ResourceUtils.getResourceComparator());
            for (int i = 0; i < resources.length; ++i) {
                Resource src = resources[i];
                try {
                    if (logger != null && logger.isDebugEnabled()) {
                        logger.debug((Object)("Reading settings from '" + src.getURL() + "'."));
                    }
                    InputStream propsIS = src.getInputStream();
                    properties.load(propsIS);
                    propsIS.close();
                    continue;
                }
                catch (IOException ignore) {
                    if (logger == null || !logger.isDebugEnabled()) continue;
                    logger.info((Object)("Unable to read properties from file '" + src.getDescription() + "' - Continuing initialization."), (Throwable)ignore);
                }
            }
        } else if (logger != null && logger.isDebugEnabled()) {
            logger.debug((Object)("Directory '" + propertiesPath + "' does not exist - Continuing initialization."));
        }
    }

    public static Comparator getResourceComparator() {
        return new ResourceComparator();
    }

    public static Properties getPOMProperties(String groupId, String artifactId) {
        String resourceName = "META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties";
        try {
            Properties p = new Properties();
            InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
            if (resourceAsStream == null) {
                return null;
            }
            p.load(resourceAsStream);
            return p;
        }
        catch (IOException ignore) {
            return null;
        }
    }

    public static Resource[] filterResources(Resource[] resources, ResourceFilter filter) {
        if (filter == null) {
            return resources;
        }
        HashSet<Resource> resourcesSet = new HashSet<Resource>(Arrays.asList(resources));
        Set filteredResources = filter.filter(resourcesSet);
        return new ArrayList(filteredResources).toArray(new Resource[0]);
    }

    protected static final class ResourceComparator
    implements Comparator {
        protected static final String WEB_INF_CLASSES_META_INF_COCOON = "/WEB-INF/classes/META-INF/cocoon/";

        protected ResourceComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof Resource) || !(o2 instanceof Resource)) {
                return 0;
            }
            try {
                boolean webInfClasses2;
                String name1 = ((Resource)o1).getURL().toExternalForm();
                String name2 = ((Resource)o2).getURL().toExternalForm();
                name1 = name1.replace('\\', '/');
                name2 = name2.replace('\\', '/');
                boolean webInfClasses1 = name1.indexOf(WEB_INF_CLASSES_META_INF_COCOON) != -1;
                boolean bl = webInfClasses2 = name2.indexOf(WEB_INF_CLASSES_META_INF_COCOON) != -1;
                if (!webInfClasses1 && webInfClasses2) {
                    return -1;
                }
                if (webInfClasses1 && !webInfClasses2) {
                    return 1;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return ((Resource)o1).getFilename().compareTo(((Resource)o2).getFilename());
        }
    }
}

