/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.store.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.store.StoreJanitor;

public class StoreJanitorImpl
implements StoreJanitor,
Runnable {
    private static final String ALG_ROUND_ROBIN = "round-robin";
    private static final String ALG_ALL_STORES = "all-stores";
    private static final int FREE_MEMORY = 0x100000;
    private static final int HEAP_SIZE = 66600000;
    private static final int CLEAN_UP_THREAD_INTERVAL = 10000;
    private static final boolean ADAPTIVE_THREAD_INTERVAL = false;
    private static final int PERCENT_TO_FREE = 10;
    private Log logger = LogFactory.getLog(this.getClass());
    private int minFreeMemory = 0x100000;
    private int maxHeapSize = 66600000;
    private int threadInterval = 10000;
    private int minThreadInterval = 500;
    private boolean adaptiveThreadInterval = false;
    private int priority = -1;
    private String freeingAlgorithm = "round-robin";
    private double fraction = 0.1;
    protected boolean invokeGC;
    private Runtime jvm;
    private ArrayList storelist;
    private int index = -1;
    private boolean doRun;
    protected long inUse;
    private boolean firstRun = true;
    protected long interval = Long.MAX_VALUE;
    private long maxRateOfChange = 1L;

    public void setFreeMemory(int freeMemory) {
        this.minFreeMemory = freeMemory;
    }

    public void setHeapSize(int heapSize) {
        this.maxHeapSize = heapSize;
    }

    public void setCleanupThreadInterval(int cleanupThreadInterval) {
        this.threadInterval = cleanupThreadInterval * 1000;
    }

    public void setAdaptiveThreadInterval(boolean adaptiveThreadInterval) {
        this.adaptiveThreadInterval = adaptiveThreadInterval;
    }

    public void setPercentToFree(double percentToFree) {
        this.fraction = percentToFree / 100.0;
    }

    public void setInvokeGC(boolean invokeGC) {
        this.invokeGC = invokeGC;
    }

    public void setThreadPriority(int threadPriority) {
        this.priority = threadPriority;
    }

    public void setFreeingAlgorithm(String algorithm) {
        this.freeingAlgorithm = algorithm;
    }

    public Log getLogger() {
        return this.logger;
    }

    public void setLogger(Log l) {
        this.logger = l;
    }

    public void init() throws Exception {
        this.jvm = Runtime.getRuntime();
        if (this.priority == -1) {
            this.priority = Thread.currentThread().getPriority();
        }
        if (this.getMinFreeMemory() < 1) {
            throw new Exception("StoreJanitorImpl freememory parameter has to be greater then 1");
        }
        if (this.getMaxHeapSize() < 1) {
            throw new Exception("StoreJanitorImpl heapsize parameter has to be greater then 1");
        }
        if (this.getThreadInterval() < 1) {
            throw new Exception("StoreJanitorImpl cleanupthreadinterval parameter has to be greater then 1");
        }
        if (this.getPriority() < 1 || this.getPriority() > 10) {
            throw new Exception("StoreJanitorImpl threadpriority has to be between 1 and 10");
        }
        if (this.fraction > 1.0 && this.fraction < 0.01) {
            throw new Exception("StoreJanitorImpl percentToFree, has to be between 1 and 100");
        }
        if (!this.freeingAlgorithm.equals(ALG_ROUND_ROBIN) && !this.freeingAlgorithm.equals(ALG_ALL_STORES)) {
            throw new Exception("StoreJanitorImpl freeingAlgorithm, has to be 'round-robin' or 'all-stores'. '" + this.freeingAlgorithm + "' is not supported.");
        }
        this.storelist = new ArrayList();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("minimum free memory=" + this.getMinFreeMemory()));
            this.getLogger().debug((Object)("heapsize=" + this.getMaxHeapSize()));
            this.getLogger().debug((Object)("thread interval=" + this.getThreadInterval()));
            this.getLogger().debug((Object)("adaptivethreadinterval=" + this.getAdaptiveThreadInterval()));
            this.getLogger().debug((Object)("priority=" + this.getPriority()));
            this.getLogger().debug((Object)("percent=" + this.fraction * 100.0));
            this.getLogger().debug((Object)("invoke gc=" + this.invokeGC));
        }
        this.doStart();
    }

    private void doStart() throws Exception {
        this.doRun = true;
        Thread checker = new Thread(this);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Intializing checker thread");
        }
        checker.setPriority(this.getPriority());
        checker.setDaemon(true);
        checker.setName("checker");
        checker.start();
    }

    private void doStop() {
        this.doRun = false;
    }

    public void destroy() {
        this.doStop();
    }

    public void run() {
        this.inUse = this.memoryInUse();
        while (this.doRun) {
            this.checkMemory();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Sleeping for " + this.interval + "ms"));
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.firstRun) continue;
            this.firstRun = false;
            this.inUse = this.memoryInUse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkMemory() {
        if (this.getAdaptiveThreadInterval()) {
            long change = this.memoryInUse() - this.inUse;
            long rateOfChange = this.longDiv(change * 1000L, this.interval);
            if (this.maxRateOfChange < rateOfChange) {
                this.maxRateOfChange = (this.maxRateOfChange + rateOfChange) / 2L;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Waking after " + this.interval + "ms, in use change " + change + "b to " + this.memoryInUse() + "b, rate " + rateOfChange + "b/sec, max rate " + this.maxRateOfChange + "b/sec"));
            }
        }
        if (this.memoryLow()) {
            if (this.invokeGC) {
                this.freePhysicalMemory();
            }
            StoreJanitorImpl storeJanitorImpl = this;
            synchronized (storeJanitorImpl) {
                if (!this.invokeGC || this.memoryLow() && this.getStoreList().size() > 0) {
                    this.freeMemory();
                    this.setIndex(this.getIndex() + 1);
                }
            }
        }
        if (this.getAdaptiveThreadInterval()) {
            this.interval = this.minTimeToFill(this.maxRateOfChange) * 1000L / 2L;
            if (this.interval > (long)this.threadInterval) {
                this.interval = this.threadInterval;
            } else if (this.interval < (long)this.minThreadInterval) {
                this.interval = this.minThreadInterval;
            }
            this.inUse = this.memoryInUse();
        } else {
            this.interval = this.threadInterval;
        }
    }

    private boolean memoryLow() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("JVM Memory total: " + this.getJVM().totalMemory() + ", free: " + this.getJVM().freeMemory()));
        }
        if (this.getJVM().totalMemory() >= (long)this.getMaxHeapSize() && this.getJVM().freeMemory() < (long)this.getMinFreeMemory()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Memory is low!");
            }
            return true;
        }
        return false;
    }

    protected long memoryInUse() {
        return this.jvm.totalMemory() - this.jvm.freeMemory();
    }

    private long minTimeToFill(long rate) {
        return this.longDiv(this.jvm.freeMemory(), rate);
    }

    private long longDiv(long top, long bottom) {
        try {
            return top / bottom;
        }
        catch (Exception e) {
            return top > 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
    }

    public synchronized void register(Store store) {
        this.getStoreList().add(store);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Registered store instance " + store + ". Stores now: " + this.getStoreList().size()));
        }
    }

    public synchronized void unregister(Store store) {
        this.getStoreList().remove(store);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Unregistered store instance " + store + ". Stores now: " + this.getStoreList().size()));
        }
    }

    public Iterator iterator() {
        return this.getStoreList().iterator();
    }

    private void freeMemory() {
        try {
            if (this.freeingAlgorithm.equals(ALG_ALL_STORES)) {
                Iterator i = this.iterator();
                while (i.hasNext()) {
                    this.removeStoreObjects((Store)i.next());
                }
                return;
            }
            if (this.getIndex() < this.getStoreList().size()) {
                if (this.getIndex() == -1) {
                    this.setIndex(0);
                }
            } else {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"Restarting from the beginning");
                }
                this.setIndex(0);
            }
            this.removeStoreObjects((Store)this.getStoreList().get(this.getIndex()));
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error in freeMemory()", (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this.getLogger().error((Object)"OutOfMemoryError in freeMemory()");
        }
    }

    private void removeStoreObjects(Store store) {
        int limit = this.calcToFree(store);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Freeing " + limit + " items from store " + store + " with " + store.size() + " items."));
        }
        for (int i = 0; i < limit; ++i) {
            try {
                store.free();
                continue;
            }
            catch (OutOfMemoryError e) {
                this.getLogger().error((Object)"OutOfMemoryError while releasing an object from the store.");
            }
        }
    }

    private int calcToFree(Store store) {
        int cnt = store.size();
        if (cnt < 0) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Unknown size of the store: " + store));
            }
            return 0;
        }
        int res = (int)((double)cnt * this.fraction);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Calculating size for store " + store + " with size " + cnt + ": " + res));
        }
        return res;
    }

    private void freePhysicalMemory() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Invoking GC. Memory total: " + this.getJVM().totalMemory() + ", free: " + this.getJVM().freeMemory()));
        }
        this.getJVM().runFinalization();
        this.getJVM().gc();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("GC complete. Memory total: " + this.getJVM().totalMemory() + ", free: " + this.getJVM().freeMemory()));
        }
    }

    private int getMinFreeMemory() {
        return this.minFreeMemory;
    }

    private int getMaxHeapSize() {
        return this.maxHeapSize;
    }

    private int getPriority() {
        return this.priority;
    }

    private int getThreadInterval() {
        return this.threadInterval;
    }

    private boolean getAdaptiveThreadInterval() {
        return this.adaptiveThreadInterval;
    }

    private Runtime getJVM() {
        return this.jvm;
    }

    private ArrayList getStoreList() {
        return this.storelist;
    }

    private int getIndex() {
        return this.index;
    }

    private void setIndex(int _index) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Setting index=" + _index));
        }
        this.index = _index;
    }
}

