/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.template.instruction;

import java.util.Iterator;
import java.util.Stack;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.el.parsing.Subst;
import org.apache.cocoon.template.environment.ErrorHolder;
import org.apache.cocoon.template.environment.ExecutionContext;
import org.apache.cocoon.template.environment.ParsingContext;
import org.apache.cocoon.template.instruction.Instruction;
import org.apache.cocoon.template.instruction.MacroContext;
import org.apache.cocoon.template.script.Invoker;
import org.apache.cocoon.template.script.event.AttributeEvent;
import org.apache.cocoon.template.script.event.CopyAttribute;
import org.apache.cocoon.template.script.event.Event;
import org.apache.cocoon.template.script.event.StartDocument;
import org.apache.cocoon.template.script.event.StartElement;
import org.apache.cocoon.template.script.event.SubstituteAttribute;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.util.NamespacesTable;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Import
extends Instruction {
    private final AttributeEvent uri;
    private final Subst select;

    public Import(ParsingContext parsingContext, StartElement raw, Attributes attrs, Stack stack) throws SAXException {
        super(raw);
        Locator locator = this.getLocation();
        Iterator iter = raw.getAttributeEvents().iterator();
        AttributeEvent uri = null;
        Subst select = null;
        while (iter.hasNext()) {
            AttributeEvent e = (AttributeEvent)iter.next();
            if (!e.getLocalName().equals("uri")) continue;
            uri = e;
            break;
        }
        if (uri != null) {
            String context = attrs.getValue("context");
            if (context != null) {
                select = parsingContext.getStringTemplateParser().compileExpr(context, "import: \"context\": ", locator);
            }
        } else {
            throw new SAXParseException("import: \"uri\" is required", locator, null);
        }
        this.uri = uri;
        this.select = select;
    }

    public Event execute(XMLConsumer consumer, ObjectModel objectModel, ExecutionContext executionContext, MacroContext macroContext, NamespacesTable namespaces, Event startEvent, Event endEvent) throws SAXException {
        StartDocument doc;
        String uri;
        AttributeEvent e = this.uri;
        if (e instanceof CopyAttribute) {
            CopyAttribute copy = (CopyAttribute)e;
            uri = copy.getValue();
        } else {
            StringBuffer buf = new StringBuffer();
            SubstituteAttribute substAttr = (SubstituteAttribute)e;
            Iterator i = substAttr.getSubstitutions().iterator();
            while (i.hasNext()) {
                Object val;
                Subst subst = (Subst)i.next();
                try {
                    val = subst.getValue(objectModel);
                }
                catch (Exception exc) {
                    throw new SAXParseException(exc.getMessage(), this.getLocation(), exc);
                }
                catch (Error err) {
                    throw new SAXParseException(err.getMessage(), this.getLocation(), new ErrorHolder(err));
                }
                buf.append(val != null ? val.toString() : "");
            }
            uri = buf.toString();
        }
        try {
            doc = executionContext.getScriptManager().resolveTemplate(uri);
        }
        catch (ProcessingException exc) {
            throw new SAXParseException(exc.getMessage(), this.getLocation(), (Exception)((Object)exc));
        }
        if (this.select != null) {
            objectModel.markLocalContext();
            try {
                Object obj = this.select.getValue(objectModel);
                objectModel.put((Object)"contextBean", obj);
                objectModel.fillContext();
            }
            catch (Exception exc) {
                throw new SAXParseException(exc.getMessage(), this.getLocation(), exc);
            }
            catch (Error err) {
                throw new SAXParseException(err.getMessage(), this.getLocation(), new ErrorHolder(err));
            }
        }
        try {
            Invoker.execute(consumer, objectModel, executionContext, macroContext, namespaces, doc.getNext(), doc.getEndDocument());
        }
        catch (Exception exc) {
            throw new SAXParseException("Exception occurred in imported template " + uri + ": " + exc.getMessage(), this.getLocation(), exc);
        }
        if (this.select != null) {
            objectModel.cleanupLocalContext();
        }
        return this.getEndInstruction().getNext();
    }
}

