/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.Collator;
import java.util.Arrays;
import java.util.Locale;
import org.apache.cocoon.util.StringUtils;

public class IOUtils {
    static final String[] keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
    static final Collator englishCollator = Collator.getInstance(Locale.ENGLISH);
    static final char keywordSuffix = '_';

    public static void serializeString(File file, String string) throws IOException {
        IOUtils.serializeString(file, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeString(File file, String string, String encoding) throws IOException {
        OutputStreamWriter fw = encoding == null ? new FileWriter(file) : new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
        try {
            fw.write(string);
            ((Writer)fw).flush();
        }
        finally {
            ((Writer)fw).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String deserializeString(File file) throws IOException {
        char[] chr = new char[4096];
        StringBuffer buffer = new StringBuffer();
        FileReader reader = new FileReader(file);
        try {
            int len;
            while ((len = reader.read(chr)) > 0) {
                buffer.append(chr, 0, len);
            }
        }
        finally {
            reader.close();
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeObject(File file, Object object) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(fos));
            oos.writeObject(object);
            oos.flush();
        }
        finally {
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserializeObject(File file) throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        Object object = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(fis));
            object = ois.readObject();
        }
        finally {
            fis.close();
        }
        return object;
    }

    private static boolean isJavaKeyword(String keyword) {
        return Arrays.binarySearch(keywords, keyword, englishCollator) >= 0;
    }

    public static String normalizedFilename(String filename) {
        if ("".equals(filename)) {
            return "";
        }
        filename = File.separatorChar == '\\' ? filename.replace('/', '\\') : filename.replace('\\', '/');
        String[] path = org.apache.commons.lang.StringUtils.split((String)filename, (String)File.separator);
        int start = path[0].length() == 0 ? 1 : 0;
        StringBuffer buffer = new StringBuffer();
        for (int i = start; i < path.length; ++i) {
            if (i > start) {
                buffer.append(File.separator);
            }
            if (path[i].equals("..")) {
                int lio;
                for (lio = buffer.length() - 2; lio >= 0 && !buffer.substring(lio).startsWith(File.separator); --lio) {
                }
                if (lio < 0) continue;
                buffer.setLength(lio);
                continue;
            }
            char[] chars = path[i].toCharArray();
            if (chars.length < 1 || !Character.isLetter(chars[0])) {
                buffer.append('_');
            }
            for (int j = 0; j < chars.length; ++j) {
                if (StringUtils.isAlphaNumeric(chars[j])) {
                    buffer.append(chars[j]);
                    continue;
                }
                buffer.append('_');
            }
            if (!IOUtils.isJavaKeyword(path[i])) continue;
            buffer.append('_');
        }
        return buffer.toString();
    }

    public static String pathComponent(String filename) {
        int i = filename.lastIndexOf(File.separator);
        return i > -1 ? filename.substring(0, i) : filename;
    }

    public static String fileComponent(String filename) {
        int i = filename.lastIndexOf(File.separator);
        return i > -1 ? filename.substring(i + 1) : filename;
    }

    public static String baseName(String filename) {
        int i = filename.lastIndexOf(46);
        return i > -1 ? filename.substring(0, i) : filename;
    }

    public static String getFullFilename(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            return file.getAbsolutePath();
        }
    }

    public static String getContextFilePath(String directoryPath, String filePath) {
        try {
            File directory = new File(directoryPath);
            File file = new File(filePath);
            directoryPath = directory.getCanonicalPath();
            filePath = file.getCanonicalPath();
            if (!directoryPath.endsWith(File.separator)) {
                directoryPath = directoryPath + File.separator;
            }
            if (directoryPath.indexOf(47) != -1 && directoryPath.indexOf(92) != -1) {
                directoryPath = directoryPath.replace('\\', File.separator.charAt(0));
                directoryPath = directoryPath.replace('/', File.separator.charAt(0));
            }
            if (filePath.indexOf(47) != -1 && filePath.indexOf(92) != -1) {
                filePath = filePath.replace('\\', File.separator.charAt(0));
                filePath = filePath.replace('/', File.separator.charAt(0));
            }
            if (filePath.startsWith(directoryPath)) {
                filePath = filePath.substring(directoryPath.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filePath;
    }

    public static File createFile(File destDir, String filename) {
        File file = new File(destDir, filename);
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        return file;
    }

    public static byte[] objectToBytes(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(baos);
        os.writeObject(object);
        return baos.toByteArray();
    }

    public static Object bytesToObject(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream is = new ObjectInputStream(bais);
        return is.readObject();
    }
}

