/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.ClosureUtils;
import org.apache.commons.collections4.FunctorException;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;
import org.apache.commons.collections4.TestUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.functors.EqualPredicate;
import org.apache.commons.collections4.functors.ExceptionClosure;
import org.apache.commons.collections4.functors.FalsePredicate;
import org.apache.commons.collections4.functors.NOPClosure;
import org.apache.commons.collections4.functors.TruePredicate;
import org.junit.Assert;
import org.junit.Test;

public class ClosureUtilsTest {
    private static final Object cString = "Hello";

    @Test
    public void testExceptionClosure() {
        Assert.assertNotNull((Object)ClosureUtils.exceptionClosure());
        Assert.assertSame((Object)ClosureUtils.exceptionClosure(), (Object)ClosureUtils.exceptionClosure());
        try {
            ClosureUtils.exceptionClosure().execute(null);
        }
        catch (FunctorException ex) {
            try {
                ClosureUtils.exceptionClosure().execute(cString);
            }
            catch (FunctorException ex2) {
                return;
            }
        }
        Assert.fail();
    }

    @Test
    public void testNopClosure() {
        StringBuilder buf = new StringBuilder("Hello");
        ClosureUtils.nopClosure().execute(null);
        Assert.assertEquals((Object)"Hello", (Object)buf.toString());
        ClosureUtils.nopClosure().execute((Object)"Hello");
        Assert.assertEquals((Object)"Hello", (Object)buf.toString());
    }

    @Test
    public void testInvokeClosure() {
        StringBuffer buf = new StringBuffer("Hello");
        ClosureUtils.invokerClosure((String)"reverse").execute((Object)buf);
        Assert.assertEquals((Object)"olleH", (Object)buf.toString());
        buf = new StringBuffer("Hello");
        ClosureUtils.invokerClosure((String)"setLength", (Class[])new Class[]{Integer.TYPE}, (Object[])new Object[]{2}).execute((Object)buf);
        Assert.assertEquals((Object)"He", (Object)buf.toString());
    }

    @Test
    public void testForClosure() {
        MockClosure cmd = new MockClosure();
        ClosureUtils.forClosure((int)5, cmd).execute(null);
        Assert.assertEquals((long)5L, (long)cmd.count);
        Assert.assertSame((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.forClosure((int)0, new MockClosure()));
        Assert.assertSame((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.forClosure((int)-1, new MockClosure()));
        Assert.assertSame((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.forClosure((int)1, null));
        Assert.assertSame((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.forClosure((int)3, null));
        Assert.assertSame(cmd, (Object)ClosureUtils.forClosure((int)1, cmd));
    }

    @Test
    public void testWhileClosure() {
        MockClosure cmd = new MockClosure();
        ClosureUtils.whileClosure((Predicate)FalsePredicate.falsePredicate(), cmd).execute(null);
        Assert.assertEquals((long)0L, (long)cmd.count);
        cmd = new MockClosure();
        ClosureUtils.whileClosure((Predicate)PredicateUtils.uniquePredicate(), cmd).execute(null);
        Assert.assertEquals((long)1L, (long)cmd.count);
        try {
            ClosureUtils.whileClosure(null, (Closure)ClosureUtils.nopClosure());
            Assert.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            ClosureUtils.whileClosure((Predicate)FalsePredicate.falsePredicate(), null);
            Assert.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            ClosureUtils.whileClosure(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testDoWhileClosure() {
        MockClosure cmd = new MockClosure();
        ClosureUtils.doWhileClosure(cmd, (Predicate)FalsePredicate.falsePredicate()).execute(null);
        Assert.assertEquals((long)1L, (long)cmd.count);
        cmd = new MockClosure();
        ClosureUtils.doWhileClosure(cmd, (Predicate)PredicateUtils.uniquePredicate()).execute(null);
        Assert.assertEquals((long)2L, (long)cmd.count);
        try {
            ClosureUtils.doWhileClosure(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testChainedClosure() {
        MockClosure a = new MockClosure();
        MockClosure b = new MockClosure();
        ClosureUtils.chainedClosure((Closure[])new Closure[]{a, b}).execute(null);
        Assert.assertEquals((long)1L, (long)a.count);
        Assert.assertEquals((long)1L, (long)b.count);
        a = new MockClosure();
        b = new MockClosure();
        ClosureUtils.chainedClosure((Closure[])new Closure[]{a, b, a}).execute(null);
        Assert.assertEquals((long)2L, (long)a.count);
        Assert.assertEquals((long)1L, (long)b.count);
        a = new MockClosure();
        b = new MockClosure();
        ArrayList coll = new ArrayList();
        coll.add(b);
        coll.add(a);
        coll.add(b);
        ClosureUtils.chainedClosure(coll).execute(null);
        Assert.assertEquals((long)1L, (long)a.count);
        Assert.assertEquals((long)2L, (long)b.count);
        Assert.assertSame((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.chainedClosure((Closure[])new Closure[0]));
        Assert.assertSame((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.chainedClosure(Collections.emptyList()));
        try {
            ClosureUtils.chainedClosure((Closure[])new Closure[]{null, null});
            Assert.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            ClosureUtils.chainedClosure((Closure[])null);
            Assert.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            ClosureUtils.chainedClosure((Collection)null);
            Assert.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            ClosureUtils.chainedClosure((Closure[])new Closure[]{null, null});
            Assert.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            coll = new ArrayList();
            coll.add(null);
            coll.add(null);
            ClosureUtils.chainedClosure(coll);
            Assert.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
    }

    @Test
    public void testIfClosure() {
        MockClosure a = new MockClosure();
        MockClosure b = null;
        ClosureUtils.ifClosure((Predicate)TruePredicate.truePredicate(), a).execute(null);
        Assert.assertEquals((long)1L, (long)a.count);
        a = new MockClosure();
        ClosureUtils.ifClosure((Predicate)FalsePredicate.falsePredicate(), a).execute(null);
        Assert.assertEquals((long)0L, (long)a.count);
        a = new MockClosure();
        b = new MockClosure();
        ClosureUtils.ifClosure((Predicate)TruePredicate.truePredicate(), a, b).execute(null);
        Assert.assertEquals((long)1L, (long)a.count);
        Assert.assertEquals((long)0L, (long)b.count);
        a = new MockClosure();
        b = new MockClosure();
        ClosureUtils.ifClosure((Predicate)FalsePredicate.falsePredicate(), a, b).execute(null);
        Assert.assertEquals((long)0L, (long)a.count);
        Assert.assertEquals((long)1L, (long)b.count);
    }

    @Test
    public void testSwitchClosure() {
        MockClosure a = new MockClosure();
        MockClosure b = new MockClosure();
        ClosureUtils.switchClosure((Predicate[])new Predicate[]{EqualPredicate.equalPredicate((Object)"HELLO"), EqualPredicate.equalPredicate((Object)"THERE")}, (Closure[])new Closure[]{a, b}).execute((Object)"WELL");
        Assert.assertEquals((long)0L, (long)a.count);
        Assert.assertEquals((long)0L, (long)b.count);
        a.reset();
        b.reset();
        ClosureUtils.switchClosure((Predicate[])new Predicate[]{EqualPredicate.equalPredicate((Object)"HELLO"), EqualPredicate.equalPredicate((Object)"THERE")}, (Closure[])new Closure[]{a, b}).execute((Object)"HELLO");
        Assert.assertEquals((long)1L, (long)a.count);
        Assert.assertEquals((long)0L, (long)b.count);
        a.reset();
        b.reset();
        MockClosure c = new MockClosure();
        ClosureUtils.switchClosure((Predicate[])new Predicate[]{EqualPredicate.equalPredicate((Object)"HELLO"), EqualPredicate.equalPredicate((Object)"THERE")}, (Closure[])new Closure[]{a, b}, c).execute((Object)"WELL");
        Assert.assertEquals((long)0L, (long)a.count);
        Assert.assertEquals((long)0L, (long)b.count);
        Assert.assertEquals((long)1L, (long)c.count);
        a.reset();
        b.reset();
        HashMap map = new HashMap();
        map.put(EqualPredicate.equalPredicate((Object)"HELLO"), a);
        map.put(EqualPredicate.equalPredicate((Object)"THERE"), b);
        ClosureUtils.switchClosure(map).execute(null);
        Assert.assertEquals((long)0L, (long)a.count);
        Assert.assertEquals((long)0L, (long)b.count);
        a.reset();
        b.reset();
        map.clear();
        map.put(EqualPredicate.equalPredicate((Object)"HELLO"), a);
        map.put(EqualPredicate.equalPredicate((Object)"THERE"), b);
        ClosureUtils.switchClosure(map).execute((Object)"THERE");
        Assert.assertEquals((long)0L, (long)a.count);
        Assert.assertEquals((long)1L, (long)b.count);
        a.reset();
        b.reset();
        c.reset();
        map.clear();
        map.put(EqualPredicate.equalPredicate((Object)"HELLO"), a);
        map.put(EqualPredicate.equalPredicate((Object)"THERE"), b);
        map.put(null, c);
        ClosureUtils.switchClosure(map).execute((Object)"WELL");
        Assert.assertEquals((long)0L, (long)a.count);
        Assert.assertEquals((long)0L, (long)b.count);
        Assert.assertEquals((long)1L, (long)c.count);
        Assert.assertEquals((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.switchClosure((Predicate[])new Predicate[0], (Closure[])new Closure[0]));
        Assert.assertEquals((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.switchClosure(new HashMap()));
        map.clear();
        map.put(null, null);
        Assert.assertEquals((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.switchClosure(map));
        try {
            ClosureUtils.switchClosure(null, null);
            Assert.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            ClosureUtils.switchClosure((Predicate[])null, (Closure[])null);
            Assert.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            ClosureUtils.switchClosure((Map)null);
            Assert.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            ClosureUtils.switchClosure((Predicate[])new Predicate[2], (Closure[])new Closure[2]);
            Assert.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            ClosureUtils.switchClosure((Predicate[])new Predicate[]{TruePredicate.truePredicate()}, (Closure[])new Closure[]{a, b});
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    @Test
    public void testSwitchMapClosure() {
        MockClosure a = new MockClosure();
        MockClosure b = new MockClosure();
        HashMap map = new HashMap();
        map.put("HELLO", a);
        map.put("THERE", b);
        ClosureUtils.switchMapClosure(map).execute(null);
        Assert.assertEquals((long)0L, (long)a.count);
        Assert.assertEquals((long)0L, (long)b.count);
        a.reset();
        b.reset();
        map.clear();
        map.put("HELLO", a);
        map.put("THERE", b);
        ClosureUtils.switchMapClosure(map).execute((Object)"THERE");
        Assert.assertEquals((long)0L, (long)a.count);
        Assert.assertEquals((long)1L, (long)b.count);
        a.reset();
        b.reset();
        map.clear();
        MockClosure c = new MockClosure();
        map.put("HELLO", a);
        map.put("THERE", b);
        map.put(null, c);
        ClosureUtils.switchMapClosure(map).execute((Object)"WELL");
        Assert.assertEquals((long)0L, (long)a.count);
        Assert.assertEquals((long)0L, (long)b.count);
        Assert.assertEquals((long)1L, (long)c.count);
        Assert.assertEquals((Object)NOPClosure.INSTANCE, (Object)ClosureUtils.switchMapClosure(new HashMap()));
        try {
            ClosureUtils.switchMapClosure(null);
            Assert.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
    }

    @Test
    public void testTransformerClosure() {
        MockTransformer mock = new MockTransformer();
        Closure closure = ClosureUtils.asClosure(mock);
        closure.execute(null);
        Assert.assertEquals((long)1L, (long)mock.count);
        closure.execute(null);
        Assert.assertEquals((long)2L, (long)mock.count);
        Assert.assertEquals((Object)ClosureUtils.nopClosure(), (Object)ClosureUtils.asClosure(null));
    }

    @Test
    public void testSingletonPatternInSerialization() {
        Object[] singletones;
        for (Object original : singletones = new Object[]{ExceptionClosure.INSTANCE, NOPClosure.INSTANCE}) {
            TestUtils.assertSameAfterSerialization("Singletone patern broken for " + original.getClass(), original);
        }
    }

    static class MockTransformer<T>
    implements Transformer<T, T> {
        int count = 0;

        MockTransformer() {
        }

        public T transform(T object) {
            ++this.count;
            return object;
        }
    }

    static class MockClosure<T>
    implements Closure<T> {
        int count = 0;

        MockClosure() {
        }

        public void execute(T object) {
            ++this.count;
        }

        public void reset() {
            this.count = 0;
        }
    }
}

