/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.ClosureUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.collections4.Equator;
import org.apache.commons.collections4.FunctorException;
import org.apache.commons.collections4.MockTestCase;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.collection.PredicatedCollection;
import org.apache.commons.collections4.collection.SynchronizedCollection;
import org.apache.commons.collections4.collection.TransformedCollection;
import org.apache.commons.collections4.collection.UnmodifiableCollection;
import org.apache.commons.collections4.functors.DefaultEquator;
import org.apache.commons.collections4.functors.EqualPredicate;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CollectionUtilsTest
extends MockTestCase {
    private List<Integer> collectionA = null;
    private List<Long> collectionB = null;
    private Collection<Integer> collectionC = null;
    private Collection<Integer> collectionD = null;
    private Collection<Integer> collectionE = null;
    private Collection<Number> collectionA2 = null;
    private Collection<Number> collectionB2 = null;
    private Collection<Number> collectionC2 = null;
    private Iterable<Integer> iterableA = null;
    private Iterable<Long> iterableB = null;
    private Iterable<Integer> iterableC = null;
    private Iterable<Number> iterableA2 = null;
    private Iterable<Number> iterableB2 = null;
    private final Collection<Integer> emptyCollection = new ArrayList<Integer>(1);
    private static Predicate<Number> EQUALS_TWO = new Predicate<Number>(){

        public boolean evaluate(Number input) {
            return input.intValue() == 2;
        }
    };
    Transformer<Object, Integer> TRANSFORM_TO_INTEGER = new Transformer<Object, Integer>(){

        public Integer transform(Object input) {
            return ((Long)input).intValue();
        }
    };

    @Before
    public void setUp() {
        this.collectionA = new ArrayList<Integer>();
        this.collectionA.add(1);
        this.collectionA.add(2);
        this.collectionA.add(2);
        this.collectionA.add(3);
        this.collectionA.add(3);
        this.collectionA.add(3);
        this.collectionA.add(4);
        this.collectionA.add(4);
        this.collectionA.add(4);
        this.collectionA.add(4);
        this.collectionB = new LinkedList<Long>();
        this.collectionB.add(5L);
        this.collectionB.add(4L);
        this.collectionB.add(4L);
        this.collectionB.add(3L);
        this.collectionB.add(3L);
        this.collectionB.add(3L);
        this.collectionB.add(2L);
        this.collectionB.add(2L);
        this.collectionB.add(2L);
        this.collectionB.add(2L);
        this.collectionC = new ArrayList<Integer>();
        for (Long l : this.collectionB) {
            this.collectionC.add(l.intValue());
        }
        this.iterableA = this.collectionA;
        this.iterableB = this.collectionB;
        this.iterableC = this.collectionC;
        this.collectionA2 = new ArrayList<Integer>(this.collectionA);
        this.collectionB2 = new LinkedList<Long>(this.collectionB);
        this.collectionC2 = new LinkedList<Integer>(this.collectionC);
        this.iterableA2 = this.collectionA2;
        this.iterableB2 = this.collectionB2;
        this.collectionD = new ArrayList<Integer>();
        this.collectionD.add(1);
        this.collectionD.add(3);
        this.collectionD.add(3);
        this.collectionD.add(3);
        this.collectionD.add(5);
        this.collectionD.add(7);
        this.collectionD.add(7);
        this.collectionD.add(10);
        this.collectionE = new ArrayList<Integer>();
        this.collectionE.add(2);
        this.collectionE.add(4);
        this.collectionE.add(4);
        this.collectionE.add(5);
        this.collectionE.add(6);
        this.collectionE.add(6);
        this.collectionE.add(9);
    }

    @Test
    public void getCardinalityMap() {
        Map freqA = CollectionUtils.getCardinalityMap(this.iterableA);
        Assert.assertEquals((long)1L, (long)((Integer)freqA.get(1)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)freqA.get(2)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)freqA.get(3)).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)freqA.get(4)).intValue());
        Assert.assertNull(freqA.get(5));
        Map freqB = CollectionUtils.getCardinalityMap(this.iterableB);
        Assert.assertNull(freqB.get(1L));
        Assert.assertEquals((long)4L, (long)((Integer)freqB.get(2L)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)freqB.get(3L)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)freqB.get(4L)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)freqB.get(5L)).intValue());
    }

    @Test
    @Deprecated
    public void cardinality() {
        Assert.assertEquals((long)1L, (long)CollectionUtils.cardinality((Object)1, this.iterableA));
        Assert.assertEquals((long)2L, (long)CollectionUtils.cardinality((Object)2, this.iterableA));
        Assert.assertEquals((long)3L, (long)CollectionUtils.cardinality((Object)3, this.iterableA));
        Assert.assertEquals((long)4L, (long)CollectionUtils.cardinality((Object)4, this.iterableA));
        Assert.assertEquals((long)0L, (long)CollectionUtils.cardinality((Object)5, this.iterableA));
        Assert.assertEquals((long)0L, (long)CollectionUtils.cardinality((Object)1L, this.iterableB));
        Assert.assertEquals((long)4L, (long)CollectionUtils.cardinality((Object)2L, this.iterableB));
        Assert.assertEquals((long)3L, (long)CollectionUtils.cardinality((Object)3L, this.iterableB));
        Assert.assertEquals((long)2L, (long)CollectionUtils.cardinality((Object)4L, this.iterableB));
        Assert.assertEquals((long)1L, (long)CollectionUtils.cardinality((Object)5L, this.iterableB));
        Assert.assertEquals((long)0L, (long)CollectionUtils.cardinality((Object)2L, this.iterableA2));
        Assert.assertEquals((long)0L, (long)CollectionUtils.cardinality((Object)2, this.iterableB2));
        HashSet<String> set = new HashSet<String>();
        set.add("A");
        set.add("C");
        set.add("E");
        set.add("E");
        Assert.assertEquals((long)1L, (long)CollectionUtils.cardinality((Object)"A", set));
        Assert.assertEquals((long)0L, (long)CollectionUtils.cardinality((Object)"B", set));
        Assert.assertEquals((long)1L, (long)CollectionUtils.cardinality((Object)"C", set));
        Assert.assertEquals((long)0L, (long)CollectionUtils.cardinality((Object)"D", set));
        Assert.assertEquals((long)1L, (long)CollectionUtils.cardinality((Object)"E", set));
        HashBag bag = new HashBag();
        bag.add((Object)"A", 3);
        bag.add((Object)"C");
        bag.add((Object)"E");
        bag.add((Object)"E");
        Assert.assertEquals((long)3L, (long)CollectionUtils.cardinality((Object)"A", (Iterable)bag));
        Assert.assertEquals((long)0L, (long)CollectionUtils.cardinality((Object)"B", (Iterable)bag));
        Assert.assertEquals((long)1L, (long)CollectionUtils.cardinality((Object)"C", (Iterable)bag));
        Assert.assertEquals((long)0L, (long)CollectionUtils.cardinality((Object)"D", (Iterable)bag));
        Assert.assertEquals((long)2L, (long)CollectionUtils.cardinality((Object)"E", (Iterable)bag));
    }

    @Test
    @Deprecated
    public void cardinalityOfNull() {
        ArrayList<String> list = new ArrayList<String>();
        Assert.assertEquals((long)0L, (long)CollectionUtils.cardinality(null, list));
        Map freq = CollectionUtils.getCardinalityMap(list);
        Assert.assertNull(freq.get(null));
        list.add("A");
        Assert.assertEquals((long)0L, (long)CollectionUtils.cardinality(null, list));
        freq = CollectionUtils.getCardinalityMap(list);
        Assert.assertNull(freq.get(null));
        list.add(null);
        Assert.assertEquals((long)1L, (long)CollectionUtils.cardinality(null, list));
        freq = CollectionUtils.getCardinalityMap(list);
        Assert.assertEquals((Object)1, freq.get(null));
        list.add("B");
        Assert.assertEquals((long)1L, (long)CollectionUtils.cardinality(null, list));
        freq = CollectionUtils.getCardinalityMap(list);
        Assert.assertEquals((Object)1, freq.get(null));
        list.add(null);
        Assert.assertEquals((long)2L, (long)CollectionUtils.cardinality(null, list));
        freq = CollectionUtils.getCardinalityMap(list);
        Assert.assertEquals((Object)2, freq.get(null));
        list.add("B");
        Assert.assertEquals((long)2L, (long)CollectionUtils.cardinality(null, list));
        freq = CollectionUtils.getCardinalityMap(list);
        Assert.assertEquals((Object)2, freq.get(null));
        list.add(null);
        Assert.assertEquals((long)3L, (long)CollectionUtils.cardinality(null, list));
        freq = CollectionUtils.getCardinalityMap(list);
        Assert.assertEquals((Object)3, freq.get(null));
    }

    @Test
    public void containsAll() {
        ArrayList empty = new ArrayList(0);
        ArrayList<String> one = new ArrayList<String>(1);
        one.add("1");
        ArrayList<String> two = new ArrayList<String>(1);
        two.add("2");
        ArrayList<String> three = new ArrayList<String>(1);
        three.add("3");
        ArrayList<String> odds = new ArrayList<String>(2);
        odds.add("1");
        odds.add("3");
        ArrayList<String> multiples = new ArrayList<String>(3);
        multiples.add("1");
        multiples.add("3");
        multiples.add("1");
        Assert.assertTrue((String)"containsAll({1},{1,3}) should return false.", (!CollectionUtils.containsAll(one, odds) ? 1 : 0) != 0);
        Assert.assertTrue((String)"containsAll({1,3},{1}) should return true.", (boolean)CollectionUtils.containsAll(odds, one));
        Assert.assertTrue((String)"containsAll({3},{1,3}) should return false.", (!CollectionUtils.containsAll(three, odds) ? 1 : 0) != 0);
        Assert.assertTrue((String)"containsAll({1,3},{3}) should return true.", (boolean)CollectionUtils.containsAll(odds, three));
        Assert.assertTrue((String)"containsAll({2},{2}) should return true.", (boolean)CollectionUtils.containsAll(two, two));
        Assert.assertTrue((String)"containsAll({1,3},{1,3}) should return true.", (boolean)CollectionUtils.containsAll(odds, odds));
        Assert.assertTrue((String)"containsAll({2},{1,3}) should return false.", (!CollectionUtils.containsAll(two, odds) ? 1 : 0) != 0);
        Assert.assertTrue((String)"containsAll({1,3},{2}) should return false.", (!CollectionUtils.containsAll(odds, two) ? 1 : 0) != 0);
        Assert.assertTrue((String)"containsAll({1},{3}) should return false.", (!CollectionUtils.containsAll(one, three) ? 1 : 0) != 0);
        Assert.assertTrue((String)"containsAll({3},{1}) should return false.", (!CollectionUtils.containsAll(three, one) ? 1 : 0) != 0);
        Assert.assertTrue((String)"containsAll({1,3},{}) should return true.", (boolean)CollectionUtils.containsAll(odds, empty));
        Assert.assertTrue((String)"containsAll({},{1,3}) should return false.", (!CollectionUtils.containsAll(empty, odds) ? 1 : 0) != 0);
        Assert.assertTrue((String)"containsAll({},{}) should return true.", (boolean)CollectionUtils.containsAll(empty, empty));
        Assert.assertTrue((String)"containsAll({1,3},{1,3,1}) should return true.", (boolean)CollectionUtils.containsAll(odds, multiples));
        Assert.assertTrue((String)"containsAll({1,3,1},{1,3,1}) should return true.", (boolean)CollectionUtils.containsAll(odds, odds));
    }

    @Test
    public void containsAny() {
        ArrayList empty = new ArrayList(0);
        ArrayList<String> one = new ArrayList<String>(1);
        one.add("1");
        ArrayList<String> two = new ArrayList<String>(1);
        two.add("2");
        ArrayList<String> three = new ArrayList<String>(1);
        three.add("3");
        ArrayList<String> odds = new ArrayList<String>(2);
        odds.add("1");
        odds.add("3");
        Assert.assertTrue((String)"containsAny({1},{1,3}) should return true.", (boolean)CollectionUtils.containsAny(one, odds));
        Assert.assertTrue((String)"containsAny({1,3},{1}) should return true.", (boolean)CollectionUtils.containsAny(odds, one));
        Assert.assertTrue((String)"containsAny({3},{1,3}) should return true.", (boolean)CollectionUtils.containsAny(three, odds));
        Assert.assertTrue((String)"containsAny({1,3},{3}) should return true.", (boolean)CollectionUtils.containsAny(odds, three));
        Assert.assertTrue((String)"containsAny({2},{2}) should return true.", (boolean)CollectionUtils.containsAny(two, two));
        Assert.assertTrue((String)"containsAny({1,3},{1,3}) should return true.", (boolean)CollectionUtils.containsAny(odds, odds));
        Assert.assertTrue((String)"containsAny({2},{1,3}) should return false.", (!CollectionUtils.containsAny(two, odds) ? 1 : 0) != 0);
        Assert.assertTrue((String)"containsAny({1,3},{2}) should return false.", (!CollectionUtils.containsAny(odds, two) ? 1 : 0) != 0);
        Assert.assertTrue((String)"containsAny({1},{3}) should return false.", (!CollectionUtils.containsAny(one, three) ? 1 : 0) != 0);
        Assert.assertTrue((String)"containsAny({3},{1}) should return false.", (!CollectionUtils.containsAny(three, one) ? 1 : 0) != 0);
        Assert.assertTrue((String)"containsAny({1,3},{}) should return false.", (!CollectionUtils.containsAny(odds, empty) ? 1 : 0) != 0);
        Assert.assertTrue((String)"containsAny({},{1,3}) should return false.", (!CollectionUtils.containsAny(empty, odds) ? 1 : 0) != 0);
        Assert.assertTrue((String)"containsAny({},{}) should return false.", (!CollectionUtils.containsAny(empty, empty) ? 1 : 0) != 0);
    }

    @Test
    public void union() {
        Collection col = CollectionUtils.union(this.iterableA, this.iterableC);
        Map freq = CollectionUtils.getCardinalityMap((Iterable)col);
        Assert.assertEquals((Object)1, freq.get(1));
        Assert.assertEquals((Object)4, freq.get(2));
        Assert.assertEquals((Object)3, freq.get(3));
        Assert.assertEquals((Object)4, freq.get(4));
        Assert.assertEquals((Object)1, freq.get(5));
        Collection col2 = CollectionUtils.union(this.collectionC2, this.iterableA);
        Map freq2 = CollectionUtils.getCardinalityMap((Iterable)col2);
        Assert.assertEquals((Object)1, freq2.get(1));
        Assert.assertEquals((Object)4, freq2.get(2));
        Assert.assertEquals((Object)3, freq2.get(3));
        Assert.assertEquals((Object)4, freq2.get(4));
        Assert.assertEquals((Object)1, freq2.get(5));
    }

    @Test
    public void intersection() {
        Collection col = CollectionUtils.intersection(this.iterableA, this.iterableC);
        Map freq = CollectionUtils.getCardinalityMap((Iterable)col);
        Assert.assertNull(freq.get(1));
        Assert.assertEquals((Object)2, freq.get(2));
        Assert.assertEquals((Object)3, freq.get(3));
        Assert.assertEquals((Object)2, freq.get(4));
        Assert.assertNull(freq.get(5));
        Collection col2 = CollectionUtils.intersection(this.collectionC2, this.collectionA);
        Map freq2 = CollectionUtils.getCardinalityMap((Iterable)col2);
        Assert.assertNull(freq2.get(1));
        Assert.assertEquals((Object)2, freq2.get(2));
        Assert.assertEquals((Object)3, freq2.get(3));
        Assert.assertEquals((Object)2, freq2.get(4));
        Assert.assertNull(freq2.get(5));
    }

    @Test
    public void disjunction() {
        Collection col = CollectionUtils.disjunction(this.iterableA, this.iterableC);
        Map freq = CollectionUtils.getCardinalityMap((Iterable)col);
        Assert.assertEquals((Object)1, freq.get(1));
        Assert.assertEquals((Object)2, freq.get(2));
        Assert.assertNull(freq.get(3));
        Assert.assertEquals((Object)2, freq.get(4));
        Assert.assertEquals((Object)1, freq.get(5));
        Collection col2 = CollectionUtils.disjunction(this.collectionC2, this.collectionA);
        Map freq2 = CollectionUtils.getCardinalityMap((Iterable)col2);
        Assert.assertEquals((Object)1, freq2.get(1));
        Assert.assertEquals((Object)2, freq2.get(2));
        Assert.assertNull(freq2.get(3));
        Assert.assertEquals((Object)2, freq2.get(4));
        Assert.assertEquals((Object)1, freq2.get(5));
    }

    @Test
    public void testDisjunctionAsUnionMinusIntersection() {
        Collection dis = CollectionUtils.disjunction(this.collectionA, this.collectionC);
        Collection un = CollectionUtils.union(this.collectionA, this.collectionC);
        Collection inter = CollectionUtils.intersection(this.collectionA, this.collectionC);
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)dis, (Collection)CollectionUtils.subtract((Iterable)un, (Iterable)inter)));
    }

    @Test
    public void testDisjunctionAsSymmetricDifference() {
        Collection dis = CollectionUtils.disjunction(this.collectionA, this.collectionC);
        Collection amb = CollectionUtils.subtract(this.collectionA, this.collectionC);
        Collection bma = CollectionUtils.subtract(this.collectionC, this.collectionA);
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)dis, (Collection)CollectionUtils.union((Iterable)amb, (Iterable)bma)));
    }

    @Test
    public void testSubtract() {
        Collection col = CollectionUtils.subtract(this.iterableA, this.iterableC);
        Map freq = CollectionUtils.getCardinalityMap((Iterable)col);
        Assert.assertEquals((Object)1, freq.get(1));
        Assert.assertNull(freq.get(2));
        Assert.assertNull(freq.get(3));
        Assert.assertEquals((Object)2, freq.get(4));
        Assert.assertNull(freq.get(5));
        Collection col2 = CollectionUtils.subtract(this.collectionC2, this.collectionA);
        Map freq2 = CollectionUtils.getCardinalityMap((Iterable)col2);
        Assert.assertEquals((Object)1, freq2.get(5));
        Assert.assertNull(freq2.get(4));
        Assert.assertNull(freq2.get(3));
        Assert.assertEquals((Object)2, freq2.get(2));
        Assert.assertNull(freq2.get(1));
    }

    @Test
    public void testSubtractWithPredicate() {
        Predicate<Number> predicate = new Predicate<Number>(){

            public boolean evaluate(Number n) {
                return n.longValue() > 3L;
            }
        };
        Collection col = CollectionUtils.subtract(this.iterableA, this.collectionC, (Predicate)predicate);
        Map freq2 = CollectionUtils.getCardinalityMap((Iterable)col);
        Assert.assertEquals((Object)1, freq2.get(1));
        Assert.assertEquals((Object)2, freq2.get(2));
        Assert.assertEquals((Object)3, freq2.get(3));
        Assert.assertEquals((Object)2, freq2.get(4));
        Assert.assertNull(freq2.get(5));
    }

    @Test
    public void testIsSubCollectionOfSelf() {
        Assert.assertTrue((boolean)CollectionUtils.isSubCollection(this.collectionA, this.collectionA));
        Assert.assertTrue((boolean)CollectionUtils.isSubCollection(this.collectionB, this.collectionB));
    }

    @Test
    public void testIsSubCollection() {
        Assert.assertTrue((!CollectionUtils.isSubCollection(this.collectionA, this.collectionC) ? 1 : 0) != 0);
        Assert.assertTrue((!CollectionUtils.isSubCollection(this.collectionC, this.collectionA) ? 1 : 0) != 0);
    }

    @Test
    public void testIsSubCollection2() {
        ArrayList<Integer> c = new ArrayList<Integer>();
        Assert.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assert.assertTrue((!CollectionUtils.isSubCollection(this.collectionA, c) ? 1 : 0) != 0);
        c.add(1);
        Assert.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assert.assertTrue((!CollectionUtils.isSubCollection(this.collectionA, c) ? 1 : 0) != 0);
        c.add(2);
        Assert.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assert.assertTrue((!CollectionUtils.isSubCollection(this.collectionA, c) ? 1 : 0) != 0);
        c.add(2);
        Assert.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assert.assertTrue((!CollectionUtils.isSubCollection(this.collectionA, c) ? 1 : 0) != 0);
        c.add(3);
        Assert.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assert.assertTrue((!CollectionUtils.isSubCollection(this.collectionA, c) ? 1 : 0) != 0);
        c.add(3);
        Assert.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assert.assertTrue((!CollectionUtils.isSubCollection(this.collectionA, c) ? 1 : 0) != 0);
        c.add(3);
        Assert.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assert.assertTrue((!CollectionUtils.isSubCollection(this.collectionA, c) ? 1 : 0) != 0);
        c.add(4);
        Assert.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assert.assertTrue((!CollectionUtils.isSubCollection(this.collectionA, c) ? 1 : 0) != 0);
        c.add(4);
        Assert.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assert.assertTrue((!CollectionUtils.isSubCollection(this.collectionA, c) ? 1 : 0) != 0);
        c.add(4);
        Assert.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assert.assertTrue((!CollectionUtils.isSubCollection(this.collectionA, c) ? 1 : 0) != 0);
        c.add(4);
        Assert.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assert.assertTrue((boolean)CollectionUtils.isSubCollection(this.collectionA, c));
        c.add(5);
        Assert.assertTrue((!CollectionUtils.isSubCollection(c, this.collectionA) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)CollectionUtils.isSubCollection(this.collectionA, c));
    }

    @Test
    public void testIsEqualCollectionToSelf() {
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(this.collectionA, this.collectionA));
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(this.collectionB, this.collectionB));
    }

    @Test
    public void testIsEqualCollection() {
        Assert.assertTrue((!CollectionUtils.isEqualCollection(this.collectionA, this.collectionC) ? 1 : 0) != 0);
        Assert.assertTrue((!CollectionUtils.isEqualCollection(this.collectionC, this.collectionA) ? 1 : 0) != 0);
    }

    @Test
    public void testIsEqualCollectionReturnsFalse() {
        ArrayList<Integer> b = new ArrayList<Integer>(this.collectionA);
        b.remove(1);
        b.add(5);
        Assert.assertFalse((boolean)CollectionUtils.isEqualCollection(this.collectionA, b));
        Assert.assertFalse((boolean)CollectionUtils.isEqualCollection(b, this.collectionA));
    }

    @Test
    public void testIsEqualCollection2() {
        ArrayList<String> a = new ArrayList<String>();
        ArrayList<String> b = new ArrayList<String>();
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(a, b));
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(b, a));
        a.add("1");
        Assert.assertTrue((!CollectionUtils.isEqualCollection(a, b) ? 1 : 0) != 0);
        Assert.assertTrue((!CollectionUtils.isEqualCollection(b, a) ? 1 : 0) != 0);
        b.add("1");
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(a, b));
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(b, a));
        a.add("2");
        Assert.assertTrue((!CollectionUtils.isEqualCollection(a, b) ? 1 : 0) != 0);
        Assert.assertTrue((!CollectionUtils.isEqualCollection(b, a) ? 1 : 0) != 0);
        b.add("2");
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(a, b));
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(b, a));
        a.add("1");
        Assert.assertTrue((!CollectionUtils.isEqualCollection(a, b) ? 1 : 0) != 0);
        Assert.assertTrue((!CollectionUtils.isEqualCollection(b, a) ? 1 : 0) != 0);
        b.add("1");
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(a, b));
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(b, a));
    }

    @Test
    public void testIsEqualCollectionEquator() {
        Collection collB = CollectionUtils.collect(this.collectionB, this.TRANSFORM_TO_INTEGER);
        Equator<Integer> e = new Equator<Integer>(){

            public boolean equate(Integer o1, Integer o2) {
                return !(o1 % 2 == 0 ^ o2 % 2 == 0);
            }

            public int hash(Integer o) {
                return o % 2 == 0 ? Integer.valueOf(0).hashCode() : Integer.valueOf(1).hashCode();
            }
        };
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(this.collectionA, this.collectionA, (Equator)e));
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(this.collectionA, (Collection)collB, (Equator)e));
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)collB, this.collectionA, (Equator)e));
        DefaultEquator defaultEquator = DefaultEquator.defaultEquator();
        Assert.assertFalse((boolean)CollectionUtils.isEqualCollection(this.collectionA, this.collectionB, (Equator)defaultEquator));
        Assert.assertFalse((boolean)CollectionUtils.isEqualCollection(this.collectionA, (Collection)collB, (Equator)defaultEquator));
    }

    @Test(expected=NullPointerException.class)
    public void testIsEqualCollectionNullEquator() {
        CollectionUtils.isEqualCollection(this.collectionA, this.collectionA, null);
    }

    @Test
    public void testIsProperSubCollection() {
        ArrayList<String> a = new ArrayList<String>();
        ArrayList<String> b = new ArrayList<String>();
        Assert.assertTrue((!CollectionUtils.isProperSubCollection(a, b) ? 1 : 0) != 0);
        b.add("1");
        Assert.assertTrue((boolean)CollectionUtils.isProperSubCollection(a, b));
        Assert.assertTrue((!CollectionUtils.isProperSubCollection(b, a) ? 1 : 0) != 0);
        Assert.assertTrue((!CollectionUtils.isProperSubCollection(b, b) ? 1 : 0) != 0);
        Assert.assertTrue((!CollectionUtils.isProperSubCollection(a, a) ? 1 : 0) != 0);
        a.add("1");
        a.add("2");
        b.add("2");
        Assert.assertTrue((!CollectionUtils.isProperSubCollection(b, a) ? 1 : 0) != 0);
        Assert.assertTrue((!CollectionUtils.isProperSubCollection(a, b) ? 1 : 0) != 0);
        a.add("1");
        Assert.assertTrue((boolean)CollectionUtils.isProperSubCollection(b, a));
        Assert.assertTrue((boolean)CollectionUtils.isProperSubCollection((Collection)CollectionUtils.intersection(this.collectionA, this.collectionC), this.collectionA));
        Assert.assertTrue((boolean)CollectionUtils.isProperSubCollection((Collection)CollectionUtils.subtract(a, b), a));
        Assert.assertTrue((!CollectionUtils.isProperSubCollection(a, (Collection)CollectionUtils.subtract(a, b)) ? 1 : 0) != 0);
    }

    @Test
    @Deprecated
    public void find() {
        Predicate testPredicate = EqualPredicate.equalPredicate((Object)4);
        Integer test = (Integer)CollectionUtils.find(this.collectionA, (Predicate)testPredicate);
        Assert.assertTrue((boolean)test.equals(4));
        testPredicate = EqualPredicate.equalPredicate((Object)45);
        test = (Integer)CollectionUtils.find(this.collectionA, (Predicate)testPredicate);
        Assert.assertTrue((test == null ? 1 : 0) != 0);
        Assert.assertNull((Object)CollectionUtils.find(null, (Predicate)testPredicate));
        Assert.assertNull((Object)CollectionUtils.find(this.collectionA, null));
    }

    @Test
    @Deprecated
    public void forAllDoCollection() {
        Closure testClosure = ClosureUtils.invokerClosure((String)"clear");
        ArrayList<Collection<Integer>> col = new ArrayList<Collection<Integer>>();
        col.add(this.collectionA);
        col.add(this.collectionC);
        Closure resultClosure = CollectionUtils.forAllDo(col, (Closure)testClosure);
        Assert.assertSame((Object)testClosure, (Object)resultClosure);
        Assert.assertTrue((this.collectionA.isEmpty() && this.collectionC.isEmpty() ? 1 : 0) != 0);
        resultClosure = CollectionUtils.forAllDo(col, (Closure)null);
        Assert.assertNull((Object)resultClosure);
        Assert.assertTrue((this.collectionA.isEmpty() && this.collectionC.isEmpty() ? 1 : 0) != 0);
        resultClosure = CollectionUtils.forAllDo((Iterable)null, (Closure)testClosure);
        col.add(null);
        CollectionUtils.forAllDo(col, (Closure)testClosure);
    }

    @Test
    @Deprecated
    public void forAllDoIterator() {
        Closure testClosure = ClosureUtils.invokerClosure((String)"clear");
        ArrayList<Collection<Integer>> col = new ArrayList<Collection<Integer>>();
        col.add(this.collectionA);
        col.add(this.collectionC);
        Closure resultClosure = CollectionUtils.forAllDo(col.iterator(), (Closure)testClosure);
        Assert.assertSame((Object)testClosure, (Object)resultClosure);
        Assert.assertTrue((this.collectionA.isEmpty() && this.collectionC.isEmpty() ? 1 : 0) != 0);
        resultClosure = CollectionUtils.forAllDo(col.iterator(), (Closure)null);
        Assert.assertNull((Object)resultClosure);
        Assert.assertTrue((this.collectionA.isEmpty() && this.collectionC.isEmpty() ? 1 : 0) != 0);
        resultClosure = CollectionUtils.forAllDo((Iterator)null, (Closure)testClosure);
        col.add(null);
        CollectionUtils.forAllDo(col.iterator(), (Closure)testClosure);
    }

    @Test(expected=FunctorException.class)
    @Deprecated
    public void forAllDoFailure() {
        Closure testClosure = ClosureUtils.invokerClosure((String)"clear");
        ArrayList<String> col = new ArrayList<String>();
        col.add("x");
        CollectionUtils.forAllDo(col, (Closure)testClosure);
    }

    @Test
    @Deprecated
    public void forAllButLastDoCollection() {
        Closure testClosure = ClosureUtils.invokerClosure((String)"clear");
        ArrayList<List<Number>> col = new ArrayList<List<Number>>();
        col.add(this.collectionA);
        col.add(this.collectionB);
        List lastElement = (List)CollectionUtils.forAllButLastDo(col, (Closure)testClosure);
        Assert.assertSame((Object)lastElement, this.collectionB);
        Assert.assertTrue((this.collectionA.isEmpty() && !this.collectionB.isEmpty() ? 1 : 0) != 0);
        col.clear();
        col.add(this.collectionB);
        lastElement = (List)CollectionUtils.forAllButLastDo(col, (Closure)testClosure);
        Assert.assertSame((Object)lastElement, this.collectionB);
        Assert.assertTrue((!this.collectionB.isEmpty() ? 1 : 0) != 0);
        col.clear();
        lastElement = (List)CollectionUtils.forAllButLastDo(col, (Closure)testClosure);
        Assert.assertNull((Object)lastElement);
        List<String> strings = Arrays.asList("a", "b", "c");
        final StringBuffer result = new StringBuffer();
        result.append((String)CollectionUtils.forAllButLastDo(strings, (Closure)new Closure<String>(){

            public void execute(String input) {
                result.append(input + ";");
            }
        }));
        Assert.assertEquals((Object)"a;b;c", (Object)result.toString());
        List<String> oneString = Arrays.asList("a");
        final StringBuffer resultOne = new StringBuffer();
        resultOne.append((String)CollectionUtils.forAllButLastDo(oneString, (Closure)new Closure<String>(){

            public void execute(String input) {
                resultOne.append(input + ";");
            }
        }));
        Assert.assertEquals((Object)"a", (Object)resultOne.toString());
        Assert.assertNull((Object)CollectionUtils.forAllButLastDo(strings, (Closure)null));
        Assert.assertNull((Object)CollectionUtils.forAllButLastDo((Iterable)null, (Closure)null));
    }

    @Test
    @Deprecated
    public void forAllButLastDoIterator() {
        Closure testClosure = ClosureUtils.invokerClosure((String)"clear");
        ArrayList<List<Number>> col = new ArrayList<List<Number>>();
        col.add(this.collectionA);
        col.add(this.collectionB);
        List lastElement = (List)CollectionUtils.forAllButLastDo(col.iterator(), (Closure)testClosure);
        Assert.assertSame((Object)lastElement, this.collectionB);
        Assert.assertTrue((this.collectionA.isEmpty() && !this.collectionB.isEmpty() ? 1 : 0) != 0);
        Assert.assertNull((Object)CollectionUtils.forAllButLastDo(col.iterator(), (Closure)null));
        Assert.assertNull((Object)CollectionUtils.forAllButLastDo((Iterator)null, (Closure)null));
    }

    @Test
    public void getFromMap() {
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("zeroKey", "zero");
        expected.put("oneKey", "one");
        HashMap found = new HashMap();
        Map.Entry entry = CollectionUtils.get(expected, (int)0);
        found.put(entry.getKey(), entry.getValue());
        entry = CollectionUtils.get(expected, (int)1);
        found.put(entry.getKey(), entry.getValue());
        Assert.assertEquals(expected, found);
        try {
            CollectionUtils.get(expected, (int)2);
            Assert.fail((String)"Expecting IndexOutOfBoundsException.");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            CollectionUtils.get(expected, (int)-2);
            Assert.fail((String)"Expecting IndexOutOfBoundsException.");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("zeroKey", "zero");
        map.put("oneKey", "one");
        Map.Entry test = CollectionUtils.get(map, (int)1);
        Assert.assertEquals((Object)"zeroKey", test.getKey());
        Assert.assertEquals((Object)"zero", test.getValue());
        test = CollectionUtils.get(map, (int)0);
        Assert.assertEquals((Object)"oneKey", test.getKey());
        Assert.assertEquals((Object)"one", test.getValue());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getFromList() throws Exception {
        List list = (List)this.createMock(List.class);
        this.expect(list.get(0)).andReturn((Object)"zero");
        this.expect(list.get(1)).andReturn((Object)"one");
        this.replay();
        String string = (String)CollectionUtils.get((Iterable)list, (int)0);
        Assert.assertEquals((Object)"zero", (Object)string);
        Assert.assertEquals((Object)"one", (Object)CollectionUtils.get((Iterable)list, (int)1));
        CollectionUtils.get(new ArrayList(), (int)2);
    }

    @Test
    @Deprecated
    public void getFromIterator() throws Exception {
        Iterator<Integer> iterator = this.iterableA.iterator();
        Assert.assertEquals((long)1L, (long)((Integer)CollectionUtils.get(iterator, (int)0)).intValue());
        iterator = this.iterableA.iterator();
        Assert.assertEquals((long)2L, (long)((Integer)CollectionUtils.get(iterator, (int)1)).intValue());
        try {
            CollectionUtils.get(iterator, (int)10);
            Assert.fail((String)"Expecting IndexOutOfBoundsException.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
    }

    @Test
    @Deprecated
    public void getFromEnumeration() throws Exception {
        Vector<String> vector = new Vector<String>();
        vector.addElement("zero");
        vector.addElement("one");
        Enumeration en = vector.elements();
        Assert.assertEquals((Object)"zero", (Object)CollectionUtils.get(en, (int)0));
        en = vector.elements();
        Assert.assertEquals((Object)"one", (Object)CollectionUtils.get(en, (int)1));
        try {
            CollectionUtils.get(en, (int)3);
            Assert.fail((String)"Expecting IndexOutOfBoundsException.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertTrue((!en.hasMoreElements() ? 1 : 0) != 0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    @Deprecated
    public void getFromIterable() throws Exception {
        HashBag bag = new HashBag();
        bag.add((Object)"element", 1);
        Assert.assertEquals((Object)"element", (Object)CollectionUtils.get((Iterable)bag, (int)0));
        CollectionUtils.get((Iterable)bag, (int)1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getFromObjectArray() throws Exception {
        Object[] objArray = new Object[]{"zero", "one"};
        Assert.assertEquals((Object)"zero", (Object)CollectionUtils.get((Object)objArray, (int)0));
        Assert.assertEquals((Object)"one", (Object)CollectionUtils.get((Object)objArray, (int)1));
        CollectionUtils.get((Object)objArray, (int)2);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getFromPrimitiveArray() throws Exception {
        int[] array = new int[]{10, 20};
        Assert.assertEquals((Object)10, (Object)CollectionUtils.get((Object)array, (int)0));
        Assert.assertEquals((Object)20, (Object)CollectionUtils.get((Object)array, (int)1));
        CollectionUtils.get((Object)array, (int)2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getFromObject() throws Exception {
        Object obj = new Object();
        CollectionUtils.get((Object)obj, (int)0);
    }

    @Test
    public void testSize_List() {
        ArrayList<String> list = null;
        Assert.assertEquals((long)0L, (long)CollectionUtils.size(list));
        list = new ArrayList<String>();
        Assert.assertEquals((long)0L, (long)CollectionUtils.size(list));
        list.add("a");
        Assert.assertEquals((long)1L, (long)CollectionUtils.size(list));
        list.add("b");
        Assert.assertEquals((long)2L, (long)CollectionUtils.size(list));
    }

    @Test
    public void testSize_Map() {
        HashMap<String, String> map = new HashMap<String, String>();
        Assert.assertEquals((long)0L, (long)CollectionUtils.size(map));
        map.put("1", "a");
        Assert.assertEquals((long)1L, (long)CollectionUtils.size(map));
        map.put("2", "b");
        Assert.assertEquals((long)2L, (long)CollectionUtils.size(map));
    }

    @Test
    public void testSize_Array() {
        Object[] objectArray = new Object[]{};
        Assert.assertEquals((long)0L, (long)CollectionUtils.size((Object)objectArray));
        String[] stringArray = new String[3];
        Assert.assertEquals((long)3L, (long)CollectionUtils.size((Object)stringArray));
        stringArray[0] = "a";
        stringArray[1] = "b";
        stringArray[2] = "c";
        Assert.assertEquals((long)3L, (long)CollectionUtils.size((Object)stringArray));
    }

    @Test
    public void testSize_PrimitiveArray() {
        int[] intArray = new int[]{};
        Assert.assertEquals((long)0L, (long)CollectionUtils.size((Object)intArray));
        double[] doubleArray = new double[3];
        Assert.assertEquals((long)3L, (long)CollectionUtils.size((Object)doubleArray));
        doubleArray[0] = 0.0;
        doubleArray[1] = 1.0;
        doubleArray[2] = 2.5;
        Assert.assertEquals((long)3L, (long)CollectionUtils.size((Object)doubleArray));
    }

    @Test
    public void testSize_Enumeration() {
        Vector<String> list = new Vector<String>();
        Assert.assertEquals((long)0L, (long)CollectionUtils.size(list.elements()));
        list.add("a");
        Assert.assertEquals((long)1L, (long)CollectionUtils.size(list.elements()));
        list.add("b");
        Assert.assertEquals((long)2L, (long)CollectionUtils.size(list.elements()));
    }

    @Test
    public void testSize_Iterator() {
        ArrayList<String> list = new ArrayList<String>();
        Assert.assertEquals((long)0L, (long)CollectionUtils.size(list.iterator()));
        list.add("a");
        Assert.assertEquals((long)1L, (long)CollectionUtils.size(list.iterator()));
        list.add("b");
        Assert.assertEquals((long)2L, (long)CollectionUtils.size(list.iterator()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSize_Other() {
        CollectionUtils.size((Object)"not a list");
    }

    @Test
    public void testSizeIsEmpty_Null() {
        Assert.assertEquals((Object)true, (Object)CollectionUtils.sizeIsEmpty(null));
    }

    @Test
    public void testSizeIsEmpty_List() {
        ArrayList<String> list = new ArrayList<String>();
        Assert.assertEquals((Object)true, (Object)CollectionUtils.sizeIsEmpty(list));
        list.add("a");
        Assert.assertEquals((Object)false, (Object)CollectionUtils.sizeIsEmpty(list));
    }

    @Test
    public void testSizeIsEmpty_Map() {
        HashMap<String, String> map = new HashMap<String, String>();
        Assert.assertEquals((Object)true, (Object)CollectionUtils.sizeIsEmpty(map));
        map.put("1", "a");
        Assert.assertEquals((Object)false, (Object)CollectionUtils.sizeIsEmpty(map));
    }

    @Test
    public void testSizeIsEmpty_Array() {
        Object[] objectArray = new Object[]{};
        Assert.assertEquals((Object)true, (Object)CollectionUtils.sizeIsEmpty((Object)objectArray));
        String[] stringArray = new String[3];
        Assert.assertEquals((Object)false, (Object)CollectionUtils.sizeIsEmpty((Object)stringArray));
        stringArray[0] = "a";
        stringArray[1] = "b";
        stringArray[2] = "c";
        Assert.assertEquals((Object)false, (Object)CollectionUtils.sizeIsEmpty((Object)stringArray));
    }

    @Test
    public void testSizeIsEmpty_PrimitiveArray() {
        int[] intArray = new int[]{};
        Assert.assertEquals((Object)true, (Object)CollectionUtils.sizeIsEmpty((Object)intArray));
        double[] doubleArray = new double[3];
        Assert.assertEquals((Object)false, (Object)CollectionUtils.sizeIsEmpty((Object)doubleArray));
        doubleArray[0] = 0.0;
        doubleArray[1] = 1.0;
        doubleArray[2] = 2.5;
        Assert.assertEquals((Object)false, (Object)CollectionUtils.sizeIsEmpty((Object)doubleArray));
    }

    @Test
    public void testSizeIsEmpty_Enumeration() {
        Vector<String> list = new Vector<String>();
        Assert.assertEquals((Object)true, (Object)CollectionUtils.sizeIsEmpty(list.elements()));
        list.add("a");
        Assert.assertEquals((Object)false, (Object)CollectionUtils.sizeIsEmpty(list.elements()));
        Enumeration en = list.elements();
        en.nextElement();
        Assert.assertEquals((Object)true, (Object)CollectionUtils.sizeIsEmpty(en));
    }

    @Test
    public void testSizeIsEmpty_Iterator() {
        ArrayList<String> list = new ArrayList<String>();
        Assert.assertEquals((Object)true, (Object)CollectionUtils.sizeIsEmpty(list.iterator()));
        list.add("a");
        Assert.assertEquals((Object)false, (Object)CollectionUtils.sizeIsEmpty(list.iterator()));
        Iterator it = list.iterator();
        it.next();
        Assert.assertEquals((Object)true, (Object)CollectionUtils.sizeIsEmpty(it));
    }

    @Test
    public void testSizeIsEmpty_Other() {
        try {
            CollectionUtils.sizeIsEmpty((Object)"not a list");
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIsEmptyWithEmptyCollection() {
        ArrayList coll = new ArrayList();
        Assert.assertEquals((Object)true, (Object)CollectionUtils.isEmpty(coll));
    }

    @Test
    public void testIsEmptyWithNonEmptyCollection() {
        ArrayList<String> coll = new ArrayList<String>();
        coll.add("item");
        Assert.assertEquals((Object)false, (Object)CollectionUtils.isEmpty(coll));
    }

    @Test
    public void testIsEmptyWithNull() {
        Collection coll = null;
        Assert.assertEquals((Object)true, (Object)CollectionUtils.isEmpty(coll));
    }

    @Test
    public void testIsNotEmptyWithEmptyCollection() {
        ArrayList coll = new ArrayList();
        Assert.assertEquals((Object)false, (Object)CollectionUtils.isNotEmpty(coll));
    }

    @Test
    public void testIsNotEmptyWithNonEmptyCollection() {
        ArrayList<String> coll = new ArrayList<String>();
        coll.add("item");
        Assert.assertEquals((Object)true, (Object)CollectionUtils.isNotEmpty(coll));
    }

    @Test
    public void testIsNotEmptyWithNull() {
        Collection coll = null;
        Assert.assertEquals((Object)false, (Object)CollectionUtils.isNotEmpty(coll));
    }

    @Test
    public void filter() {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        ints.add(1);
        ints.add(2);
        ints.add(3);
        ints.add(3);
        ArrayList<Integer> iterable = ints;
        Assert.assertTrue((boolean)CollectionUtils.filter(iterable, EQUALS_TWO));
        Assert.assertEquals((long)1L, (long)ints.size());
        Assert.assertEquals((long)2L, (long)((Integer)ints.get(0)).intValue());
    }

    @Test
    public void filterNullParameters() throws Exception {
        List<Long> longs = Collections.nCopies(4, 10L);
        Assert.assertFalse((boolean)CollectionUtils.filter(longs, null));
        Assert.assertEquals((long)4L, (long)longs.size());
        Assert.assertFalse((boolean)CollectionUtils.filter(null, EQUALS_TWO));
        Assert.assertEquals((long)4L, (long)longs.size());
        Assert.assertFalse((boolean)CollectionUtils.filter(null, null));
        Assert.assertEquals((long)4L, (long)longs.size());
    }

    @Test
    public void filterInverse() {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        ints.add(1);
        ints.add(2);
        ints.add(3);
        ints.add(3);
        ArrayList<Integer> iterable = ints;
        Assert.assertTrue((boolean)CollectionUtils.filterInverse(iterable, EQUALS_TWO));
        Assert.assertEquals((long)3L, (long)ints.size());
        Assert.assertEquals((long)1L, (long)((Integer)ints.get(0)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)ints.get(1)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)ints.get(2)).intValue());
    }

    @Test
    public void filterInverseNullParameters() throws Exception {
        List<Long> longs = Collections.nCopies(4, 10L);
        Assert.assertFalse((boolean)CollectionUtils.filterInverse(longs, null));
        Assert.assertEquals((long)4L, (long)longs.size());
        Assert.assertFalse((boolean)CollectionUtils.filterInverse(null, EQUALS_TWO));
        Assert.assertEquals((long)4L, (long)longs.size());
        Assert.assertFalse((boolean)CollectionUtils.filterInverse(null, null));
        Assert.assertEquals((long)4L, (long)longs.size());
    }

    @Test
    @Deprecated
    public void countMatches() {
        Assert.assertEquals((long)4L, (long)CollectionUtils.countMatches(this.iterableB, EQUALS_TWO));
        Assert.assertEquals((long)0L, (long)CollectionUtils.countMatches(this.iterableA, null));
        Assert.assertEquals((long)0L, (long)CollectionUtils.countMatches(null, EQUALS_TWO));
        Assert.assertEquals((long)0L, (long)CollectionUtils.countMatches(null, null));
    }

    @Test
    @Deprecated
    public void exists() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Assert.assertFalse((boolean)CollectionUtils.exists(null, null));
        Assert.assertFalse((boolean)CollectionUtils.exists(list, null));
        Assert.assertFalse((boolean)CollectionUtils.exists(null, EQUALS_TWO));
        Assert.assertFalse((boolean)CollectionUtils.exists(list, EQUALS_TWO));
        list.add(1);
        list.add(3);
        list.add(4);
        Assert.assertFalse((boolean)CollectionUtils.exists(list, EQUALS_TWO));
        list.add(2);
        Assert.assertEquals((Object)true, (Object)CollectionUtils.exists(list, EQUALS_TWO));
    }

    @Test
    public void select() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        Collection output1 = CollectionUtils.select(list, EQUALS_TWO);
        Collection output2 = CollectionUtils.select(list, EQUALS_TWO);
        HashSet output3 = (HashSet)CollectionUtils.select(list, EQUALS_TWO, new HashSet());
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)output1, (Collection)output3));
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((long)1L, (long)output1.size());
        Assert.assertEquals((Object)2, output2.iterator().next());
    }

    @Test
    public void selectWithOutputCollections() {
        ArrayList<Integer> input = new ArrayList<Integer>();
        input.add(1);
        input.add(2);
        input.add(3);
        input.add(4);
        ArrayList output = new ArrayList();
        ArrayList rejected = new ArrayList();
        CollectionUtils.select(input, EQUALS_TWO, output, rejected);
        Assert.assertEquals((long)1L, (long)output.size());
        Assert.assertEquals((long)2L, (long)((Integer)CollectionUtils.extractSingleton(output)).intValue());
        Object[] expected = new Integer[]{1, 3, 4};
        Assert.assertArrayEquals((Object[])expected, (Object[])rejected.toArray());
        output.clear();
        rejected.clear();
        CollectionUtils.select((Iterable)null, EQUALS_TWO, output, rejected);
        Assert.assertTrue((boolean)output.isEmpty());
        Assert.assertTrue((boolean)rejected.isEmpty());
    }

    @Test
    public void selectRejected() {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(1L);
        list.add(2L);
        list.add(3L);
        list.add(4L);
        Collection output1 = CollectionUtils.selectRejected(list, EQUALS_TWO);
        Collection output2 = CollectionUtils.selectRejected(list, EQUALS_TWO);
        HashSet output3 = (HashSet)CollectionUtils.selectRejected(list, EQUALS_TWO, new HashSet());
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)output1, (Collection)output2));
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)output1, (Collection)output3));
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((long)3L, (long)output1.size());
        Assert.assertTrue((boolean)output1.contains(1L));
        Assert.assertTrue((boolean)output1.contains(3L));
        Assert.assertTrue((boolean)output1.contains(4L));
    }

    @Test
    public void collect() {
        Transformer transformer = TransformerUtils.constantTransformer((Object)2L);
        Collection collection = CollectionUtils.collect(this.iterableA, (Transformer)transformer);
        Assert.assertTrue((collection.size() == this.collectionA.size() ? 1 : 0) != 0);
        this.assertCollectResult(collection);
        ArrayList list = (ArrayList)CollectionUtils.collect(this.collectionA, (Transformer)transformer, new ArrayList());
        Assert.assertTrue((list.size() == this.collectionA.size() ? 1 : 0) != 0);
        this.assertCollectResult(list);
        Iterator<Integer> iterator = null;
        list = (ArrayList)CollectionUtils.collect(iterator, (Transformer)transformer, new ArrayList());
        iterator = this.iterableA.iterator();
        list = (ArrayList)CollectionUtils.collect(iterator, (Transformer)transformer, (Collection)list);
        Assert.assertTrue((collection.size() == this.collectionA.size() ? 1 : 0) != 0);
        this.assertCollectResult(collection);
        iterator = this.collectionA.iterator();
        collection = CollectionUtils.collect(iterator, (Transformer)transformer);
        Assert.assertTrue((collection.size() == this.collectionA.size() ? 1 : 0) != 0);
        Assert.assertTrue((collection.contains(2L) && !collection.contains(1) ? 1 : 0) != 0);
        collection = CollectionUtils.collect((Iterator)null, (Transformer)null);
        Assert.assertTrue((collection.size() == 0 ? 1 : 0) != 0);
        int size = this.collectionA.size();
        this.collectionB = (List)CollectionUtils.collect((Iterable)null, (Transformer)transformer, this.collectionB);
        Assert.assertTrue((this.collectionA.size() == size && this.collectionA.contains(1) ? 1 : 0) != 0);
        CollectionUtils.collect(this.collectionB, null, this.collectionA);
        Assert.assertTrue((this.collectionA.size() == size && this.collectionA.contains(1) ? 1 : 0) != 0);
    }

    private void assertCollectResult(Collection<Number> collection) {
        Assert.assertTrue((this.collectionA.contains(1) && !this.collectionA.contains(2L) ? 1 : 0) != 0);
        Assert.assertTrue((collection.contains(2L) && !collection.contains(1) ? 1 : 0) != 0);
    }

    @Test
    public void transform1() {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(1L);
        list.add(2L);
        list.add(3L);
        CollectionUtils.transform(list, this.TRANSFORM_TO_INTEGER);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)1, list.get(0));
        Assert.assertEquals((Object)2, list.get(1));
        Assert.assertEquals((Object)3, list.get(2));
        list = new ArrayList();
        list.add(1L);
        list.add(2L);
        list.add(3L);
        CollectionUtils.transform(null, this.TRANSFORM_TO_INTEGER);
        Assert.assertEquals((long)3L, (long)list.size());
        CollectionUtils.transform(list, null);
        Assert.assertEquals((long)3L, (long)list.size());
        CollectionUtils.transform(null, null);
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void transform2() {
        HashSet<Long> set = new HashSet<Long>();
        set.add(1L);
        set.add(2L);
        set.add(3L);
        CollectionUtils.transform(set, (Transformer)new Transformer<Object, Integer>(){

            public Integer transform(Object input) {
                return 4;
            }
        });
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertEquals((Object)4, set.iterator().next());
    }

    @Test
    public void addIgnoreNull() {
        HashSet<String> set = new HashSet<String>();
        set.add("1");
        set.add("2");
        set.add("3");
        Assert.assertFalse((boolean)CollectionUtils.addIgnoreNull(set, null));
        Assert.assertEquals((long)3L, (long)set.size());
        Assert.assertFalse((boolean)CollectionUtils.addIgnoreNull(set, (Object)"1"));
        Assert.assertEquals((long)3L, (long)set.size());
        Assert.assertEquals((Object)true, (Object)CollectionUtils.addIgnoreNull(set, (Object)"4"));
        Assert.assertEquals((long)4L, (long)set.size());
        Assert.assertEquals((Object)true, (Object)set.contains("4"));
    }

    @Test
    public void predicatedCollection() {
        Predicate predicate = PredicateUtils.instanceofPredicate(Integer.class);
        Collection collection = CollectionUtils.predicatedCollection(new ArrayList(), (Predicate)predicate);
        Assert.assertTrue((String)"returned object should be a PredicatedCollection", (boolean)(collection instanceof PredicatedCollection));
        try {
            CollectionUtils.predicatedCollection(new ArrayList(), null);
            Assert.fail((String)"Expecting NullPointerException for null predicate.");
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            CollectionUtils.predicatedCollection(null, (Predicate)predicate);
            Assert.fail((String)"Expecting NullPointerException for null collection.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void isFull() {
        HashSet<String> set = new HashSet<String>();
        set.add("1");
        set.add("2");
        set.add("3");
        try {
            CollectionUtils.isFull(null);
            Assert.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        Assert.assertFalse((boolean)CollectionUtils.isFull(set));
        CircularFifoQueue buf = new CircularFifoQueue(set);
        Assert.assertEquals((Object)false, (Object)CollectionUtils.isFull((Collection)buf));
        buf.remove((Object)"2");
        Assert.assertFalse((boolean)CollectionUtils.isFull((Collection)buf));
        buf.add((Object)"2");
        Assert.assertEquals((Object)false, (Object)CollectionUtils.isFull((Collection)buf));
    }

    @Test
    public void isEmpty() {
        Assert.assertFalse((boolean)CollectionUtils.isNotEmpty(null));
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty(this.collectionA));
    }

    @Test
    public void maxSize() {
        HashSet<String> set = new HashSet<String>();
        set.add("1");
        set.add("2");
        set.add("3");
        try {
            CollectionUtils.maxSize(null);
            Assert.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)CollectionUtils.maxSize(set));
        CircularFifoQueue buf = new CircularFifoQueue(set);
        Assert.assertEquals((long)3L, (long)CollectionUtils.maxSize((Collection)buf));
        buf.remove("2");
        Assert.assertEquals((long)3L, (long)CollectionUtils.maxSize((Collection)buf));
        buf.add("2");
        Assert.assertEquals((long)3L, (long)CollectionUtils.maxSize((Collection)buf));
    }

    @Test
    public void intersectionUsesMethodEquals() {
        Integer elta = new Integer(17);
        Integer eltb = new Integer(17);
        Assert.assertEquals((Object)elta, (Object)eltb);
        Assert.assertEquals((Object)eltb, (Object)elta);
        Assert.assertTrue((elta != eltb ? 1 : 0) != 0);
        ArrayList<Integer> cola = new ArrayList<Integer>();
        ArrayList<Integer> colb = new ArrayList<Integer>();
        cola.add(elta);
        colb.add(eltb);
        Collection intersection = CollectionUtils.intersection(cola, colb);
        Assert.assertEquals((long)1L, (long)intersection.size());
        Object eltc = intersection.iterator().next();
        Assert.assertTrue((eltc == elta && eltc != eltb || eltc != elta && eltc == eltb ? 1 : 0) != 0);
        Assert.assertEquals((Object)elta, eltc);
        Assert.assertEquals(eltc, (Object)elta);
        Assert.assertEquals((Object)eltb, eltc);
        Assert.assertEquals(eltc, (Object)eltb);
    }

    @Test
    public void testRetainAll() {
        ArrayList<String> base = new ArrayList<String>();
        base.add("A");
        base.add("B");
        base.add("C");
        ArrayList<String> sub = new ArrayList<String>();
        sub.add("A");
        sub.add("C");
        sub.add("X");
        Collection result = CollectionUtils.retainAll(base, sub);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)true, (Object)result.contains("A"));
        Assert.assertFalse((boolean)result.contains("B"));
        Assert.assertEquals((Object)true, (Object)result.contains("C"));
        Assert.assertEquals((long)3L, (long)base.size());
        Assert.assertEquals((Object)true, (Object)base.contains("A"));
        Assert.assertEquals((Object)true, (Object)base.contains("B"));
        Assert.assertEquals((Object)true, (Object)base.contains("C"));
        Assert.assertEquals((long)3L, (long)sub.size());
        Assert.assertEquals((Object)true, (Object)sub.contains("A"));
        Assert.assertEquals((Object)true, (Object)sub.contains("C"));
        Assert.assertEquals((Object)true, (Object)sub.contains("X"));
        try {
            CollectionUtils.retainAll(null, null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveAll() {
        ArrayList<String> base = new ArrayList<String>();
        base.add("A");
        base.add("B");
        base.add("C");
        ArrayList<String> sub = new ArrayList<String>();
        sub.add("A");
        sub.add("C");
        sub.add("X");
        Collection result = CollectionUtils.removeAll(base, sub);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertFalse((boolean)result.contains("A"));
        Assert.assertEquals((Object)true, (Object)result.contains("B"));
        Assert.assertFalse((boolean)result.contains("C"));
        Assert.assertEquals((long)3L, (long)base.size());
        Assert.assertEquals((Object)true, (Object)base.contains("A"));
        Assert.assertEquals((Object)true, (Object)base.contains("B"));
        Assert.assertEquals((Object)true, (Object)base.contains("C"));
        Assert.assertEquals((long)3L, (long)sub.size());
        Assert.assertEquals((Object)true, (Object)sub.contains("A"));
        Assert.assertEquals((Object)true, (Object)sub.contains("C"));
        Assert.assertEquals((Object)true, (Object)sub.contains("X"));
        try {
            CollectionUtils.removeAll(null, null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
    }

    @Test
    public void testTransformedCollection() {
        Transformer transformer = TransformerUtils.nopTransformer();
        Collection collection = CollectionUtils.transformingCollection(new ArrayList(), (Transformer)transformer);
        Assert.assertTrue((String)"returned object should be a TransformedCollection", (boolean)(collection instanceof TransformedCollection));
        try {
            CollectionUtils.transformingCollection(new ArrayList(), null);
            Assert.fail((String)"Expecting NullPointerException for null transformer.");
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            CollectionUtils.transformingCollection(null, (Transformer)transformer);
            Assert.fail((String)"Expecting NullPointerException for null collection.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testTransformedCollection_2() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add("2");
        list.add("3");
        Collection result = CollectionUtils.transformingCollection(list, this.TRANSFORM_TO_INTEGER);
        Assert.assertEquals((Object)true, (Object)result.contains("1"));
        Assert.assertEquals((Object)true, (Object)result.contains("2"));
        Assert.assertEquals((Object)true, (Object)result.contains("3"));
    }

    @Test
    @Deprecated
    public void testSynchronizedCollection() {
        Collection col = CollectionUtils.synchronizedCollection(new ArrayList());
        Assert.assertTrue((String)"Returned object should be a SynchronizedCollection.", (boolean)(col instanceof SynchronizedCollection));
        try {
            CollectionUtils.synchronizedCollection(null);
            Assert.fail((String)"Expecting NullPointerException for null collection.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    @Deprecated
    public void testUnmodifiableCollection() {
        Collection col = CollectionUtils.unmodifiableCollection(new ArrayList());
        Assert.assertTrue((String)"Returned object should be a UnmodifiableCollection.", (boolean)(col instanceof UnmodifiableCollection));
        try {
            CollectionUtils.unmodifiableCollection(null);
            Assert.fail((String)"Expecting NullPointerException for null collection.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void emptyCollection() throws Exception {
        Collection coll = CollectionUtils.emptyCollection();
        Assert.assertEquals((Object)CollectionUtils.EMPTY_COLLECTION, (Object)coll);
    }

    @Test
    public void emptyIfNull() {
        Assert.assertTrue((boolean)CollectionUtils.emptyIfNull(null).isEmpty());
        ArrayList collection = new ArrayList();
        Assert.assertSame(collection, (Object)CollectionUtils.emptyIfNull(collection));
    }

    @Test
    public void addAllForIterable() {
        Collection inputCollection;
        Collection inputIterable = inputCollection = (Collection)this.createMock(Collection.class);
        Iterable iterable = (Iterable)this.createMock(Iterable.class);
        Iterator iterator = (Iterator)this.createMock(Iterator.class);
        Collection c = (Collection)this.createMock(Collection.class);
        this.expect(iterable.iterator()).andReturn((Object)iterator);
        this.next(iterator, 1L);
        this.next(iterator, 2L);
        this.next(iterator, 3L);
        this.expect(iterator.hasNext()).andReturn((Object)false);
        this.expect(c.add(1L)).andReturn((Object)true);
        this.expect(c.add(2L)).andReturn((Object)true);
        this.expect(c.add(3L)).andReturn((Object)true);
        this.expect(c.addAll(inputCollection)).andReturn((Object)true);
        this.expect(iterable.iterator()).andReturn((Object)iterator);
        this.next(iterator, 1L);
        this.expect(iterator.hasNext()).andReturn((Object)false);
        this.expect(c.add(1L)).andReturn((Object)false);
        this.expect(c.addAll(inputCollection)).andReturn((Object)false);
        this.replay();
        Assert.assertTrue((boolean)CollectionUtils.addAll((Collection)c, (Iterable)iterable));
        Assert.assertTrue((boolean)CollectionUtils.addAll((Collection)c, (Iterable)inputIterable));
        Assert.assertFalse((boolean)CollectionUtils.addAll((Collection)c, (Iterable)iterable));
        Assert.assertFalse((boolean)CollectionUtils.addAll((Collection)c, (Iterable)inputIterable));
        this.verify();
    }

    @Test
    public void addAllForEnumeration() {
        Hashtable<Integer, Integer> h = new Hashtable<Integer, Integer>();
        h.put(5, 5);
        Enumeration enumeration = h.keys();
        CollectionUtils.addAll(this.collectionA, enumeration);
        Assert.assertTrue((boolean)this.collectionA.contains(5));
    }

    @Test
    public void addAllForElements() {
        CollectionUtils.addAll(this.collectionA, (Object[])new Integer[]{5});
        Assert.assertTrue((boolean)this.collectionA.contains(5));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getNegative() {
        CollectionUtils.get(this.collectionA, (int)-3);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getPositiveOutOfBounds() {
        CollectionUtils.get(this.collectionA.iterator(), (int)30);
    }

    @Test(expected=IllegalArgumentException.class)
    public void get1() {
        CollectionUtils.get((Object)null, (int)0);
    }

    @Test
    public void get() {
        Assert.assertEquals((Object)2, (Object)CollectionUtils.get(this.collectionA, (int)2));
        Assert.assertEquals((Object)2, (Object)CollectionUtils.get(this.collectionA.iterator(), (int)2));
        Map map = CollectionUtils.getCardinalityMap(this.collectionA);
        Assert.assertEquals(map.entrySet().iterator().next(), (Object)CollectionUtils.get((Object)map, (int)0));
    }

    @Test
    public void getIterator() {
        Iterator<Integer> it = this.collectionA.iterator();
        Assert.assertEquals((Object)2, (Object)CollectionUtils.get(it, (int)2));
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Object)4, (Object)CollectionUtils.get(it, (int)6));
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void getEnumeration() {
        Vector<Integer> vectorA = new Vector<Integer>(this.collectionA);
        Enumeration<Integer> e = vectorA.elements();
        Assert.assertEquals((Object)2, (Object)CollectionUtils.get(e, (int)2));
        Assert.assertTrue((boolean)e.hasMoreElements());
        Assert.assertEquals((Object)4, (Object)CollectionUtils.get(e, (int)6));
        Assert.assertFalse((boolean)e.hasMoreElements());
    }

    @Test
    public void reverse() {
        CollectionUtils.reverseArray((Object[])new Object[0]);
        Object[] a = this.collectionA.toArray(new Integer[this.collectionA.size()]);
        CollectionUtils.reverseArray((Object[])a);
        Collections.reverse(this.collectionA);
        Assert.assertEquals(this.collectionA, Arrays.asList(a));
    }

    @Test
    public void extractSingleton() {
        ArrayList<String> coll = null;
        try {
            CollectionUtils.extractSingleton(coll);
            Assert.fail((String)"expected NullPointerException from extractSingleton(null)");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        coll = new ArrayList<String>();
        try {
            CollectionUtils.extractSingleton(coll);
            Assert.fail((String)"expected IllegalArgumentException from extractSingleton(empty)");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        coll.add("foo");
        Assert.assertEquals((Object)"foo", (Object)CollectionUtils.extractSingleton(coll));
        coll.add("bar");
        try {
            CollectionUtils.extractSingleton(coll);
            Assert.fail((String)"expected IllegalArgumentException from extractSingleton(size == 2)");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private <T> void next(Iterator<T> iterator, T t) {
        this.expect(iterator.hasNext()).andReturn((Object)true);
        this.expect(iterator.next()).andReturn(t);
    }

    @Test(expected=NullPointerException.class)
    public void collateException1() {
        CollectionUtils.collate(this.collectionA, null);
    }

    @Test(expected=NullPointerException.class)
    public void collateException2() {
        CollectionUtils.collate(this.collectionA, this.collectionC, null);
    }

    @Test
    public void testCollate() {
        List result = CollectionUtils.collate(this.emptyCollection, this.emptyCollection);
        Assert.assertEquals((String)"Merge empty with empty", (long)0L, (long)result.size());
        result = CollectionUtils.collate(this.collectionA, this.emptyCollection);
        Assert.assertEquals((String)"Merge empty with non-empty", this.collectionA, (Object)result);
        List result1 = CollectionUtils.collate(this.collectionD, this.collectionE);
        List result2 = CollectionUtils.collate(this.collectionE, this.collectionD);
        Assert.assertEquals((String)"Merge two lists 1", (Object)result1, (Object)result2);
        ArrayList<Integer> combinedList = new ArrayList<Integer>();
        combinedList.addAll(this.collectionD);
        combinedList.addAll(this.collectionE);
        Collections.sort(combinedList);
        Assert.assertEquals((String)"Merge two lists 2", combinedList, (Object)result2);
        Comparator reverseComparator = ComparatorUtils.reversedComparator((Comparator)ComparatorUtils.naturalComparator());
        result = CollectionUtils.collate(this.emptyCollection, this.emptyCollection, (Comparator)reverseComparator);
        Assert.assertEquals((String)"Comparator Merge empty with empty", (long)0L, (long)result.size());
        Collections.reverse((List)this.collectionD);
        Collections.reverse((List)this.collectionE);
        Collections.reverse(combinedList);
        result1 = CollectionUtils.collate(this.collectionD, this.collectionE, (Comparator)reverseComparator);
        result2 = CollectionUtils.collate(this.collectionE, this.collectionD, (Comparator)reverseComparator);
        Assert.assertEquals((String)"Comparator Merge two lists 1", (Object)result1, (Object)result2);
        Assert.assertEquals((String)"Comparator Merge two lists 2", combinedList, (Object)result2);
    }

    @Test
    public void testCollateIgnoreDuplicates() {
        List result1 = CollectionUtils.collate(this.collectionD, this.collectionE, (boolean)false);
        List result2 = CollectionUtils.collate(this.collectionE, this.collectionD, (boolean)false);
        Assert.assertEquals((String)"Merge two lists 1 - ignore duplicates", (Object)result1, (Object)result2);
        HashSet<Integer> combinedSet = new HashSet<Integer>();
        combinedSet.addAll(this.collectionD);
        combinedSet.addAll(this.collectionE);
        ArrayList combinedList = new ArrayList(combinedSet);
        Collections.sort(combinedList);
        Assert.assertEquals((String)"Merge two lists 2 - ignore duplicates", combinedList, (Object)result2);
    }

    @Test(expected=NullPointerException.class)
    public void testPermutationsWithNullCollection() {
        CollectionUtils.permutations(null);
    }

    @Test
    public void testPermutations() {
        List<Integer> sample = this.collectionA.subList(0, 5);
        Collection permutations = CollectionUtils.permutations(sample);
        int collSize = sample.size();
        int factorial = 1;
        for (int i = 1; i <= collSize; ++i) {
            factorial *= i;
        }
        Assert.assertEquals((long)factorial, (long)permutations.size());
    }

    @Test
    @Deprecated
    public void testMatchesAll() {
        Assert.assertFalse((boolean)CollectionUtils.matchesAll(null, null));
        Assert.assertFalse((boolean)CollectionUtils.matchesAll(this.collectionA, null));
        Predicate<Integer> lessThanFive = new Predicate<Integer>(){

            public boolean evaluate(Integer object) {
                return object < 5;
            }
        };
        Assert.assertTrue((boolean)CollectionUtils.matchesAll(this.collectionA, (Predicate)lessThanFive));
        Predicate<Integer> lessThanFour = new Predicate<Integer>(){

            public boolean evaluate(Integer object) {
                return object < 4;
            }
        };
        Assert.assertFalse((boolean)CollectionUtils.matchesAll(this.collectionA, (Predicate)lessThanFour));
        Assert.assertTrue((boolean)CollectionUtils.matchesAll(null, (Predicate)lessThanFour));
        Assert.assertTrue((boolean)CollectionUtils.matchesAll(this.emptyCollection, (Predicate)lessThanFour));
    }

    @Test
    public void testRemoveAllWithEquator() {
        ArrayList<String> base = new ArrayList<String>();
        base.add("AC");
        base.add("BB");
        base.add("CA");
        ArrayList<String> remove = new ArrayList<String>();
        remove.add("AA");
        remove.add("CX");
        remove.add("XZ");
        Collection result = CollectionUtils.removeAll(base, remove, (Equator)new Equator<String>(){

            public boolean equate(String o1, String o2) {
                return o1.charAt(1) == o2.charAt(1);
            }

            public int hash(String o) {
                return o.charAt(1);
            }
        });
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)result.contains("AC"));
        Assert.assertTrue((boolean)result.contains("BB"));
        Assert.assertFalse((boolean)result.contains("CA"));
        Assert.assertEquals((long)3L, (long)base.size());
        Assert.assertEquals((Object)true, (Object)base.contains("AC"));
        Assert.assertEquals((Object)true, (Object)base.contains("BB"));
        Assert.assertEquals((Object)true, (Object)base.contains("CA"));
        Assert.assertEquals((long)3L, (long)remove.size());
        Assert.assertEquals((Object)true, (Object)remove.contains("AA"));
        Assert.assertEquals((Object)true, (Object)remove.contains("CX"));
        Assert.assertEquals((Object)true, (Object)remove.contains("XZ"));
        try {
            CollectionUtils.removeAll(null, null, (Equator)DefaultEquator.defaultEquator());
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            CollectionUtils.removeAll(base, remove, null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
    }

    @Test
    public void testRetainAllWithEquator() {
        ArrayList<String> base = new ArrayList<String>();
        base.add("AC");
        base.add("BB");
        base.add("CA");
        ArrayList<String> retain = new ArrayList<String>();
        retain.add("AA");
        retain.add("CX");
        retain.add("XZ");
        Collection result = CollectionUtils.retainAll(base, retain, (Equator)new Equator<String>(){

            public boolean equate(String o1, String o2) {
                return o1.charAt(1) == o2.charAt(1);
            }

            public int hash(String o) {
                return o.charAt(1);
            }
        });
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.contains("CA"));
        Assert.assertFalse((boolean)result.contains("BB"));
        Assert.assertFalse((boolean)result.contains("AC"));
        Assert.assertEquals((long)3L, (long)base.size());
        Assert.assertTrue((boolean)base.contains("AC"));
        Assert.assertTrue((boolean)base.contains("BB"));
        Assert.assertTrue((boolean)base.contains("CA"));
        Assert.assertEquals((long)3L, (long)retain.size());
        Assert.assertTrue((boolean)retain.contains("AA"));
        Assert.assertTrue((boolean)retain.contains("CX"));
        Assert.assertTrue((boolean)retain.contains("XZ"));
        try {
            CollectionUtils.retainAll(null, null, null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            CollectionUtils.retainAll(base, retain, null);
            Assert.fail((String)"expecting NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
    }
}

