/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.QueueUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.collections4.queue.PredicatedQueue;
import org.apache.commons.collections4.queue.TransformedQueue;
import org.apache.commons.collections4.queue.UnmodifiableQueue;
import org.junit.Assert;
import org.junit.Test;

public class QueueUtilsTest {
    protected Predicate<Object> truePredicate = TruePredicate.truePredicate();
    protected Transformer<Object, Object> nopTransformer = TransformerUtils.nopTransformer();

    @Test
    public void testUnmodifiableQueue() {
        Queue queue = QueueUtils.unmodifiableQueue(new LinkedList());
        Assert.assertTrue((String)"Returned object should be an UnmodifiableQueue.", (boolean)(queue instanceof UnmodifiableQueue));
        try {
            QueueUtils.unmodifiableQueue(null);
            Assert.fail((String)"Expecting NullPointerException for null queue.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertSame((String)"UnmodifiableQueue shall not be decorated", (Object)queue, (Object)QueueUtils.unmodifiableQueue((Queue)queue));
    }

    @Test
    public void testPredicatedQueue() {
        Queue queue = QueueUtils.predicatedQueue(new LinkedList(), this.truePredicate);
        Assert.assertTrue((String)"Returned object should be a PredicatedQueue.", (boolean)(queue instanceof PredicatedQueue));
        try {
            QueueUtils.predicatedQueue(null, this.truePredicate);
            Assert.fail((String)"Expecting NullPointerException for null queue.");
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            QueueUtils.predicatedQueue(new LinkedList(), null);
            Assert.fail((String)"Expecting NullPointerException for null predicate.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testTransformedQueue() {
        Queue queue = QueueUtils.transformingQueue(new LinkedList(), this.nopTransformer);
        Assert.assertTrue((String)"Returned object should be an TransformedQueue.", (boolean)(queue instanceof TransformedQueue));
        try {
            QueueUtils.transformingQueue(null, this.nopTransformer);
            Assert.fail((String)"Expecting NullPointerException for null queue.");
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            QueueUtils.transformingQueue(new LinkedList(), null);
            Assert.fail((String)"Expecting NullPointerException for null transformer.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testEmptyQueue() {
        Queue queue = QueueUtils.emptyQueue();
        Assert.assertTrue((String)"Returned object should be an UnmodifiableQueue.", (boolean)(queue instanceof UnmodifiableQueue));
        Assert.assertTrue((String)"Returned queue is not empty.", (boolean)queue.isEmpty());
        try {
            queue.add(new Object());
            Assert.fail((String)"Expecting UnsupportedOperationException for empty queue.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

