/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import java.util.Comparator;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.SortedBag;
import org.apache.commons.collections4.bag.AbstractSortedBagTest;
import org.apache.commons.collections4.bag.TreeBag;

public class TreeBagTest<T>
extends AbstractSortedBagTest<T> {
    public TreeBagTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(TreeBagTest.class);
    }

    @Override
    public SortedBag<T> makeObject() {
        return new TreeBag();
    }

    public SortedBag<T> setupBag() {
        SortedBag<T> bag = this.makeObject();
        bag.add((Object)"C");
        bag.add((Object)"A");
        bag.add((Object)"B");
        bag.add((Object)"D");
        return bag;
    }

    public void testCollections265() {
        TreeBag bag = new TreeBag();
        try {
            bag.add(new Object());
            TreeBagTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCollections555() {
        TreeBag bag = new TreeBag();
        try {
            bag.add(null);
            TreeBagTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        TreeBag bag2 = new TreeBag((Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        try {
            bag2.add((Object)"a");
            bag2.add(null);
            TreeBagTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testOrdering() {
        SortedBag<T> bag = this.setupBag();
        TreeBagTest.assertEquals((String)"Should get elements in correct order", (Object)"A", (Object)bag.toArray()[0]);
        TreeBagTest.assertEquals((String)"Should get elements in correct order", (Object)"B", (Object)bag.toArray()[1]);
        TreeBagTest.assertEquals((String)"Should get elements in correct order", (Object)"C", (Object)bag.toArray()[2]);
        TreeBagTest.assertEquals((String)"Should get first key", (Object)"A", (Object)bag.first());
        TreeBagTest.assertEquals((String)"Should get last key", (Object)"D", (Object)bag.last());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

