/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bidimap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.SortedBidiMap;
import org.apache.commons.collections4.bidimap.AbstractSortedBidiMapTest;
import org.apache.commons.collections4.bidimap.DualTreeBidiMap;
import org.apache.commons.collections4.comparators.ComparableComparator;
import org.apache.commons.collections4.comparators.ReverseComparator;

public class DualTreeBidiMap2Test<K extends Comparable<K>, V extends Comparable<V>>
extends AbstractSortedBidiMapTest<K, V> {
    public static Test suite() {
        return BulkTest.makeSuite(DualTreeBidiMap2Test.class);
    }

    public DualTreeBidiMap2Test(String testName) {
        super(testName);
    }

    @Override
    public DualTreeBidiMap<K, V> makeObject() {
        return new DualTreeBidiMap((Comparator)new ReverseComparator((Comparator)ComparableComparator.comparableComparator()), (Comparator)new ReverseComparator((Comparator)ComparableComparator.comparableComparator()));
    }

    @Override
    public TreeMap<K, V> makeConfirmedMap() {
        return new TreeMap(new ReverseComparator((Comparator)ComparableComparator.comparableComparator()));
    }

    public void testComparator() {
        this.resetEmpty();
        SortedBidiMap bidi = (SortedBidiMap)this.map;
        DualTreeBidiMap2Test.assertNotNull((Object)bidi.comparator());
        DualTreeBidiMap2Test.assertTrue((boolean)(bidi.comparator() instanceof ReverseComparator));
    }

    public void testComparator2() {
        DualTreeBidiMap dtbm = new DualTreeBidiMap(String.CASE_INSENSITIVE_ORDER, null);
        dtbm.put((Object)"two", (Object)0);
        dtbm.put((Object)"one", (Object)1);
        DualTreeBidiMap2Test.assertEquals((String)"one", (String)((String)dtbm.firstKey()));
        DualTreeBidiMap2Test.assertEquals((String)"two", (String)((String)dtbm.lastKey()));
    }

    public void testSerializeDeserializeCheckComparator() throws Exception {
        DualTreeBidiMap<K, V> obj = this.makeObject();
        if (obj instanceof Serializable && this.isTestSerialization()) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(obj);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            Object dest = in.readObject();
            in.close();
            SortedBidiMap bidi = (SortedBidiMap)dest;
            DualTreeBidiMap2Test.assertNotNull((Object)obj.comparator());
            DualTreeBidiMap2Test.assertNotNull((Object)bidi.comparator());
            DualTreeBidiMap2Test.assertTrue((boolean)(bidi.comparator() instanceof ReverseComparator));
        }
    }

    public void testCollections364() throws Exception {
        DualTreeBidiMap original = new DualTreeBidiMap(String.CASE_INSENSITIVE_ORDER, (Comparator)new IntegerComparator());
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buffer);
        out.writeObject(original);
        out.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
        DualTreeBidiMap deserialised = (DualTreeBidiMap)in.readObject();
        in.close();
        DualTreeBidiMap2Test.assertNotNull((Object)original.comparator());
        DualTreeBidiMap2Test.assertNotNull((Object)deserialised.comparator());
        DualTreeBidiMap2Test.assertEquals(original.comparator().getClass(), deserialised.comparator().getClass());
        DualTreeBidiMap2Test.assertEquals(original.valueComparator().getClass(), deserialised.valueComparator().getClass());
    }

    public void testSortOrder() throws Exception {
        SortedBidiMap sm = this.makeFullMap();
        List newSortedKeys = this.getAsList(this.getSampleKeys());
        Collections.sort(newSortedKeys, new ReverseComparator((Comparator)ComparableComparator.comparableComparator()));
        newSortedKeys = Collections.unmodifiableList(newSortedKeys);
        Iterator mapIter = sm.keySet().iterator();
        for (Comparable expectedKey : newSortedKeys) {
            Comparable mapKey = (Comparable)mapIter.next();
            DualTreeBidiMap2Test.assertNotNull((String)"key in sorted list may not be null", (Object)expectedKey);
            DualTreeBidiMap2Test.assertNotNull((String)"key in map may not be null", (Object)mapKey);
            DualTreeBidiMap2Test.assertEquals((String)"key from sorted list and map must be equal", (Object)expectedKey, (Object)mapKey);
        }
    }

    @Override
    public String getCompatibilityVersion() {
        return "4.Test2";
    }

    @Override
    public String[] ignoredTests() {
        String recursiveTest = "DualTreeBidiMap2Test.bulkTestInverseMap.bulkTestInverseMap";
        if (IBMJDK16) {
            String preSub = "DualTreeBidiMap2Test.bulkTestSubMap.";
            String preTail = "DualTreeBidiMap2Test.bulkTestTailMap.";
            return new String[]{recursiveTest, "DualTreeBidiMap2Test.bulkTestSubMap.bulkTestMapEntrySet.testCollectionIteratorRemove", "DualTreeBidiMap2Test.bulkTestSubMap.bulkTestMapValues.testCollectionIteratorRemove", "DualTreeBidiMap2Test.bulkTestTailMap.testMapRemove", "DualTreeBidiMap2Test.bulkTestTailMap.bulkTestMapEntrySet.testCollectionIteratorRemove", "DualTreeBidiMap2Test.bulkTestTailMap.bulkTestMapEntrySet.testCollectionRemoveAll", "DualTreeBidiMap2Test.bulkTestTailMap.bulkTestMapKeySet.testCollectionIteratorRemove", "DualTreeBidiMap2Test.bulkTestTailMap.bulkTestMapKeySet.testCollectionRemoveAll", "DualTreeBidiMap2Test.bulkTestTailMap.bulkTestMapValues.testCollectionClear", "DualTreeBidiMap2Test.bulkTestTailMap.bulkTestMapValues.testCollectionRemoveAll", "DualTreeBidiMap2Test.bulkTestTailMap.bulkTestMapValues.testCollectionRetainAll"};
        }
        return new String[]{recursiveTest};
    }

    private static class IntegerComparator
    implements Comparator<Integer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private IntegerComparator() {
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            return o1.compareTo(o2);
        }
    }
}

