/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.comparators;

import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.comparators.AbstractComparatorTest;
import org.apache.commons.collections4.comparators.ComparableComparator;
import org.apache.commons.collections4.comparators.ComparatorChain;
import org.junit.Test;

public class ComparatorChainTest
extends AbstractComparatorTest<PseudoRow> {
    public ComparatorChainTest(String testName) {
        super(testName);
    }

    @Override
    public Comparator<PseudoRow> makeObject() {
        ComparatorChain chain = new ComparatorChain((Comparator)new ColumnComparator(0));
        chain.addComparator((Comparator)new ColumnComparator(1), true);
        chain.addComparator((Comparator)new ColumnComparator(2), false);
        return chain;
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Test
    public void testNoopComparatorChain() {
        ComparatorChain chain = new ComparatorChain();
        Integer i1 = 4;
        Integer i2 = 6;
        chain.addComparator((Comparator)new ComparableComparator());
        int correctValue = i1.compareTo(i2);
        ComparatorChainTest.assertTrue((String)"Comparison returns the right order", (chain.compare((Object)i1, (Object)i2) == correctValue ? 1 : 0) != 0);
    }

    @Test
    public void testBadNoopComparatorChain() {
        ComparatorChain chain = new ComparatorChain();
        Integer i1 = 4;
        Integer i2 = 6;
        try {
            chain.compare((Object)i1, (Object)i2);
            ComparatorChainTest.fail((String)"An exception should be thrown when a chain contains zero comparators.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    @Test
    public void testListComparatorChain() {
        LinkedList<ComparableComparator> list = new LinkedList<ComparableComparator>();
        list.add(new ComparableComparator());
        ComparatorChain chain = new ComparatorChain(list);
        Integer i1 = 4;
        Integer i2 = 6;
        int correctValue = i1.compareTo(i2);
        ComparatorChainTest.assertTrue((String)"Comparison returns the right order", (chain.compare((Object)i1, (Object)i2) == correctValue ? 1 : 0) != 0);
    }

    @Test
    public void testBadListComparatorChain() {
        LinkedList list = new LinkedList();
        ComparatorChain chain = new ComparatorChain(list);
        Integer i1 = 4;
        Integer i2 = 6;
        try {
            chain.compare((Object)i1, (Object)i2);
            ComparatorChainTest.fail((String)"An exception should be thrown when a chain contains zero comparators.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    @Test
    public void testComparatorChainOnMinvaluedCompatator() {
        ComparatorChain chain = new ComparatorChain();
        chain.addComparator((Comparator)new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                int result = a.compareTo(b);
                if (result < 0) {
                    return Integer.MIN_VALUE;
                }
                if (result > 0) {
                    return Integer.MAX_VALUE;
                }
                return 0;
            }
        }, true);
        ComparatorChainTest.assertTrue((chain.compare((Object)4, (Object)5) > 0 ? 1 : 0) != 0);
        ComparatorChainTest.assertTrue((chain.compare((Object)5, (Object)4) < 0 ? 1 : 0) != 0);
        ComparatorChainTest.assertTrue((chain.compare((Object)4, (Object)4) == 0 ? 1 : 0) != 0);
    }

    @Override
    public List<PseudoRow> getComparableObjectsOrdered() {
        LinkedList<PseudoRow> list = new LinkedList<PseudoRow>();
        list.add(new PseudoRow(1, 2, 3));
        list.add(new PseudoRow(2, 3, 5));
        list.add(new PseudoRow(2, 2, 4));
        list.add(new PseudoRow(2, 2, 8));
        list.add(new PseudoRow(3, 1, 0));
        list.add(new PseudoRow(4, 4, 4));
        list.add(new PseudoRow(4, 4, 7));
        return list;
    }

    public static class ColumnComparator
    implements Comparator<PseudoRow>,
    Serializable {
        private static final long serialVersionUID = -2284880866328872105L;
        protected int colIndex = 0;

        public ColumnComparator(int colIndex) {
            this.colIndex = colIndex;
        }

        @Override
        public int compare(PseudoRow o1, PseudoRow o2) {
            int col2;
            int col1 = o1.getColumn(this.colIndex);
            if (col1 > (col2 = o2.getColumn(this.colIndex))) {
                return 1;
            }
            if (col1 < col2) {
                return -1;
            }
            return 0;
        }

        public int hashCode() {
            return this.colIndex;
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof ColumnComparator && this.colIndex == ((ColumnComparator)that).colIndex;
        }
    }

    public static class PseudoRow
    implements Serializable {
        private static final long serialVersionUID = 8085570439751032499L;
        public int[] cols = new int[3];

        public PseudoRow(int col1, int col2, int col3) {
            this.cols[0] = col1;
            this.cols[1] = col2;
            this.cols[2] = col3;
        }

        public int getColumn(int colIndex) {
            return this.cols[colIndex];
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("[");
            buf.append(this.cols[0]);
            buf.append(",");
            buf.append(this.cols[1]);
            buf.append(",");
            buf.append(this.cols[2]);
            buf.append("]");
            return buf.toString();
        }

        public boolean equals(Object o) {
            if (!(o instanceof PseudoRow)) {
                return false;
            }
            PseudoRow row = (PseudoRow)o;
            if (this.getColumn(0) != row.getColumn(0)) {
                return false;
            }
            if (this.getColumn(1) != row.getColumn(1)) {
                return false;
            }
            return this.getColumn(2) == row.getColumn(2);
        }
    }
}

