/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.IteratorChain;

public class IteratorChainTest
extends AbstractIteratorTest<String> {
    protected String[] testArray = new String[]{"One", "Two", "Three", "Four", "Five", "Six"};
    protected List<String> list1 = null;
    protected List<String> list2 = null;
    protected List<String> list3 = null;

    public IteratorChainTest(String testName) {
        super(testName);
    }

    public void setUp() {
        this.list1 = new ArrayList<String>();
        this.list1.add("One");
        this.list1.add("Two");
        this.list1.add("Three");
        this.list2 = new ArrayList<String>();
        this.list2.add("Four");
        this.list3 = new ArrayList<String>();
        this.list3.add("Five");
        this.list3.add("Six");
    }

    @Override
    public IteratorChain<String> makeEmptyIterator() {
        ArrayList list = new ArrayList();
        return new IteratorChain(list.iterator());
    }

    @Override
    public IteratorChain<String> makeObject() {
        IteratorChain chain = new IteratorChain();
        chain.addIterator(this.list1.iterator());
        chain.addIterator(this.list2.iterator());
        chain.addIterator(this.list3.iterator());
        return chain;
    }

    public void testIterator() {
        IteratorChain<String> iter = this.makeObject();
        for (String testValue : this.testArray) {
            Object iterValue = iter.next();
            IteratorChainTest.assertEquals((String)"Iteration value is correct", (Object)testValue, iterValue);
        }
        IteratorChainTest.assertTrue((String)"Iterator should now be empty", (!iter.hasNext() ? 1 : 0) != 0);
        try {
            iter.next();
        }
        catch (Exception e) {
            IteratorChainTest.assertTrue((String)"NoSuchElementException must be thrown", (boolean)e.getClass().equals(new NoSuchElementException().getClass()));
        }
    }

    public void testRemoveFromFilteredIterator() {
        Predicate<Integer> myPredicate = new Predicate<Integer>(){

            public boolean evaluate(Integer i) {
                return i.compareTo(4) < 0;
            }
        };
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        list1.add(1);
        list1.add(2);
        list2.add(3);
        list2.add(4);
        Iterator it1 = IteratorUtils.filteredIterator(list1.iterator(), (Predicate)myPredicate);
        Iterator it2 = IteratorUtils.filteredIterator(list2.iterator(), (Predicate)myPredicate);
        Iterator it = IteratorUtils.chainedIterator((Iterator)it1, (Iterator)it2);
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        IteratorChainTest.assertEquals((int)0, (int)list1.size());
        IteratorChainTest.assertEquals((int)1, (int)list2.size());
    }

    @Override
    public void testRemove() {
        IteratorChain<String> iter = this.makeObject();
        try {
            iter.remove();
            IteratorChainTest.fail((String)"Calling remove before the first call to next() should throw an exception");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        for (String testValue : this.testArray) {
            String iterValue = (String)iter.next();
            IteratorChainTest.assertEquals((String)"Iteration value is correct", (String)testValue, (String)iterValue);
            if (iterValue.equals("Four")) continue;
            iter.remove();
        }
        IteratorChainTest.assertTrue((String)"List is empty", (this.list1.size() == 0 ? 1 : 0) != 0);
        IteratorChainTest.assertTrue((String)"List is empty", (this.list2.size() == 1 ? 1 : 0) != 0);
        IteratorChainTest.assertTrue((String)"List is empty", (this.list3.size() == 0 ? 1 : 0) != 0);
    }

    public void testFirstIteratorIsEmptyBug() {
        ArrayList empty = new ArrayList();
        ArrayList<String> notEmpty = new ArrayList<String>();
        notEmpty.add("A");
        notEmpty.add("B");
        notEmpty.add("C");
        IteratorChain chain = new IteratorChain();
        chain.addIterator(empty.iterator());
        chain.addIterator(notEmpty.iterator());
        IteratorChainTest.assertTrue((String)"should have next", (boolean)chain.hasNext());
        IteratorChainTest.assertEquals((String)"A", (String)((String)chain.next()));
        IteratorChainTest.assertTrue((String)"should have next", (boolean)chain.hasNext());
        IteratorChainTest.assertEquals((String)"B", (String)((String)chain.next()));
        IteratorChainTest.assertTrue((String)"should have next", (boolean)chain.hasNext());
        IteratorChainTest.assertEquals((String)"C", (String)((String)chain.next()));
        IteratorChainTest.assertTrue((String)"should not have next", (!chain.hasNext() ? 1 : 0) != 0);
    }

    public void testEmptyChain() {
        IteratorChain chain = new IteratorChain();
        IteratorChainTest.assertEquals((boolean)false, (boolean)chain.hasNext());
        try {
            chain.next();
            IteratorChainTest.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        try {
            chain.remove();
            IteratorChainTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

