/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.apache.commons.collections4.iterators.LoopingIterator;

public class LoopingIteratorTest
extends TestCase {
    public void testConstructorEx() throws Exception {
        try {
            new LoopingIterator(null);
            LoopingIteratorTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testLooping0() throws Exception {
        ArrayList list = new ArrayList();
        LoopingIterator loop = new LoopingIterator(list);
        LoopingIteratorTest.assertTrue((String)"hasNext should return false", (!loop.hasNext() ? 1 : 0) != 0);
        try {
            loop.next();
            LoopingIteratorTest.fail((String)"NoSuchElementException was not thrown during next() call.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testLooping1() throws Exception {
        List<String> list = Arrays.asList("a");
        LoopingIterator loop = new LoopingIterator(list);
        LoopingIteratorTest.assertTrue((String)"1st hasNext should return true", (boolean)loop.hasNext());
        LoopingIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        LoopingIteratorTest.assertTrue((String)"2nd hasNext should return true", (boolean)loop.hasNext());
        LoopingIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        LoopingIteratorTest.assertTrue((String)"3rd hasNext should return true", (boolean)loop.hasNext());
        LoopingIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
    }

    public void testLooping2() throws Exception {
        List<String> list = Arrays.asList("a", "b");
        LoopingIterator loop = new LoopingIterator(list);
        LoopingIteratorTest.assertTrue((String)"1st hasNext should return true", (boolean)loop.hasNext());
        LoopingIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        LoopingIteratorTest.assertTrue((String)"2nd hasNext should return true", (boolean)loop.hasNext());
        LoopingIteratorTest.assertEquals((String)"b", (String)((String)loop.next()));
        LoopingIteratorTest.assertTrue((String)"3rd hasNext should return true", (boolean)loop.hasNext());
        LoopingIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
    }

    public void testLooping3() throws Exception {
        List<String> list = Arrays.asList("a", "b", "c");
        LoopingIterator loop = new LoopingIterator(list);
        LoopingIteratorTest.assertTrue((String)"1st hasNext should return true", (boolean)loop.hasNext());
        LoopingIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        LoopingIteratorTest.assertTrue((String)"2nd hasNext should return true", (boolean)loop.hasNext());
        LoopingIteratorTest.assertEquals((String)"b", (String)((String)loop.next()));
        LoopingIteratorTest.assertTrue((String)"3rd hasNext should return true", (boolean)loop.hasNext());
        LoopingIteratorTest.assertEquals((String)"c", (String)((String)loop.next()));
        LoopingIteratorTest.assertTrue((String)"4th hasNext should return true", (boolean)loop.hasNext());
        LoopingIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
    }

    public void testRemoving1() throws Exception {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("a", "b", "c"));
        LoopingIterator loop = new LoopingIterator(list);
        LoopingIteratorTest.assertEquals((String)"list should have 3 elements.", (int)3, (int)list.size());
        LoopingIteratorTest.assertTrue((String)"1st hasNext should return true", (boolean)loop.hasNext());
        LoopingIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        loop.remove();
        LoopingIteratorTest.assertEquals((String)"list should have 2 elements.", (int)2, (int)list.size());
        LoopingIteratorTest.assertTrue((String)"2nd hasNext should return true", (boolean)loop.hasNext());
        LoopingIteratorTest.assertEquals((String)"b", (String)((String)loop.next()));
        loop.remove();
        LoopingIteratorTest.assertEquals((String)"list should have 1 elements.", (int)1, (int)list.size());
        LoopingIteratorTest.assertTrue((String)"3rd hasNext should return true", (boolean)loop.hasNext());
        LoopingIteratorTest.assertEquals((String)"c", (String)((String)loop.next()));
        loop.remove();
        LoopingIteratorTest.assertEquals((String)"list should have 0 elements.", (int)0, (int)list.size());
        LoopingIteratorTest.assertFalse((String)"4th hasNext should return false", (boolean)loop.hasNext());
        try {
            loop.next();
            LoopingIteratorTest.fail((String)"Expected NoSuchElementException to be thrown.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testReset() throws Exception {
        List<String> list = Arrays.asList("a", "b", "c");
        LoopingIterator loop = new LoopingIterator(list);
        LoopingIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        LoopingIteratorTest.assertEquals((String)"b", (String)((String)loop.next()));
        loop.reset();
        LoopingIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        loop.reset();
        LoopingIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        LoopingIteratorTest.assertEquals((String)"b", (String)((String)loop.next()));
        LoopingIteratorTest.assertEquals((String)"c", (String)((String)loop.next()));
        loop.reset();
        LoopingIteratorTest.assertEquals((String)"a", (String)((String)loop.next()));
        LoopingIteratorTest.assertEquals((String)"b", (String)((String)loop.next()));
        LoopingIteratorTest.assertEquals((String)"c", (String)((String)loop.next()));
    }

    public void testSize() throws Exception {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("a", "b", "c"));
        LoopingIterator loop = new LoopingIterator(list);
        LoopingIteratorTest.assertEquals((int)3, (int)loop.size());
        loop.next();
        loop.next();
        LoopingIteratorTest.assertEquals((int)3, (int)loop.size());
        loop.reset();
        LoopingIteratorTest.assertEquals((int)3, (int)loop.size());
        loop.next();
        loop.remove();
        LoopingIteratorTest.assertEquals((int)2, (int)loop.size());
    }
}

