/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.SkippingIterator;
import org.junit.Test;

public class SkippingIteratorTest<E>
extends AbstractIteratorTest<E> {
    private String[] testArray = new String[]{"a", "b", "c", "d", "e", "f", "g"};
    private List<E> testList;

    public SkippingIteratorTest(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.testList = Arrays.asList((Object[])this.testArray);
    }

    @Override
    public Iterator<E> makeEmptyIterator() {
        return new SkippingIterator(Collections.emptyList().iterator(), 0L);
    }

    @Override
    public Iterator<E> makeObject() {
        return new SkippingIterator(new ArrayList<E>(this.testList).iterator(), 1L);
    }

    @Test
    public void testSkipping() {
        SkippingIterator iter = new SkippingIterator(this.testList.iterator(), 2L);
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"c", iter.next());
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"d", iter.next());
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"e", iter.next());
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"f", iter.next());
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"g", iter.next());
        SkippingIteratorTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            SkippingIteratorTest.fail((String)"Expected NoSuchElementException.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testSameAsDecorated() {
        SkippingIterator iter = new SkippingIterator(this.testList.iterator(), 0L);
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"a", iter.next());
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"b", iter.next());
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"c", iter.next());
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"d", iter.next());
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"e", iter.next());
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"f", iter.next());
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"g", iter.next());
        SkippingIteratorTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            SkippingIteratorTest.fail((String)"Expected NoSuchElementException.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testOffsetGreaterThanSize() {
        SkippingIterator iter = new SkippingIterator(this.testList.iterator(), 10L);
        SkippingIteratorTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            SkippingIteratorTest.fail((String)"Expected NoSuchElementException.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testNegativeOffset() {
        try {
            new SkippingIterator(this.testList.iterator(), -1L);
            SkippingIteratorTest.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveWithoutCallingNext() {
        ArrayList<E> testListCopy = new ArrayList<E>(this.testList);
        SkippingIterator iter = new SkippingIterator(testListCopy.iterator(), 1L);
        try {
            iter.remove();
            SkippingIteratorTest.fail((String)"Expected IllegalStateException.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveCalledTwice() {
        ArrayList<E> testListCopy = new ArrayList<E>(this.testList);
        SkippingIterator iter = new SkippingIterator(testListCopy.iterator(), 1L);
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"b", iter.next());
        iter.remove();
        try {
            iter.remove();
            SkippingIteratorTest.fail((String)"Expected IllegalStateException.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveFirst() {
        ArrayList<E> testListCopy = new ArrayList<E>(this.testList);
        SkippingIterator iter = new SkippingIterator(testListCopy.iterator(), 4L);
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"e", iter.next());
        iter.remove();
        SkippingIteratorTest.assertFalse((boolean)testListCopy.contains("e"));
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"f", iter.next());
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"g", iter.next());
        SkippingIteratorTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            SkippingIteratorTest.fail((String)"Expected NoSuchElementException.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveMiddle() {
        ArrayList<E> testListCopy = new ArrayList<E>(this.testList);
        SkippingIterator iter = new SkippingIterator(testListCopy.iterator(), 3L);
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"d", iter.next());
        iter.remove();
        SkippingIteratorTest.assertFalse((boolean)testListCopy.contains("d"));
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"e", iter.next());
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"f", iter.next());
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"g", iter.next());
        SkippingIteratorTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            SkippingIteratorTest.fail((String)"Expected NoSuchElementException.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveLast() {
        ArrayList<E> testListCopy = new ArrayList<E>(this.testList);
        SkippingIterator iter = new SkippingIterator(testListCopy.iterator(), 5L);
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"f", iter.next());
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"g", iter.next());
        SkippingIteratorTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            SkippingIteratorTest.fail((String)"Expected NoSuchElementException.");
        }
        catch (NoSuchElementException nsee) {
            // empty catch block
        }
        iter.remove();
        SkippingIteratorTest.assertFalse((boolean)testListCopy.contains("g"));
        SkippingIteratorTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            SkippingIteratorTest.fail((String)"Expected NoSuchElementException.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveUnsupported() {
        AbstractIteratorDecorator mockIterator = new AbstractIteratorDecorator<E>(this.testList.iterator()){

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        SkippingIterator iter = new SkippingIterator((Iterator)mockIterator, 1L);
        SkippingIteratorTest.assertTrue((boolean)iter.hasNext());
        SkippingIteratorTest.assertEquals((Object)"b", iter.next());
        try {
            iter.remove();
            SkippingIteratorTest.fail((String)"Expected UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

