/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.list.AbstractListTest;
import org.apache.commons.collections4.list.UnmodifiableList;

public class UnmodifiableListTest<E>
extends AbstractListTest<E> {
    protected UnmodifiableList<E> list;
    protected ArrayList<E> array;

    public UnmodifiableListTest(String testName) {
        super(testName);
    }

    @Override
    public UnmodifiableList<E> makeObject() {
        return new UnmodifiableList(new ArrayList());
    }

    @Override
    public UnmodifiableList<E> makeFullCollection() {
        ArrayList list = new ArrayList();
        list.addAll(Arrays.asList(this.getFullElements()));
        return new UnmodifiableList(list);
    }

    @Override
    public boolean isSetSupported() {
        return false;
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    protected void setupList() {
        this.list = this.makeFullCollection();
        this.array = new ArrayList();
        this.array.add(1);
    }

    public void testUnmodifiable() {
        this.setupList();
        this.verifyUnmodifiable((List<E>)this.list);
        this.verifyUnmodifiable(this.list.subList(0, 2));
    }

    public void testDecorateFactory() {
        UnmodifiableList<E> list = this.makeObject();
        UnmodifiableListTest.assertSame(list, (Object)UnmodifiableList.unmodifiableList(list));
        try {
            UnmodifiableList.unmodifiableList(null);
            UnmodifiableListTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void verifyUnmodifiable(List<E> list) {
        try {
            list.add(0, 0);
            UnmodifiableListTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            list.add(0);
            UnmodifiableListTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            list.addAll(0, this.array);
            UnmodifiableListTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            list.addAll(this.array);
            UnmodifiableListTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            list.clear();
            UnmodifiableListTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            list.remove(0);
            UnmodifiableListTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            list.remove((Object)0);
            UnmodifiableListTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            list.removeAll(this.array);
            UnmodifiableListTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            list.retainAll(this.array);
            UnmodifiableListTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            list.set(0, 0);
            UnmodifiableListTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testUnmodifiableIterator() {
        this.setupList();
        Iterator iterator = this.list.iterator();
        try {
            iterator.next();
            iterator.remove();
            UnmodifiableListTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

