/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.AbstractHashedMap;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.collections4.map.MultiKeyMap;

public class MultiKeyMapTest<K, V>
extends AbstractIterableMapTest<MultiKey<? extends K>, V> {
    static final Integer I1 = 1;
    static final Integer I2 = 2;
    static final Integer I3 = 3;
    static final Integer I4 = 4;
    static final Integer I5 = 5;
    static final Integer I6 = 6;
    static final Integer I7 = 7;
    static final Integer I8 = 8;

    public MultiKeyMapTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(MultiKeyMapTest.class);
    }

    @Override
    public MultiKeyMap<K, V> makeObject() {
        return new MultiKeyMap();
    }

    public MultiKey<K>[] getSampleKeys() {
        return this.getMultiKeyKeys();
    }

    private MultiKey<K>[] getMultiKeyKeys() {
        return new MultiKey[]{new MultiKey((Object)I1, (Object)I2), new MultiKey((Object)I2, (Object)I3), new MultiKey((Object)I3, (Object)I4), new MultiKey((Object)I1, (Object)I1, (Object)I2), new MultiKey((Object)I2, (Object)I3, (Object)I4), new MultiKey((Object)I3, (Object)I7, (Object)I6), new MultiKey((Object)I1, (Object)I1, (Object)I2, (Object)I3), new MultiKey((Object)I2, (Object)I4, (Object)I5, (Object)I6), new MultiKey((Object)I3, (Object)I6, (Object)I7, (Object)I8), new MultiKey((Object)I1, (Object)I1, (Object)I2, (Object)I3, (Object)I4), new MultiKey((Object)I2, (Object)I3, (Object)I4, (Object)I5, (Object)I6), new MultiKey((Object)I3, (Object)I5, (Object)I6, (Object)I7, (Object)I8)};
    }

    @Override
    public V[] getSampleValues() {
        return new Object[]{"2A", "2B", "2C", "3D", "3E", "3F", "4G", "4H", "4I", "5J", "5K", "5L"};
    }

    @Override
    public V[] getNewSampleValues() {
        return new Object[]{"1a", "1b", "1c", "2d", "2e", "2f", "3g", "3h", "3i", "4j", "4k", "4l"};
    }

    public MultiKey<K>[] getOtherKeys() {
        return new MultiKey[]{new MultiKey((Object)I1, (Object)I7), new MultiKey((Object)I1, (Object)I8), new MultiKey((Object)I2, (Object)I4), new MultiKey((Object)I2, (Object)I5)};
    }

    @Override
    public boolean isAllowNullKey() {
        return false;
    }

    public void testNullHandling() {
        this.resetFull();
        MultiKeyMapTest.assertEquals(null, this.map.get(null));
        MultiKeyMapTest.assertEquals((boolean)false, (boolean)this.map.containsKey(null));
        MultiKeyMapTest.assertEquals((boolean)false, (boolean)this.map.containsValue(null));
        MultiKeyMapTest.assertEquals(null, this.map.remove(null));
        MultiKeyMapTest.assertEquals((boolean)false, (boolean)this.map.entrySet().contains(null));
        MultiKeyMapTest.assertEquals((boolean)false, (boolean)this.map.keySet().contains(null));
        MultiKeyMapTest.assertEquals((boolean)false, (boolean)this.map.values().contains(null));
        try {
            this.map.put(null, null);
            MultiKeyMapTest.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        MultiKeyMapTest.assertEquals(null, this.map.put(new MultiKey(null, null), null));
        try {
            this.map.put(null, new Object());
            MultiKeyMapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testMultiKeyGet() {
        this.resetFull();
        MultiKeyMap<K, V> multimap = this.getMap();
        MultiKey<K>[] keys = this.getMultiKeyKeys();
        V[] values = this.getSampleValues();
        block6: for (int i = 0; i < keys.length; ++i) {
            MultiKey<K> key = keys[i];
            V value = values[i];
            switch (key.size()) {
                case 2: {
                    MultiKeyMapTest.assertEquals(value, (Object)multimap.get(key.getKey(0), key.getKey(1)));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(null, key.getKey(1)));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(key.getKey(0), null));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(null, null));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(key.getKey(0), key.getKey(1), null));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(key.getKey(0), key.getKey(1), null, null));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(key.getKey(0), key.getKey(1), null, null, null));
                    continue block6;
                }
                case 3: {
                    MultiKeyMapTest.assertEquals(value, (Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2)));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(null, key.getKey(1), key.getKey(2)));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(key.getKey(0), null, key.getKey(2)));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(key.getKey(0), key.getKey(1), null));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(null, null, null));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), null));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), null, null));
                    continue block6;
                }
                case 4: {
                    MultiKeyMapTest.assertEquals(value, (Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(null, key.getKey(1), key.getKey(2), key.getKey(3)));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(key.getKey(0), null, key.getKey(2), key.getKey(3)));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(key.getKey(0), key.getKey(1), null, key.getKey(3)));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), null));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(null, null, null, null));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), null));
                    continue block6;
                }
                case 5: {
                    MultiKeyMapTest.assertEquals(value, (Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(null, key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(key.getKey(0), null, key.getKey(2), key.getKey(3), key.getKey(4)));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(key.getKey(0), key.getKey(1), null, key.getKey(3), key.getKey(4)));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), null, key.getKey(4)));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), null));
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(null, null, null, null, null));
                    continue block6;
                }
                default: {
                    MultiKeyMapTest.fail((String)"Invalid key size");
                }
            }
        }
    }

    public void testMultiKeyContainsKey() {
        MultiKey<K>[] keys;
        this.resetFull();
        MultiKeyMap<K, V> multimap = this.getMap();
        block6: for (MultiKey<K> key : keys = this.getMultiKeyKeys()) {
            switch (key.size()) {
                case 2: {
                    MultiKeyMapTest.assertEquals((boolean)true, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(null, key.getKey(1)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), null));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(null, null));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), null));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), null, null));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), null, null, null));
                    continue block6;
                }
                case 3: {
                    MultiKeyMapTest.assertEquals((boolean)true, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(null, key.getKey(1), key.getKey(2)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), null, key.getKey(2)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), null));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(null, null, null));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), null));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), null, null));
                    continue block6;
                }
                case 4: {
                    MultiKeyMapTest.assertEquals((boolean)true, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(null, key.getKey(1), key.getKey(2), key.getKey(3)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), null, key.getKey(2), key.getKey(3)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), null, key.getKey(3)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), null));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(null, null, null, null));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), null));
                    continue block6;
                }
                case 5: {
                    MultiKeyMapTest.assertEquals((boolean)true, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(null, key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), null, key.getKey(2), key.getKey(3), key.getKey(4)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), null, key.getKey(3), key.getKey(4)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), null, key.getKey(4)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), null));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(null, null, null, null, null));
                    continue block6;
                }
                default: {
                    MultiKeyMapTest.fail((String)"Invalid key size");
                }
            }
        }
    }

    public void testMultiKeyPut() {
        MultiKey<K>[] keys = this.getMultiKeyKeys();
        V[] values = this.getSampleValues();
        block6: for (int i = 0; i < keys.length; ++i) {
            MultiKeyMap multimap = new MultiKeyMap();
            MultiKey<K> key = keys[i];
            V value = values[i];
            switch (key.size()) {
                case 2: {
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.put(key.getKey(0), key.getKey(1), value));
                    MultiKeyMapTest.assertEquals((int)1, (int)multimap.size());
                    MultiKeyMapTest.assertEquals(value, (Object)multimap.get(key.getKey(0), key.getKey(1)));
                    MultiKeyMapTest.assertEquals((boolean)true, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1)));
                    MultiKeyMapTest.assertEquals((boolean)true, (boolean)multimap.containsKey((Object)new MultiKey(key.getKey(0), key.getKey(1))));
                    MultiKeyMapTest.assertEquals(value, (Object)multimap.put(key.getKey(0), key.getKey(1), null));
                    MultiKeyMapTest.assertEquals((int)1, (int)multimap.size());
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(key.getKey(0), key.getKey(1)));
                    MultiKeyMapTest.assertEquals((boolean)true, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1)));
                    continue block6;
                }
                case 3: {
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.put(key.getKey(0), key.getKey(1), key.getKey(2), value));
                    MultiKeyMapTest.assertEquals((int)1, (int)multimap.size());
                    MultiKeyMapTest.assertEquals(value, (Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2)));
                    MultiKeyMapTest.assertEquals((boolean)true, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2)));
                    MultiKeyMapTest.assertEquals((boolean)true, (boolean)multimap.containsKey((Object)new MultiKey(key.getKey(0), key.getKey(1), key.getKey(2))));
                    MultiKeyMapTest.assertEquals(value, (Object)multimap.put(key.getKey(0), key.getKey(1), key.getKey(2), null));
                    MultiKeyMapTest.assertEquals((int)1, (int)multimap.size());
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2)));
                    MultiKeyMapTest.assertEquals((boolean)true, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2)));
                    continue block6;
                }
                case 4: {
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.put(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), value));
                    MultiKeyMapTest.assertEquals((int)1, (int)multimap.size());
                    MultiKeyMapTest.assertEquals(value, (Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    MultiKeyMapTest.assertEquals((boolean)true, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    MultiKeyMapTest.assertEquals((boolean)true, (boolean)multimap.containsKey((Object)new MultiKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3))));
                    MultiKeyMapTest.assertEquals(value, (Object)multimap.put(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), null));
                    MultiKeyMapTest.assertEquals((int)1, (int)multimap.size());
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    MultiKeyMapTest.assertEquals((boolean)true, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    continue block6;
                }
                case 5: {
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.put(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4), value));
                    MultiKeyMapTest.assertEquals((int)1, (int)multimap.size());
                    MultiKeyMapTest.assertEquals(value, (Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    MultiKeyMapTest.assertEquals((boolean)true, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    MultiKeyMapTest.assertEquals((boolean)true, (boolean)multimap.containsKey((Object)new MultiKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4))));
                    MultiKeyMapTest.assertEquals(value, (Object)multimap.put(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4), null));
                    MultiKeyMapTest.assertEquals((int)1, (int)multimap.size());
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    MultiKeyMapTest.assertEquals((boolean)true, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    continue block6;
                }
                default: {
                    MultiKeyMapTest.fail((String)"Invalid key size");
                }
            }
        }
    }

    public void testMultiKeyPutWithNullKey() {
        MultiKeyMap map = new MultiKeyMap();
        map.put((Object)"a", null, (Object)"value1");
        map.put((Object)"b", null, (Object)"value2");
        map.put((Object)"c", null, (Object)"value3");
        map.put((Object)"a", (Object)"z", (Object)"value4");
        map.put((Object)"a", null, (Object)"value5");
        map.put(null, (Object)"a", (Object)"value6");
        map.put(null, null, (Object)"value7");
        MultiKeyMapTest.assertEquals((int)6, (int)map.size());
        MultiKeyMapTest.assertEquals((String)"value5", (String)((String)map.get((Object)"a", null)));
        MultiKeyMapTest.assertEquals((String)"value4", (String)((String)map.get((Object)"a", (Object)"z")));
        MultiKeyMapTest.assertEquals((String)"value6", (String)((String)map.get(null, (Object)"a")));
    }

    public void testMultiKeyRemove() {
        MultiKey<K>[] keys = this.getMultiKeyKeys();
        V[] values = this.getSampleValues();
        block6: for (int i = 0; i < keys.length; ++i) {
            this.resetFull();
            MultiKeyMap<K, V> multimap = this.getMap();
            int size = multimap.size();
            MultiKey<K> key = keys[i];
            V value = values[i];
            switch (key.size()) {
                case 2: {
                    MultiKeyMapTest.assertEquals((boolean)true, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1)));
                    MultiKeyMapTest.assertEquals(value, (Object)multimap.removeMultiKey(key.getKey(0), key.getKey(1)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1)));
                    MultiKeyMapTest.assertEquals((int)(size - 1), (int)multimap.size());
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.removeMultiKey(key.getKey(0), key.getKey(1)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1)));
                    continue block6;
                }
                case 3: {
                    MultiKeyMapTest.assertEquals((boolean)true, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2)));
                    MultiKeyMapTest.assertEquals(value, (Object)multimap.removeMultiKey(key.getKey(0), key.getKey(1), key.getKey(2)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2)));
                    MultiKeyMapTest.assertEquals((int)(size - 1), (int)multimap.size());
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.removeMultiKey(key.getKey(0), key.getKey(1), key.getKey(2)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2)));
                    continue block6;
                }
                case 4: {
                    MultiKeyMapTest.assertEquals((boolean)true, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    MultiKeyMapTest.assertEquals(value, (Object)multimap.removeMultiKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    MultiKeyMapTest.assertEquals((int)(size - 1), (int)multimap.size());
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.removeMultiKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    continue block6;
                }
                case 5: {
                    MultiKeyMapTest.assertEquals((boolean)true, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    MultiKeyMapTest.assertEquals(value, (Object)multimap.removeMultiKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    MultiKeyMapTest.assertEquals((int)(size - 1), (int)multimap.size());
                    MultiKeyMapTest.assertEquals(null, (Object)multimap.removeMultiKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    MultiKeyMapTest.assertEquals((boolean)false, (boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    continue block6;
                }
                default: {
                    MultiKeyMapTest.fail((String)"Invalid key size");
                }
            }
        }
    }

    public void testMultiKeyRemoveAll1() {
        this.resetFull();
        MultiKeyMap<K, V> multimap = this.getMap();
        MultiKeyMapTest.assertEquals((int)12, (int)multimap.size());
        multimap.removeAll((Object)I1);
        MultiKeyMapTest.assertEquals((int)8, (int)multimap.size());
        MapIterator it = multimap.mapIterator();
        while (it.hasNext()) {
            MultiKey key = (MultiKey)it.next();
            MultiKeyMapTest.assertEquals((boolean)false, (boolean)I1.equals(key.getKey(0)));
        }
    }

    public void testMultiKeyRemoveAll2() {
        this.resetFull();
        MultiKeyMap<K, V> multimap = this.getMap();
        MultiKeyMapTest.assertEquals((int)12, (int)multimap.size());
        multimap.removeAll((Object)I2, (Object)I3);
        MultiKeyMapTest.assertEquals((int)9, (int)multimap.size());
        MapIterator it = multimap.mapIterator();
        while (it.hasNext()) {
            MultiKey key = (MultiKey)it.next();
            MultiKeyMapTest.assertEquals((boolean)false, (I2.equals(key.getKey(0)) && I3.equals(key.getKey(1)) ? 1 : 0) != 0);
        }
    }

    public void testMultiKeyRemoveAll3() {
        this.resetFull();
        MultiKeyMap<K, V> multimap = this.getMap();
        MultiKeyMapTest.assertEquals((int)12, (int)multimap.size());
        multimap.removeAll((Object)I1, (Object)I1, (Object)I2);
        MultiKeyMapTest.assertEquals((int)9, (int)multimap.size());
        MapIterator it = multimap.mapIterator();
        while (it.hasNext()) {
            MultiKey key = (MultiKey)it.next();
            MultiKeyMapTest.assertEquals((boolean)false, (I1.equals(key.getKey(0)) && I1.equals(key.getKey(1)) && I2.equals(key.getKey(2)) ? 1 : 0) != 0);
        }
    }

    public void testMultiKeyRemoveAll4() {
        this.resetFull();
        MultiKeyMap<K, V> multimap = this.getMap();
        MultiKeyMapTest.assertEquals((int)12, (int)multimap.size());
        multimap.removeAll((Object)I1, (Object)I1, (Object)I2, (Object)I3);
        MultiKeyMapTest.assertEquals((int)10, (int)multimap.size());
        MapIterator it = multimap.mapIterator();
        while (it.hasNext()) {
            MultiKey key = (MultiKey)it.next();
            MultiKeyMapTest.assertEquals((boolean)false, (I1.equals(key.getKey(0)) && I1.equals(key.getKey(1)) && I2.equals(key.getKey(2)) && key.size() >= 4 && I3.equals(key.getKey(3)) ? 1 : 0) != 0);
        }
    }

    public void testClone() {
        MultiKeyMap map = new MultiKeyMap();
        map.put(new MultiKey((Object)I1, (Object)I2), (Object)"1-2");
        MultiKeyMap cloned = map.clone();
        MultiKeyMapTest.assertEquals((int)map.size(), (int)cloned.size());
        MultiKeyMapTest.assertSame((Object)map.get((Object)new MultiKey((Object)I1, (Object)I2)), cloned.get(new MultiKey((Object)I1, (Object)I2)));
    }

    public void testLRUMultiKeyMap() {
        MultiKeyMap map = MultiKeyMap.multiKeyMap((AbstractHashedMap)new LRUMap(2));
        map.put((Object)I1, (Object)I2, (Object)"1-2");
        map.put((Object)I1, (Object)I3, (Object)"1-1");
        MultiKeyMapTest.assertEquals((int)2, (int)map.size());
        map.put((Object)I1, (Object)I4, (Object)"1-4");
        MultiKeyMapTest.assertEquals((int)2, (int)map.size());
        MultiKeyMapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)I1, (Object)I3));
        MultiKeyMapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)I1, (Object)I4));
        MultiKeyMapTest.assertEquals((boolean)false, (boolean)map.containsKey((Object)I1, (Object)I2));
        MultiKeyMap cloned = map.clone();
        MultiKeyMapTest.assertEquals((int)2, (int)map.size());
        MultiKeyMapTest.assertEquals((boolean)true, (boolean)cloned.containsKey((Object)I1, (Object)I3));
        MultiKeyMapTest.assertEquals((boolean)true, (boolean)cloned.containsKey((Object)I1, (Object)I4));
        MultiKeyMapTest.assertEquals((boolean)false, (boolean)cloned.containsKey((Object)I1, (Object)I2));
        cloned.put((Object)I1, (Object)I5, (Object)"1-5");
        MultiKeyMapTest.assertEquals((int)2, (int)cloned.size());
        MultiKeyMapTest.assertEquals((boolean)true, (boolean)cloned.containsKey((Object)I1, (Object)I4));
        MultiKeyMapTest.assertEquals((boolean)true, (boolean)cloned.containsKey((Object)I1, (Object)I5));
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public MultiKeyMap<K, V> getMap() {
        return (MultiKeyMap)super.getMap();
    }
}

