/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.map.AbstractMapTest;
import org.apache.commons.collections4.map.PassiveExpiringMap;

public class PassiveExpiringMapTest<K, V>
extends AbstractMapTest<K, V> {
    public static Test suite() {
        return BulkTest.makeSuite(PassiveExpiringMapTest.class);
    }

    public PassiveExpiringMapTest(String testName) {
        super(testName);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    private Map<Integer, String> makeDecoratedTestMap() {
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        m.put(1, "one");
        m.put(2, "two");
        m.put(3, "three");
        m.put(4, "four");
        m.put(5, "five");
        m.put(6, "six");
        return new PassiveExpiringMap((PassiveExpiringMap.ExpirationPolicy)new TestExpirationPolicy(), m);
    }

    @Override
    public Map<K, V> makeObject() {
        return new PassiveExpiringMap();
    }

    private Map<Integer, String> makeTestMap() {
        PassiveExpiringMap m = new PassiveExpiringMap((PassiveExpiringMap.ExpirationPolicy)new TestExpirationPolicy());
        m.put(1, "one");
        m.put(2, "two");
        m.put(3, "three");
        m.put(4, "four");
        m.put(5, "five");
        m.put(6, "six");
        return m;
    }

    public void testConstructors() {
        try {
            Map map = null;
            new PassiveExpiringMap(map);
            PassiveExpiringMapTest.fail((String)"constructor - exception should have been thrown.");
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            PassiveExpiringMap.ExpirationPolicy policy = null;
            new PassiveExpiringMap(policy);
            PassiveExpiringMapTest.fail((String)"constructor - exception should have been thrown.");
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            TimeUnit unit = null;
            new PassiveExpiringMap(10L, unit);
            PassiveExpiringMapTest.fail((String)"constructor - exception should have been thrown.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testContainsKey() {
        Map<Integer, String> m = this.makeTestMap();
        PassiveExpiringMapTest.assertFalse((boolean)m.containsKey(1));
        PassiveExpiringMapTest.assertFalse((boolean)m.containsKey(3));
        PassiveExpiringMapTest.assertFalse((boolean)m.containsKey(5));
        PassiveExpiringMapTest.assertTrue((boolean)m.containsKey(2));
        PassiveExpiringMapTest.assertTrue((boolean)m.containsKey(4));
        PassiveExpiringMapTest.assertTrue((boolean)m.containsKey(6));
    }

    public void testContainsValue() {
        Map<Integer, String> m = this.makeTestMap();
        PassiveExpiringMapTest.assertFalse((boolean)m.containsValue("one"));
        PassiveExpiringMapTest.assertFalse((boolean)m.containsValue("three"));
        PassiveExpiringMapTest.assertFalse((boolean)m.containsValue("five"));
        PassiveExpiringMapTest.assertTrue((boolean)m.containsValue("two"));
        PassiveExpiringMapTest.assertTrue((boolean)m.containsValue("four"));
        PassiveExpiringMapTest.assertTrue((boolean)m.containsValue("six"));
    }

    public void testDecoratedMap() {
        Map<Integer, String> m = this.makeDecoratedTestMap();
        PassiveExpiringMapTest.assertEquals((int)6, (int)m.size());
        PassiveExpiringMapTest.assertEquals((String)"one", (String)m.get(1));
        PassiveExpiringMapTest.assertEquals((String)"two", (String)m.get(2));
        m.remove(2);
        PassiveExpiringMapTest.assertEquals((int)5, (int)m.size());
        PassiveExpiringMapTest.assertEquals((String)"one", (String)m.get(1));
        PassiveExpiringMapTest.assertNull((Object)m.get(2));
        PassiveExpiringMapTest.assertNull((Object)m.get(2));
        m.put(2, "two");
        PassiveExpiringMapTest.assertEquals((int)6, (int)m.size());
        PassiveExpiringMapTest.assertEquals((String)"one", (String)m.get(1));
        PassiveExpiringMapTest.assertEquals((String)"two", (String)m.get(2));
        m.put(1, "one-one");
        PassiveExpiringMapTest.assertEquals((int)5, (int)m.size());
        PassiveExpiringMapTest.assertNull((Object)m.get(1));
        PassiveExpiringMapTest.assertEquals((String)"two", (String)m.get(2));
    }

    public void testEntrySet() {
        Map<Integer, String> m = this.makeTestMap();
        PassiveExpiringMapTest.assertEquals((int)3, (int)m.entrySet().size());
    }

    public void testGet() {
        Map<Integer, String> m = this.makeTestMap();
        PassiveExpiringMapTest.assertNull((Object)m.get(1));
        PassiveExpiringMapTest.assertEquals((String)"two", (String)m.get(2));
        PassiveExpiringMapTest.assertNull((Object)m.get(3));
        PassiveExpiringMapTest.assertEquals((String)"four", (String)m.get(4));
        PassiveExpiringMapTest.assertNull((Object)m.get(5));
        PassiveExpiringMapTest.assertEquals((String)"six", (String)m.get(6));
    }

    public void testIsEmpty() {
        Map<Integer, String> m = this.makeTestMap();
        PassiveExpiringMapTest.assertFalse((boolean)m.isEmpty());
        m = this.makeTestMap();
        m.remove(2);
        m.remove(4);
        m.remove(6);
        PassiveExpiringMapTest.assertTrue((boolean)m.isEmpty());
    }

    public void testKeySet() {
        Map<Integer, String> m = this.makeTestMap();
        PassiveExpiringMapTest.assertEquals((int)3, (int)m.keySet().size());
    }

    public void testSize() {
        Map<Integer, String> m = this.makeTestMap();
        PassiveExpiringMapTest.assertEquals((int)3, (int)m.size());
    }

    public void testValues() {
        Map<Integer, String> m = this.makeTestMap();
        PassiveExpiringMapTest.assertEquals((int)3, (int)m.values().size());
    }

    public void testZeroTimeToLive() {
        PassiveExpiringMap m = new PassiveExpiringMap(0L);
        m.put((Object)"a", (Object)"b");
        PassiveExpiringMapTest.assertNull((Object)m.get((Object)"a"));
    }

    public void testExpiration() {
        this.validateExpiration((Map<String, String>)new PassiveExpiringMap(500L), 500L);
        this.validateExpiration((Map<String, String>)new PassiveExpiringMap(1000L), 1000L);
        this.validateExpiration((Map<String, String>)new PassiveExpiringMap((PassiveExpiringMap.ExpirationPolicy)new PassiveExpiringMap.ConstantTimeToLiveExpirationPolicy(500L)), 500L);
        this.validateExpiration((Map<String, String>)new PassiveExpiringMap((PassiveExpiringMap.ExpirationPolicy)new PassiveExpiringMap.ConstantTimeToLiveExpirationPolicy(1L, TimeUnit.SECONDS)), 1000L);
    }

    private void validateExpiration(Map<String, String> map, long timeout) {
        map.put("a", "b");
        PassiveExpiringMapTest.assertNotNull((Object)map.get("a"));
        try {
            Thread.sleep(2L * timeout);
        }
        catch (InterruptedException e) {
            PassiveExpiringMapTest.fail();
        }
        PassiveExpiringMapTest.assertNull((Object)map.get("a"));
    }

    private static class TestExpirationPolicy
    implements PassiveExpiringMap.ExpirationPolicy<Integer, String> {
        private static final long serialVersionUID = 1L;

        private TestExpirationPolicy() {
        }

        public long expirationTime(Integer key, String value) {
            if (key == null) {
                return 0L;
            }
            if (key % 2 == 0) {
                return -1L;
            }
            return 0L;
        }
    }
}

