/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.collection.CompositeCollection;

public class CompositeCollectionTest<E>
extends AbstractCollectionTest<E> {
    protected CompositeCollection<E> c;
    protected Collection<E> one;
    protected Collection<E> two;

    public CompositeCollectionTest(String name) {
        super(name);
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public Collection<E> makeObject() {
        return new CompositeCollection();
    }

    @Override
    public Collection<E> makeConfirmedCollection() {
        return new HashSet();
    }

    @Override
    public E[] getFullElements() {
        return new Object[]{"1", "2", "3", "4"};
    }

    @Override
    public Collection<E> makeFullCollection() {
        E[] elements;
        CompositeCollection compositeCollection = new CompositeCollection();
        for (E element : elements = this.getFullElements()) {
            HashSet<E> summand = new HashSet<E>();
            summand.add(element);
            compositeCollection.addComposited(summand);
        }
        return compositeCollection;
    }

    @Override
    public Collection<E> makeConfirmedFullCollection() {
        HashSet<E> collection = new HashSet<E>();
        collection.addAll(Arrays.asList(this.getFullElements()));
        return collection;
    }

    @Override
    public void testUnsupportedRemove() {
        this.resetFull();
        try {
            this.getCollection().remove(null);
            CompositeCollectionTest.fail((String)"remove should raise UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.verify();
    }

    protected void setUpTest() {
        this.c = new CompositeCollection();
        this.one = new HashSet();
        this.two = new HashSet();
    }

    protected void setUpMutatorTest() {
        this.setUpTest();
        this.c.setMutator(new CompositeCollection.CollectionMutator<E>(){

            public boolean add(CompositeCollection<E> composite, List<Collection<E>> collections, E obj) {
                for (Collection coll : collections) {
                    coll.add(obj);
                }
                return true;
            }

            public boolean addAll(CompositeCollection<E> composite, List<Collection<E>> collections, Collection<? extends E> coll) {
                for (Collection collection : collections) {
                    collection.addAll(coll);
                }
                return true;
            }

            public boolean remove(CompositeCollection<E> composite, List<Collection<E>> collections, Object obj) {
                for (Collection collection : collections) {
                    collection.remove(obj);
                }
                return true;
            }
        });
    }

    public void testSize() {
        this.setUpTest();
        HashSet<String> set = new HashSet<String>();
        set.add("a");
        set.add("b");
        this.c.addComposited(set);
        CompositeCollectionTest.assertEquals((int)set.size(), (int)this.c.size());
    }

    public void testMultipleCollectionsSize() {
        this.setUpTest();
        HashSet<String> set = new HashSet<String>();
        set.add("a");
        set.add("b");
        this.c.addComposited(set);
        HashSet<String> other = new HashSet<String>();
        other.add("c");
        this.c.addComposited(other);
        CompositeCollectionTest.assertEquals((int)(set.size() + other.size()), (int)this.c.size());
    }

    public void testIsEmpty() {
        this.setUpTest();
        CompositeCollectionTest.assertTrue((boolean)this.c.isEmpty());
        HashSet<String> empty = new HashSet<String>();
        this.c.addComposited(empty);
        CompositeCollectionTest.assertTrue((boolean)this.c.isEmpty());
        empty.add("a");
        CompositeCollectionTest.assertTrue((!this.c.isEmpty() ? 1 : 0) != 0);
    }

    public void testIterator() {
        this.setUpTest();
        this.one.add("1");
        this.two.add("2");
        this.c.addComposited(this.one);
        this.c.addComposited(this.two);
        Iterator i = this.c.iterator();
        Object next = i.next();
        CompositeCollectionTest.assertTrue((boolean)this.c.contains(next));
        CompositeCollectionTest.assertTrue((boolean)this.one.contains(next));
        next = i.next();
        i.remove();
        CompositeCollectionTest.assertTrue((!this.c.contains(next) ? 1 : 0) != 0);
        CompositeCollectionTest.assertTrue((!this.two.contains(next) ? 1 : 0) != 0);
    }

    public void testClear() {
        this.setUpTest();
        this.one.add("1");
        this.two.add("2");
        this.c.addComposited(this.one, this.two);
        this.c.clear();
        CompositeCollectionTest.assertTrue((boolean)this.one.isEmpty());
        CompositeCollectionTest.assertTrue((boolean)this.two.isEmpty());
        CompositeCollectionTest.assertTrue((boolean)this.c.isEmpty());
    }

    public void testContainsAll() {
        this.setUpTest();
        this.one.add("1");
        this.two.add("1");
        this.c.addComposited(this.one);
        CompositeCollectionTest.assertTrue((boolean)this.c.containsAll(this.two));
    }

    public void testRetainAll() {
        this.setUpTest();
        this.one.add("1");
        this.one.add("2");
        this.two.add("1");
        this.c.addComposited(this.one);
        this.c.retainAll(this.two);
        CompositeCollectionTest.assertTrue((!this.c.contains((Object)"2") ? 1 : 0) != 0);
        CompositeCollectionTest.assertTrue((!this.one.contains("2") ? 1 : 0) != 0);
        CompositeCollectionTest.assertTrue((boolean)this.c.contains((Object)"1"));
        CompositeCollectionTest.assertTrue((boolean)this.one.contains("1"));
    }

    public void testAddAllMutator() {
        this.setUpTest();
        this.c.setMutator(new CompositeCollection.CollectionMutator<E>(){

            public boolean add(CompositeCollection<E> composite, List<Collection<E>> collections, E obj) {
                for (Collection collection : collections) {
                    collection.add(obj);
                }
                return true;
            }

            public boolean addAll(CompositeCollection<E> composite, List<Collection<E>> collections, Collection<? extends E> coll) {
                for (Collection collection : collections) {
                    collection.addAll(coll);
                }
                return true;
            }

            public boolean remove(CompositeCollection<E> composite, List<Collection<E>> collections, Object obj) {
                return false;
            }
        });
        this.c.addComposited(this.one);
        this.two.add("foo");
        this.c.addAll(this.two);
        CompositeCollectionTest.assertTrue((boolean)this.c.contains((Object)"foo"));
        CompositeCollectionTest.assertTrue((boolean)this.one.contains("foo"));
    }

    public void testAddMutator() {
        this.setUpTest();
        this.c.setMutator(new CompositeCollection.CollectionMutator<E>(){

            public boolean add(CompositeCollection<E> composite, List<Collection<E>> collections, E obj) {
                for (Collection collection : collections) {
                    collection.add(obj);
                }
                return true;
            }

            public boolean addAll(CompositeCollection<E> composite, List<Collection<E>> collections, Collection<? extends E> coll) {
                for (Collection collection : collections) {
                    collection.addAll(coll);
                }
                return true;
            }

            public boolean remove(CompositeCollection<E> composite, List<Collection<E>> collections, Object obj) {
                return false;
            }
        });
        this.c.addComposited(this.one);
        this.c.add((Object)"foo");
        CompositeCollectionTest.assertTrue((boolean)this.c.contains((Object)"foo"));
        CompositeCollectionTest.assertTrue((boolean)this.one.contains("foo"));
    }

    public void testToCollection() {
        this.setUpTest();
        this.one.add("1");
        this.two.add("2");
        this.c.addComposited(this.one, this.two);
        Collection foo = this.c.toCollection();
        CompositeCollectionTest.assertTrue((boolean)foo.containsAll((Collection<?>)this.c));
        CompositeCollectionTest.assertEquals((int)this.c.size(), (int)foo.size());
        this.one.add("3");
        CompositeCollectionTest.assertTrue((!foo.containsAll((Collection<?>)this.c) ? 1 : 0) != 0);
    }

    public void testAddAllToCollection() {
        this.setUpTest();
        this.one.add("1");
        this.two.add("2");
        this.c.addComposited(this.one, this.two);
        HashSet<E> toCollection = new HashSet<E>();
        toCollection.addAll((Collection<E>)this.c);
        CompositeCollectionTest.assertTrue((boolean)toCollection.containsAll((Collection<?>)this.c));
        CompositeCollectionTest.assertEquals((int)this.c.size(), (int)toCollection.size());
    }

    public void testRemove() {
        this.setUpMutatorTest();
        this.one.add("1");
        this.two.add("2");
        this.two.add("1");
        this.c.addComposited(this.one, this.two);
        this.c.remove((Object)"1");
        CompositeCollectionTest.assertTrue((!this.c.contains((Object)"1") ? 1 : 0) != 0);
        CompositeCollectionTest.assertTrue((!this.one.contains("1") ? 1 : 0) != 0);
        CompositeCollectionTest.assertTrue((!this.two.contains("1") ? 1 : 0) != 0);
    }

    public void testRemoveAll() {
        this.setUpMutatorTest();
        this.one.add("1");
        this.two.add("2");
        this.two.add("1");
        ArrayList<E> removing = new ArrayList<E>(this.one);
        this.c.addComposited(this.one, this.two);
        this.c.removeAll(removing);
        CompositeCollectionTest.assertTrue((!this.c.contains((Object)"1") ? 1 : 0) != 0);
        CompositeCollectionTest.assertTrue((!this.one.contains("1") ? 1 : 0) != 0);
        CompositeCollectionTest.assertTrue((!this.two.contains("1") ? 1 : 0) != 0);
    }

    public void testRemoveComposited() {
        this.setUpMutatorTest();
        this.one.add("1");
        this.two.add("2");
        this.two.add("1");
        this.c.addComposited(this.one, this.two);
        this.c.removeComposited(this.one);
        CompositeCollectionTest.assertTrue((boolean)this.c.contains((Object)"1"));
        CompositeCollectionTest.assertEquals((int)2, (int)this.c.size());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

